/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.aas.ui.providers.IRTTableSelectionProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableSelectionProvider;

public class RTTableSelectionProvider
extends TableSelectionProvider
implements IRTTableSelectionProvider {
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;
    private INattableModelManager manager;

    public RTTableSelectionProvider(INattableModelManager manager, SelectionLayer selectionLayer) {
        super(manager, selectionLayer);
        this.manager = manager;
        this.listeners = new ArrayList<ISelectionChangedListener>();
    }

    public synchronized void setSelection(ISelection selection) {
        super.setSelection(selection);
        if (selection.equals(this.currentSelection)) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
            for (ISelectionChangedListener current : this.listeners) {
                current.selectionChanged(event);
            }
        }
        this.currentSelection = selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        super.addSelectionChangedListener(listener);
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
        super.removeSelectionChangedListener(listener);
    }

    @Override
    public INattableModelManager getTableManager() {
        return this.manager;
    }
}

