/**
 * Copyright (c) 2022 CEA LIST and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 *   SPDX-License-Identifier: EPL-2.0
 *  
 *  Contributors:
 *  	CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Lang Enum</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.aas.AASPackage#getLangEnum()
 * @model
 * @generated
 */
public enum LangEnum implements Enumerator {
	/**
	 * The '<em><b>En</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EN_VALUE
	 * @generated
	 * @ordered
	 */
	EN(0, "en", "en"), /**
	 * The '<em><b>Ar</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AR_VALUE
	 * @generated
	 * @ordered
	 */
	AR(1, "ar", "ar"), /**
	 * The '<em><b>Cs</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CS_VALUE
	 * @generated
	 * @ordered
	 */
	CS(2, "cs", "cs"), /**
	 * The '<em><b>Da</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DA_VALUE
	 * @generated
	 * @ordered
	 */
	DA(3, "da", "da"), /**
	 * The '<em><b>De</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DE_VALUE
	 * @generated
	 * @ordered
	 */
	DE(4, "de", "de"), /**
	 * The '<em><b>Es</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ES_VALUE
	 * @generated
	 * @ordered
	 */
	ES(5, "es", "es"), /**
	 * The '<em><b>Fr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FR_VALUE
	 * @generated
	 * @ordered
	 */
	FR(6, "fr", "fr"), /**
	 * The '<em><b>Hi</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HI_VALUE
	 * @generated
	 * @ordered
	 */
	HI(7, "hi", "hi"), /**
	 * The '<em><b>Id</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ID_VALUE
	 * @generated
	 * @ordered
	 */
	ID(8, "id", "id"), /**
	 * The '<em><b>It</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IT_VALUE
	 * @generated
	 * @ordered
	 */
	IT(9, "it", "it"), /**
	 * The '<em><b>Ja</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JA_VALUE
	 * @generated
	 * @ordered
	 */
	JA(10, "ja", "ja"), /**
	 * The '<em><b>Ko</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #KO_VALUE
	 * @generated
	 * @ordered
	 */
	KO(11, "ko", "ko"), /**
	 * The '<em><b>Ml</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ML_VALUE
	 * @generated
	 * @ordered
	 */
	ML(12, "ml", "ml"), /**
	 * The '<em><b>Nl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NL_VALUE
	 * @generated
	 * @ordered
	 */
	NL(13, "nl", "nl"), /**
	 * The '<em><b>No</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NO_VALUE
	 * @generated
	 * @ordered
	 */
	NO(14, "no", "no"), /**
	 * The '<em><b>Pl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PL_VALUE
	 * @generated
	 * @ordered
	 */
	PL(15, "pl", "pl"), /**
	 * The '<em><b>Pt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PT_VALUE
	 * @generated
	 * @ordered
	 */
	PT(16, "pt", "pt"), /**
	 * The '<em><b>Ro</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RO_VALUE
	 * @generated
	 * @ordered
	 */
	RO(17, "ro", "ro"), /**
	 * The '<em><b>Ru</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RU_VALUE
	 * @generated
	 * @ordered
	 */
	RU(18, "ru", "ru"), /**
	 * The '<em><b>Sr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SR_VALUE
	 * @generated
	 * @ordered
	 */
	SR(19, "sr", "sr"), /**
	 * The '<em><b>Sv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SV_VALUE
	 * @generated
	 * @ordered
	 */
	SV(20, "sv", "sv"), /**
	 * The '<em><b>Th</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TH_VALUE
	 * @generated
	 * @ordered
	 */
	TH(21, "th", "th"), /**
	 * The '<em><b>Tr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TR_VALUE
	 * @generated
	 * @ordered
	 */
	TR(22, "tr", "tr"), /**
	 * The '<em><b>Zh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZH_VALUE
	 * @generated
	 * @ordered
	 */
	ZH(23, "zh", "zh");

	/**
	 * The '<em><b>En</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EN
	 * @model name="en"
	 * @generated
	 * @ordered
	 */
	public static final int EN_VALUE = 0;

	/**
	 * The '<em><b>Ar</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AR
	 * @model name="ar"
	 * @generated
	 * @ordered
	 */
	public static final int AR_VALUE = 1;

	/**
	 * The '<em><b>Cs</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CS
	 * @model name="cs"
	 * @generated
	 * @ordered
	 */
	public static final int CS_VALUE = 2;

	/**
	 * The '<em><b>Da</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DA
	 * @model name="da"
	 * @generated
	 * @ordered
	 */
	public static final int DA_VALUE = 3;

	/**
	 * The '<em><b>De</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DE
	 * @model name="de"
	 * @generated
	 * @ordered
	 */
	public static final int DE_VALUE = 4;

	/**
	 * The '<em><b>Es</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ES
	 * @model name="es"
	 * @generated
	 * @ordered
	 */
	public static final int ES_VALUE = 5;

	/**
	 * The '<em><b>Fr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FR
	 * @model name="fr"
	 * @generated
	 * @ordered
	 */
	public static final int FR_VALUE = 6;

	/**
	 * The '<em><b>Hi</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HI
	 * @model name="hi"
	 * @generated
	 * @ordered
	 */
	public static final int HI_VALUE = 7;

	/**
	 * The '<em><b>Id</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ID
	 * @model name="id"
	 * @generated
	 * @ordered
	 */
	public static final int ID_VALUE = 8;

	/**
	 * The '<em><b>It</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IT
	 * @model name="it"
	 * @generated
	 * @ordered
	 */
	public static final int IT_VALUE = 9;

	/**
	 * The '<em><b>Ja</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JA
	 * @model name="ja"
	 * @generated
	 * @ordered
	 */
	public static final int JA_VALUE = 10;

	/**
	 * The '<em><b>Ko</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #KO
	 * @model name="ko"
	 * @generated
	 * @ordered
	 */
	public static final int KO_VALUE = 11;

	/**
	 * The '<em><b>Ml</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ML
	 * @model name="ml"
	 * @generated
	 * @ordered
	 */
	public static final int ML_VALUE = 12;

	/**
	 * The '<em><b>Nl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NL
	 * @model name="nl"
	 * @generated
	 * @ordered
	 */
	public static final int NL_VALUE = 13;

	/**
	 * The '<em><b>No</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NO
	 * @model name="no"
	 * @generated
	 * @ordered
	 */
	public static final int NO_VALUE = 14;

	/**
	 * The '<em><b>Pl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PL
	 * @model name="pl"
	 * @generated
	 * @ordered
	 */
	public static final int PL_VALUE = 15;

	/**
	 * The '<em><b>Pt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PT
	 * @model name="pt"
	 * @generated
	 * @ordered
	 */
	public static final int PT_VALUE = 16;

	/**
	 * The '<em><b>Ro</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RO
	 * @model name="ro"
	 * @generated
	 * @ordered
	 */
	public static final int RO_VALUE = 17;

	/**
	 * The '<em><b>Ru</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RU
	 * @model name="ru"
	 * @generated
	 * @ordered
	 */
	public static final int RU_VALUE = 18;

	/**
	 * The '<em><b>Sr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SR
	 * @model name="sr"
	 * @generated
	 * @ordered
	 */
	public static final int SR_VALUE = 19;

	/**
	 * The '<em><b>Sv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SV
	 * @model name="sv"
	 * @generated
	 * @ordered
	 */
	public static final int SV_VALUE = 20;

	/**
	 * The '<em><b>Th</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TH
	 * @model name="th"
	 * @generated
	 * @ordered
	 */
	public static final int TH_VALUE = 21;

	/**
	 * The '<em><b>Tr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TR
	 * @model name="tr"
	 * @generated
	 * @ordered
	 */
	public static final int TR_VALUE = 22;

	/**
	 * The '<em><b>Zh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZH
	 * @model name="zh"
	 * @generated
	 * @ordered
	 */
	public static final int ZH_VALUE = 23;

	/**
	 * An array of all the '<em><b>Lang Enum</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final LangEnum[] VALUES_ARRAY =
		new LangEnum[] {
			EN,
			AR,
			CS,
			DA,
			DE,
			ES,
			FR,
			HI,
			ID,
			IT,
			JA,
			KO,
			ML,
			NL,
			NO,
			PL,
			PT,
			RO,
			RU,
			SR,
			SV,
			TH,
			TR,
			ZH,
		};

	/**
	 * A public read-only list of all the '<em><b>Lang Enum</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<LangEnum> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Lang Enum</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LangEnum get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LangEnum result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Lang Enum</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LangEnum getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LangEnum result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Lang Enum</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LangEnum get(int value) {
		switch (value) {
			case EN_VALUE: return EN;
			case AR_VALUE: return AR;
			case CS_VALUE: return CS;
			case DA_VALUE: return DA;
			case DE_VALUE: return DE;
			case ES_VALUE: return ES;
			case FR_VALUE: return FR;
			case HI_VALUE: return HI;
			case ID_VALUE: return ID;
			case IT_VALUE: return IT;
			case JA_VALUE: return JA;
			case KO_VALUE: return KO;
			case ML_VALUE: return ML;
			case NL_VALUE: return NL;
			case NO_VALUE: return NO;
			case PL_VALUE: return PL;
			case PT_VALUE: return PT;
			case RO_VALUE: return RO;
			case RU_VALUE: return RU;
			case SR_VALUE: return SR;
			case SV_VALUE: return SV;
			case TH_VALUE: return TH;
			case TR_VALUE: return TR;
			case ZH_VALUE: return ZH;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private LangEnum(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //LangEnum
