/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage
 * @generated
 */
public interface ArtefactFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ArtefactFactory eINSTANCE = org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Property Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Access</em>'.
	 * @generated
	 */
	PropertyAccess createPropertyAccess();

	/**
	 * Returns a new object of class '<em>Digital Artefact</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Digital Artefact</em>'.
	 * @generated
	 */
	DigitalArtefact createDigitalArtefact();

	/**
	 * Returns a new object of class '<em>Virtual Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Virtual Entity</em>'.
	 * @generated
	 */
	VirtualEntity createVirtualEntity();

	/**
	 * Returns a new object of class '<em>Provide Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Provide Service</em>'.
	 * @generated
	 */
	ProvideService createProvideService();

	/**
	 * Returns a new object of class '<em>Provide Resource</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Provide Resource</em>'.
	 * @generated
	 */
	ProvideResource createProvideResource();

	/**
	 * Returns a new object of class '<em>Service Description</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service Description</em>'.
	 * @generated
	 */
	ServiceDescription createServiceDescription();

	/**
	 * Returns a new object of class '<em>Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service</em>'.
	 * @generated
	 */
	Service createService();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	ArtefactPackage getArtefactPackage();

} //ArtefactFactory
