/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.iotml;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public final class IoTMLResource {
    @Deprecated
    public static final String MARTE_PROFILE_PATH = "platform:/plugin/org.eclipse.papyrus.marte.static.profile/resources/MARTE.profile.uml";
    public static final String PROFILES_PATHMAP = "pathmap://IOTML_PROFILE/";
    public static final String PROFILE_PATH = "pathmap://IOTML_PROFILE/IoT-ML.profile.uml";
    public static final String PROFILE_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML";
    private static final String UNNAMED = "unnamed";

    private IoTMLResource() {
    }

    public static Model createIoTMLModel(ResourceSet resourceSet) {
        return IoTMLResource.createIoTMLModel(resourceSet, "unnamed.uml", UNNAMED);
    }

    public static Model createIoTMLModel(ResourceSet resourceSet, String resourceName, String modelName) {
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName(modelName);
        Resource resource = resourceSet.createResource(URI.createURI((String)resourceName));
        resource.getContents().add((Object)model);
        Resource standardProfileResource = resourceSet.getResource(URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml"), true);
        Profile umlStdProfile = (Profile)EcoreUtil.getObjectByType((Collection)standardProfileResource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        model.applyProfile(umlStdProfile);
        Resource sysmlProfileResource = resourceSet.getResource(URI.createURI((String)"pathmap://SysML14_PROFILES/SysML.profile.uml"), true);
        Profile sysmlProfile = (Profile)EcoreUtil.getObjectByType((Collection)sysmlProfileResource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        model.applyProfile(sysmlProfile);
        Resource marteProfileResource = resourceSet.getResource(URI.createURI((String)MARTE_PROFILE_PATH), true);
        Profile marteProfile = (Profile)EcoreUtil.getObjectByType((Collection)marteProfileResource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        model.applyProfile(marteProfile);
        Resource iotMLProfileResource = resourceSet.getResource(URI.createURI((String)PROFILE_PATH), true);
        Profile iotProfile = (Profile)EcoreUtil.getObjectByType((Collection)iotMLProfileResource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        model.applyProfile(iotProfile);
        return model;
    }

    public static Package getFirstMatchingContainerProfiledByIoTMLProfile(Element element) {
        return IoTMLResource.getFirstMatchingContainerProfiledBy(element, PROFILE_URI);
    }

    public static Package getFirstMatchingContainerProfiledBy(Element element, String profileUri) {
        Package myNearestPackage;
        if (element instanceof Package) {
            Element elementOwner;
            Package pakage = (Package)element;
            EList appliedProfiles = pakage.getAppliedProfiles();
            if (appliedProfiles != null) {
                for (Profile appliedProfile : appliedProfiles) {
                    if (appliedProfile.getURI() == null || appliedProfile.getURI().compareTo(profileUri) != 0) continue;
                    return pakage;
                }
            }
            if ((elementOwner = element.getOwner()) != null) {
                return IoTMLResource.getFirstMatchingContainerProfiledBy(elementOwner, profileUri);
            }
        }
        if (element != null && (myNearestPackage = element.getNearestPackage()) != element) {
            return IoTMLResource.getFirstMatchingContainerProfiledBy((Element)myNearestPackage, profileUri);
        }
        return null;
    }

    public static boolean isIoTMLProfileApplied(Element element) {
        return IoTMLResource.isProfiledByProfile(element, PROFILE_URI);
    }

    public static boolean isProfiledByProfile(Element element, String profileUri) {
        return IoTMLResource.getFirstMatchingContainerProfiledBy(element, profileUri) != null;
    }
}

