/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Patrick Tessier (CEA LIST) Patrick.tessier@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.sysml14.diagram.parametric.policy;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.CustomizableDropEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DefaultDropStrategy;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;
import org.eclipse.papyrus.sysml14.diagram.parametric.dnd.IParametricDropStrategy;

/**
 * 
 * This class is used to associate adequate drop policy to Constraint property and parameter.
 * 
 */
@Deprecated // in 0.10.1 to be removed in 0.11.0
//the purpose of this class is unclear and a side effect is to double all drops menu in parametric 
public class ParametricDropEditPolicy extends CustomizableDropEditPolicy {

	/**
	 * Constructor.
	 *
	 * @param defaultDropEditPolicy
	 * @param defaultCreationEditPolicy
	 */
	public ParametricDropEditPolicy(EditPolicy defaultDropEditPolicy, EditPolicy defaultCreationEditPolicy) {
		super(defaultDropEditPolicy, defaultCreationEditPolicy);
	}

	/**
	 * Returns a map of DropStrategy / Command, for each Strategy which can handle
	 * the given request. All the returned commands are executable. The map may be empty.
	 *
	 * @param request
	 * @return
	 */
	@Override
	protected Map<DropStrategy, Command> findStrategies(Request request) {
		Map<DropStrategy, Command> matchingStrategies = super.findStrategies(request);

		// there is only parametric strategy and default
		// remove default
		if (matchingStrategies.size() == 2) {
			// when there is 2 strategies, the default is always the last
			Object[] matchingStrategiesArray = matchingStrategies.keySet().toArray();
			if (matchingStrategiesArray[0] instanceof IParametricDropStrategy && matchingStrategiesArray[1] instanceof DefaultDropStrategy) {
					Map<DropStrategy, Command> parametricMatchingStrategies = new HashMap<>();
					DropStrategy dropStrategyKey = (DropStrategy) matchingStrategiesArray[0];
					parametricMatchingStrategies.put(dropStrategyKey, matchingStrategies.get(dropStrategyKey));
					return parametricMatchingStrategies;
			}
		}
		return matchingStrategies;
	}

}
