/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.edit.part;

import org.eclipse.draw2d.Connection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.common.figure.AssociationFigure;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementLinkEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AssociationLinkLabelSourceMultiplicityEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AssociationLinkLabelSourceRoleEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AssociationLinkLabelTargetMultiplicityEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AssociationLinkLabelTargetRoleEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.NamedElementLinkLabelNameEditPart;
import org.eclipse.papyrus.uml.diagram.common.utils.AssociationViewUtils;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class AssociationEditPart
extends AbstractElementLinkEditPart {
    protected static final String ASSOCIATION_END_LISTENERS_SOURCE = "AssociationEndListenersSource";
    protected static final String ASSOCIATION_END_LISTENERS_TARGET = "AssociationEndListenersTarget";

    public void activate() {
        super.activate();
        this.addAssociationEndListeners();
    }

    protected void addAssociationEndListeners() {
        Association association;
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof Association && (association = (Association)semanticElement).getMemberEnds().size() >= 2) {
            Property sourceEnd = AssociationViewUtils.getSourceSemanticEnd(this.getNotationView());
            Property targetEnd = AssociationViewUtils.getTargetSemanticEnd(this.getNotationView());
            this.addListenerFilter(ASSOCIATION_END_LISTENERS_SOURCE, (NotificationListener)this, (EObject)sourceEnd);
            this.addListenerFilter(ASSOCIATION_END_LISTENERS_TARGET, (NotificationListener)this, (EObject)targetEnd);
        }
    }

    public void deactivate() {
        this.removeAssociationEndListeners();
        super.deactivate();
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshVisuals();
        }
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.resolveSemanticElement() != null) {
            if (this.getSource() == null || this.getTarget() == null) {
                return;
            }
            if (((GraphicalEditPart)this.getSource()).resolveSemanticElement() == null || ((GraphicalEditPart)this.getTarget()).resolveSemanticElement() == null) {
                return;
            }
            Property source = AssociationViewUtils.getSourceSemanticEnd(this.getNotationView());
            Property target = AssociationViewUtils.getTargetSemanticEnd(this.getNotationView());
            if (source == null || target == null) {
                return;
            }
            Element umlElement = this.getUMLElement();
            if (umlElement instanceof Association) {
                Association association = (Association)this.getUMLElement();
                if (this.isNavigable(association, source) && this.isNavigable(association, target)) {
                    if (source.getAggregation() == AggregationKind.NONE_LITERAL) {
                        this.setArrowSource(this.getArrowDecoration(0));
                    }
                    if (target.getAggregation() == AggregationKind.NONE_LITERAL) {
                        this.setArrowTarget(this.getArrowDecoration(0));
                    }
                } else {
                    if (this.isNavigable(association, source)) {
                        this.setArrowTarget(this.getArrowDecoration(1));
                        if (source.getAggregation() == AggregationKind.NONE_LITERAL) {
                            this.setArrowSource(this.getArrowDecoration(0));
                        }
                    }
                    if (this.isNavigable(association, target)) {
                        this.setArrowSource(this.getArrowDecoration(1));
                        if (target.getAggregation() == AggregationKind.NONE_LITERAL) {
                            this.setArrowTarget(this.getArrowDecoration(0));
                        }
                    }
                }
                if (source.getAggregation() == AggregationKind.SHARED_LITERAL) {
                    this.setArrowSource(this.getArrowDecoration(5));
                }
                if (target.getAggregation() == AggregationKind.SHARED_LITERAL) {
                    this.setArrowTarget(this.getArrowDecoration(5));
                }
                if (source.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                    this.setArrowSource(this.getArrowDecoration(4));
                }
                if (target.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                    this.setArrowTarget(this.getArrowDecoration(4));
                }
            }
        }
    }

    private boolean isNavigable(Association association, Property end) {
        boolean isNavigable = false;
        isNavigable = !association.getOwnedEnds().contains((Object)end);
        return isNavigable;
    }

    protected void removeAssociationEndListeners() {
        this.removeListenerFilter(ASSOCIATION_END_LISTENERS_SOURCE);
        this.removeListenerFilter(ASSOCIATION_END_LISTENERS_TARGET);
    }

    public AssociationEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof NamedElementLinkLabelNameEditPart) {
            ((NamedElementLinkLabelNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelSourceRoleEditPart) {
            ((AssociationLinkLabelSourceRoleEditPart)childEditPart).setLabel(this.getPrimaryShape().getSourceRoleLabel());
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelSourceMultiplicityEditPart) {
            ((AssociationLinkLabelSourceMultiplicityEditPart)childEditPart).setLabel(this.getPrimaryShape().getSourceMultiplicityLabel());
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelTargetRoleEditPart) {
            ((AssociationLinkLabelTargetRoleEditPart)childEditPart).setLabel(this.getPrimaryShape().getTargetRoleLabel());
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelTargetMultiplicityEditPart) {
            ((AssociationLinkLabelTargetMultiplicityEditPart)childEditPart).setLabel(this.getPrimaryShape().getTargetMultiplicityLabel());
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof NamedElementLinkLabelNameEditPart) {
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelSourceRoleEditPart) {
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelSourceMultiplicityEditPart) {
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelTargetRoleEditPart) {
            return true;
        }
        if (childEditPart instanceof AssociationLinkLabelTargetMultiplicityEditPart) {
            return true;
        }
        return super.removeFixedChild(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new AssociationFigure();
    }

    public AssociationFigure getPrimaryShape() {
        return (AssociationFigure)this.getFigure();
    }

    protected void refreshLineType() {
        this.setLineType(1);
    }

    protected void refreshArrowSource() {
    }

    protected void refreshArrowTarget() {
    }
}

