/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.edit.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.gmf.diagram.common.commands.IdentityCommandWithNotification;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.ILinkMappingHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.dnd.helper.CustomLinkMappingHelper;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.messages.Messages;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.provider.ElementTypes;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.InstanceSpecificationLinkHelper;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.TypedElement;

public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)new CustomLinkMappingHelper());
        this.registry = new CustomGraphicalTypeRegistry();
    }

    protected Set<String> getSpecificDropBehaviorTypes() {
        HashSet<String> result = new HashSet<String>();
        result.add(ElementTypes.INSTANCE_SPECIFICATION.getSemanticHint());
        result.add(ElementTypes.INSTANCE_SPECIFICATION_LINK.getSemanticHint());
        return result;
    }

    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if (ElementTypes.INSTANCE_SPECIFICATION.getSemanticHint().equalsIgnoreCase(nodeType) || ElementTypes.INSTANCE_SPECIFICATION_LINK.getSemanticHint().equalsIgnoreCase(edgeType)) {
            return new CommandProxy(this.dropInstanceSpecification(nodeType, dropRequest, droppedEObject));
        }
        return super.getSpecificDropCommand(dropRequest, droppedEObject, nodeType, edgeType);
    }

    protected Command dropInstanceSpecification(String droppedNodeType, DropObjectsRequest dropRequest, EObject droppedEObject) {
        if (!(droppedEObject instanceof InstanceSpecification)) {
            return UnexecutableCommand.INSTANCE;
        }
        List endTypes = InstanceSpecificationLinkHelper.getEnds((InstanceSpecification)((InstanceSpecification)droppedEObject));
        if (endTypes.size() > 0) {
            Element source = (Element)endTypes.get(0);
            Element target = (Element)endTypes.get(1);
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop InstanceSpecification link"), source, target, ElementTypes.INSTANCE_SPECIFICATION_LINK.getSemanticHint(), dropRequest.getLocation(), (Element)droppedEObject));
        }
        return new ICommandProxy(this.getDefaultDropNodeCommand(droppedNodeType, droppedEObject, dropRequest.getLocation()));
    }

    protected ICommand getUnknownDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject) {
        if (droppedEObject instanceof Association && !(droppedEObject instanceof AssociationClass) && !((ISpecializationType)SysMLElementTypes.ASSOCIATION).getMatcher().matches(droppedEObject)) {
            return new IdentityCommandWithNotification(Messages.Notification_Drop_Title, NLS.bind((String)Messages.Notification_Drop_UMLAssociationWarning, (Object)EMFCoreUtil.getQualifiedName((EObject)droppedEObject, (boolean)true)), Type.WARNING);
        }
        return super.getUnknownDropCommand(dropRequest, droppedEObject);
    }

    protected CompositeCommand dropBinaryLink(CompositeCommand cc, Element source, Element target, String edgeType, Point absoluteLocation, Element semanticLink) {
        IAdaptable sourceViewAdapter = this.findAdapter(cc, source, this.getLinkSourceDropLocation(absoluteLocation, source, target), edgeType);
        IAdaptable targetViewAdapter = this.findAdapter(cc, target, this.getLinkTargetDropLocation(absoluteLocation, source, target), edgeType);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(this.getElementType(edgeType, semanticLink), edgeType, this.getDiagramPreferencesHint());
        CommonDeferredCreateConnectionViewCommand createConnectionViewCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), edgeType, sourceViewAdapter, targetViewAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        createConnectionViewCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)createConnectionViewCommand);
        return cc;
    }

    protected IAdaptable getElementType(String elementID, Element semanticLink) {
        IElementType result = ElementTypes.getElementTypeByID(elementID);
        return result == null ? new SemanticAdapter((EObject)semanticLink, null) : result;
    }

    protected Point getLinkSourceDropLocation(Point absoluteLocation, Element source, Element target) {
        return absoluteLocation;
    }

    protected Point getLinkTargetDropLocation(Point absoluteLocation, Element source, Element target) {
        if (this.lookForEditPart((EObject)source) == null && this.lookForEditPart((EObject)target) == null) {
            return absoluteLocation.getTranslated(100, 0);
        }
        return absoluteLocation;
    }

    private IAdaptable findAdapter(CompositeCommand cc, Element source, Point dropLocation, String edgeType) {
        GraphicalEditPart editPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        if (editPart != null) {
            return new SemanticAdapter(null, editPart.getModel());
        }
        ICommand createCommand = this.getDefaultDropNodeCommand(edgeType, dropLocation, (EObject)source);
        cc.add((IUndoableOperation)createCommand);
        return (IAdaptable)createCommand.getCommandResult().getReturnValue();
    }

    protected EditPart lookForEditPart(EObject semantic) {
        return this.lookForEditPart(semantic, false);
    }

    protected EditPart lookForEditPart(EObject semantic, boolean byType) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        for (EditPart nextEditPart : editPartSet) {
            org.eclipse.uml2.uml.Type nextSemanticType;
            if (!this.isEditPartTypeAdapted(nextEditPart.getClass(), semantic.eClass())) continue;
            EObject nextSemantic = ((GraphicalEditPart)nextEditPart).resolveSemanticElement();
            if (semantic.equals(nextSemantic)) {
                return nextEditPart;
            }
            if (!byType || !(nextSemantic instanceof TypedElement) || ((TypedElement)nextSemantic).getType() == null || !semantic.equals(nextSemanticType = ((TypedElement)nextSemantic).getType())) continue;
            return nextEditPart;
        }
        return null;
    }

    private boolean isEditPartTypeAdapted(Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return true;
    }
}

