/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper;

import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.profile.standard.Create;

public class UMLXMIIDHelper {
    protected static final String CREATE_STEREOTYPE = "createStereotype";
    protected static final String EANNOTATION = "eAnnotation";
    protected static final String IMPORTED_FROM_SYSML11 = "Imported_From_SysML_11";
    protected static final String PACKAGE_IMPORT = "packageImport";
    protected static final String PROFILE_APPLICATION = "profileApplication";
    protected static final String OF = "_Of_";

    public static void calculateNeededId(XMIResource res, Object current, Map<EObject, String> oldIds) {
        if (current instanceof EAnnotation && ((EAnnotation)current).getSource().equals("Imported_From_SysML_1.1")) {
            UMLXMIIDHelper.calculateSysMLMigrationEAnnotation(res, (EAnnotation)current, oldIds);
        } else if (current instanceof PackageImport) {
            UMLXMIIDHelper.calculatePackageImport(res, (PackageImport)current, oldIds);
        } else if (current instanceof ProfileApplication) {
            UMLXMIIDHelper.calculateProfileApplication(res, (ProfileApplication)current, oldIds);
        }
    }

    protected static void calculateSysMLMigrationEAnnotation(XMIResource res, EAnnotation eAnnotation, Map<EObject, String> oldIds) {
        String parentId = ((XMIResource)eAnnotation.eContainer().eResource()).getID(eAnnotation.eContainer());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IMPORTED_FROM_SYSML11);
        stringBuilder.append(OF);
        stringBuilder.append(parentId);
        res.setID((EObject)eAnnotation, stringBuilder.toString());
        for (Map.Entry detail : eAnnotation.getDetails()) {
            StringBuilder subStringBuilder;
            if (!(detail instanceof EStringToStringMapEntryImpl)) continue;
            if (((String)detail.getKey()).equals("Papyrus_SysML_Migration_Date")) {
                subStringBuilder = new StringBuilder();
                subStringBuilder.append("Papyrus_SysML_Migration_Date");
                subStringBuilder.append(OF);
                subStringBuilder.append(parentId);
                res.setID((EObject)((EStringToStringMapEntryImpl)detail), subStringBuilder.toString());
                continue;
            }
            if (((String)detail.getKey()).equals("Papyrus_SysML_Migration_Bundle_Version")) {
                subStringBuilder = new StringBuilder();
                subStringBuilder.append("Papyrus_SysML_Migration_Bundle_Version");
                subStringBuilder.append(OF);
                subStringBuilder.append(parentId);
                res.setID((EObject)((EStringToStringMapEntryImpl)detail), subStringBuilder.toString());
                continue;
            }
            if (!((String)detail.getKey()).equals("Papyrus_Source_Model_Name")) continue;
            subStringBuilder = new StringBuilder();
            subStringBuilder.append("Papyrus_Source_Model_Name");
            subStringBuilder.append(OF);
            subStringBuilder.append(parentId);
            res.setID((EObject)((EStringToStringMapEntryImpl)detail), subStringBuilder.toString());
        }
    }

    protected static void calculatePackageImport(XMIResource res, PackageImport packageImport, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(packageImport)) {
            String importedPackageID;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(PACKAGE_IMPORT);
            stringBuilder.append(OF);
            Package importedPackage = packageImport.getImportedPackage();
            if (importedPackage.eResource() instanceof XMIResource && (importedPackageID = ((XMIResource)importedPackage.eResource()).getID((EObject)importedPackage)) != null && !importedPackageID.isEmpty()) {
                stringBuilder.append(importedPackageID);
                res.setID((EObject)packageImport, stringBuilder.toString());
                oldIds.put((EObject)packageImport, stringBuilder.toString());
            }
        }
    }

    protected static void calculateProfileApplication(XMIResource res, ProfileApplication profileApplication, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(profileApplication)) {
            String appliedProfileID;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(PROFILE_APPLICATION);
            stringBuilder.append(OF);
            Profile appliedProfile = profileApplication.getAppliedProfile();
            if (appliedProfile.eResource() instanceof XMIResource && (appliedProfileID = ((XMIResource)appliedProfile.eResource()).getID((EObject)appliedProfile)) != null && !appliedProfileID.isEmpty()) {
                stringBuilder.append(appliedProfileID);
                res.setID((EObject)profileApplication, stringBuilder.toString());
                oldIds.put((EObject)profileApplication, stringBuilder.toString());
                EAnnotation eAnnotation = profileApplication.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
                if (eAnnotation != null) {
                    StringBuilder eAnnotationStringBuilder = new StringBuilder();
                    eAnnotationStringBuilder.append(EANNOTATION);
                    eAnnotationStringBuilder.append(OF);
                    eAnnotationStringBuilder.append((CharSequence)stringBuilder);
                    res.setID((EObject)eAnnotation, eAnnotationStringBuilder.toString());
                    oldIds.put((EObject)eAnnotation, eAnnotationStringBuilder.toString());
                }
            }
        }
    }

    public static boolean isStereotypedElementCreated(EObject current) {
        boolean result = false;
        if (current instanceof Create) {
            result = true;
        }
        return result;
    }

    public static void calculateCreateStereotypedElement(XMIResource res, EObject current) {
        if (current instanceof Create) {
            UMLXMIIDHelper.calculateCreate(res, (Create)current);
        }
    }

    protected static void calculateCreate(XMIResource res, Create current) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CREATE_STEREOTYPE);
        stringBuilder.append(OF);
        stringBuilder.append(((XMIResource)current.getBase_BehavioralFeature().eResource()).getID((EObject)current.getBase_BehavioralFeature()));
        res.setID((EObject)current, stringBuilder.toString());
    }
}

