/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.blackboxes.table;

import java.util.List;

import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation.Kind;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;

/**
 * The black box for the table.
 */
public class TableBlackboxHelper {

	/**
	 * This allows to get the axis manager representation (and calculate it if the parameter is a proxy).
	 * 
	 * @param tableConfiguration
	 *            The table configuration of SysML1.1.
	 * @param axisManagerRepresentationSearched
	 *            The axis manager searched.
	 * @return The axis manager representation searched.
	 */
	@Operation(kind = Kind.HELPER)
	public AxisManagerRepresentation getAxisManager(final TableConfiguration tableConfiguration, final AxisManagerRepresentation axisManagerRepresentationSearched) {
		AxisManagerRepresentation result = null;

		if (axisManagerRepresentationSearched.eIsProxy()) {
			String xpath = axisManagerRepresentationSearched.toString();
			xpath = xpath.substring(xpath.indexOf("//@") + 3, xpath.lastIndexOf(")")); //$NON-NLS-1$ //$NON-NLS-2$
			final String axisConfigurationXPath = xpath.substring(0, xpath.indexOf("/@axisManagers.")); //$NON-NLS-1$
			final String indexAxisManagerAsString = xpath.substring(xpath.indexOf("/@axisManagers.") + 15); //$NON-NLS-1$

			List<AxisManagerRepresentation> axisManagers = null;
			if (axisConfigurationXPath.equals("rowHeaderAxisConfiguration")) { //$NON-NLS-1$
				axisManagers = tableConfiguration.getRowHeaderAxisConfiguration().getAxisManagers();
			} else if (axisConfigurationXPath.equals("columnHeaderAxisConfiguration")) { //$NON-NLS-1$
				axisManagers = tableConfiguration.getColumnHeaderAxisConfiguration().getAxisManagers();
			}

			if (null != axisManagers) {
				int indexAxisManager = Integer.parseInt(indexAxisManagerAsString);
				if (indexAxisManager >= 0) {
					if (axisManagers.size() > indexAxisManager) {
						result = axisManagers.get(indexAxisManager);
					}
				}
			}
		} else {
			result = axisManagerRepresentationSearched;
		}

		return result;
	}

}
