/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.blackboxes.sysml;

import java.util.List;

import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation.Kind;
import org.eclipse.uml2.uml.Classifier;

/**
 * This allows to define the needed methods of SysML for the transformations.
 */
public class SysMLBlackboxHelper {

	/***
	 * This allows to get the created classifier which replace the package.
	 * 
	 * @param searchedPackage
	 *            The searched package in the list of package.
	 * @param packagesToDestroy
	 *            The list of packages that have to be destroyed.
	 * @param createdClasses
	 *            The list of created classes that replaced the packages.
	 * @return The created classifier which replace the package or <code>null</code>;
	 */
	@Operation(kind = Kind.HELPER)
	public Classifier getClassifier(final org.eclipse.uml2.uml.Package searchedPackage, final List<org.eclipse.uml2.uml.Package> packagesToDestroy, final List<org.eclipse.uml2.uml.Class> createdClasses) {
		Classifier result = null;

		int index = packagesToDestroy.indexOf(searchedPackage);

		if (-1 != index) {
			result = createdClasses.get(index);
		}

		return result;
	}

}
