/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelResource;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractLayerStackCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.executeTransaction(event);
        return null;
    }

    private void executeTransaction(final ExecutionEvent event) {
        TransactionalEditingDomain editingDomain;
        NotationDiagramHelper notationDiagramHelper;
        try {
            IEvaluationContext context = this.getIEvaluationContext(event);
            notationDiagramHelper = this.lookupNotationDiagramHelperChecked(context);
            editingDomain = this.lookupTransactionalEditingDomain(context);
        }
        catch (NotFoundException e) {
            return;
        }
        catch (ServiceException e) {
            return;
        }
        RecordingCommand cmd = new RecordingCommand(editingDomain, this.getCommandName()){

            protected void doExecute() {
                AbstractLayerStackCommand.this.doExecute(event, notationDiagramHelper);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    public abstract String getCommandName();

    protected abstract void doExecute(ExecutionEvent var1, NotationDiagramHelper var2);

    protected IEvaluationContext getIEvaluationContext(ExecutionEvent event) throws NotFoundException {
        try {
            return (IEvaluationContext)event.getApplicationContext();
        }
        catch (ClassCastException e) {
            throw new NotFoundException("IEvaluationContext can't be found.");
        }
    }

    protected TransactionalEditingDomain lookupTransactionalEditingDomain(IEvaluationContext context) throws ServiceException {
        return ServiceUtilsForIEvaluationContext.getInstance().getTransactionalEditingDomain((Object)context);
    }

    public void setEnabled(Object evaluationContext) {
        if (!(evaluationContext instanceof IEvaluationContext)) {
            this.setBaseEnabled(false);
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        try {
            NotationDiagramHelper diagramHelper = this.lookupNotationDiagramHelperChecked(context);
            this.setBaseEnabled(this.isEnabled(diagramHelper));
        }
        catch (ServiceException e) {
            this.setBaseEnabled(false);
        }
        catch (NotFoundException e) {
            this.setBaseEnabled(false);
        }
    }

    public boolean isEnabled(NotationDiagramHelper notationDiagramHelper) {
        return true;
    }

    protected NotationDiagramHelper lookupNotationDiagramHelperChecked(IEvaluationContext context) throws NotFoundException, ServiceException {
        IEditorPart editor = ((ISashWindowsContainer)ServiceUtilsForIEvaluationContext.getInstance().getService(ISashWindowsContainer.class, (Object)context)).getActiveEditor();
        if (!(editor instanceof DiagramDocumentEditor)) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        LayersModelResource layersModel = (LayersModelResource)ServiceUtilsForIEvaluationContext.getInstance().getModelSet((Object)context).getModel("org.eclipse.papyrus.layers.resource.LayersModel");
        return new NotationDiagramHelper(layersModel, diagram);
    }
}

