/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.commands;

import java.util.List;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;

public class ApplyLayerCSSCommand
extends RecordingCommand {
    private List<View> views;
    private LayersStackApplication application;
    private String propertyName;
    private LayersStack layerStack;

    public ApplyLayerCSSCommand(TransactionalEditingDomain ted, List<View> views, String propertyName, LayersStackApplication application, LayersStack layerStack, String label) {
        super(ted, label);
        this.views = views;
        this.application = application;
        this.propertyName = propertyName;
        this.layerStack = layerStack;
    }

    protected void doExecute() {
        try {
            Property property = this.application.getPropertyRegistry().getProperty(this.propertyName);
            List commands = this.layerStack.getViewsComputePropertyValueCommand(this.views, property);
            PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
            int i = 0;
            while (i < this.views.size()) {
                if (commands != null && commands.get(i) != null) {
                    try {
                        setter.setValue(this.views.get(i), ((ComputePropertyValueCommand)commands.get(i)).getCmdValue());
                    }
                    catch (LayersException e) {
                        Activator.log.error("ApplyLayerCSSCommand setter has failed", (Throwable)e);
                    }
                } else {
                    Activator.log.info(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "ERROR - a cmd is null " + commands);
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            Activator.log.error("ApplyLayerCSSCommand could not retreive the setter associated to the property", (Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error("ApplyLayerCSSCommand could not compute the propertyValueCommand", (Throwable)e);
        }
    }
}

