/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersContainer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayerExpressionImpl;

public abstract class LayerOperatorImpl
extends LayerExpressionImpl
implements LayerOperator {
    protected EList<LayerExpression> layers;

    protected LayerOperatorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.LAYER_OPERATOR;
    }

    @Override
    public EList<LayerExpression> getLayers() {
        if (this.layers == null) {
            this.layers = new EObjectContainmentEList(LayerExpression.class, (InternalEObject)this, 8);
        }
        return this.layers;
    }

    @Override
    public void addLayer(LayerExpression layer) {
        this.getLayers().add(0, (Object)layer);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getLayers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getLayers();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getLayers().clear();
                this.getLayers().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getLayers().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.layers != null && !this.layers.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == LayersContainer.class) {
            switch (baseOperationID) {
                case 0: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 9: {
                this.addLayer((LayerExpression)arguments.get(0));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public void setIsBranchEnabled(boolean newIsBranchEnabled) {
        super.setIsBranchEnabled(newIsBranchEnabled);
        boolean value = this.isBranchEnabled();
        for (LayerExpression layer : this.getLayers()) {
            layer.setIsBranchEnabled(value);
        }
    }

    @Override
    public void setOwningLayersStack(LayersStack newOwningLayersStack) {
        super.setOwningLayersStack(newOwningLayersStack);
        LayersStack value = this.getOwningLayersStack();
        for (LayerExpression layer : this.getLayers()) {
            layer.setOwningLayersStack(value);
        }
    }

    @Override
    public void attach() throws LayersException {
        super.attach();
        for (LayerExpression l : this.getLayers()) {
            l.attach();
        }
    }

    @Override
    public void detach() throws LayersException {
        super.detach();
        for (LayerExpression l : this.getLayers()) {
            l.detach();
        }
    }

    @Override
    @Deprecated
    public void attachToLayersStack(LayersStack owningLayersStack) {
        this.setOwningLayersStack(owningLayersStack);
        for (LayerExpression l : this.getLayers()) {
            l.attachToLayersStack(owningLayersStack);
        }
        this.startBehaviors();
    }
}

