/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;

public final class SetPropertyExpression
extends ExpressionBase {
    private final ExpressionBase _inner;
    private final String _propertyName;
    private final ExpressionBase _valueExpr;

    public SetPropertyExpression(ExpressionBase inner, String propertyName, ExpressionBase valueExpr, SourcePos sourcePos) {
        super(sourcePos);
        this._inner = inner;
        this._propertyName = propertyName;
        this._valueExpr = valueExpr;
    }

    public ExpressionBase getInnerExpression() {
        return this._inner;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public ExpressionBase getValueExpr() {
        return this._valueExpr;
    }

    protected Object evaluateInternal(ExecutionContext ctx) {
        Object o = this._inner.evaluate(ctx);
        if (o == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        BackendType t = ctx.getTypesystem().findType(o);
        Object value = this._valueExpr.evaluate(ctx);
        t.setProperty(ctx, o, this._propertyName, value);
        return o;
    }
}

