/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtensionDefinition;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateExtensionStatement
extends AbstractExtensionDefinition {
    private final Expression expression;
    private final String returnVarName;
    private final Map<List<Object>, Object> cache = new HashMap<List<Object>, Object>();

    public CreateExtensionStatement(Identifier name, Identifier returnType, Identifier rtName, List<DeclaredParameter> params, Expression expr, boolean isPrivate) {
        super(name, returnType, params, true, isPrivate);
        this.expression = expr;
        this.returnVarName = rtName != null ? rtName.getValue() : "this";
    }

    public String getReturnVarName() {
        return this.returnVarName;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected Type internalGetReturnType(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return ctx.getTypeForName(this.getReturnTypeIdentifier().getValue());
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        this.checkForAmbiguousDefinitions(ctx, issues);
        Type t = ctx.getTypeForName(this.returnType.getValue());
        if (t == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Couldn't resolve type " + this.returnType + "!", this.returnType));
            return;
        }
        if (t.isAbstract()) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Cannot create instance of " + this.returnType + " because it is declared abstract!", this.returnType));
        }
        ctx = ctx.cloneWithVariable(new Variable(this.returnVarName, t));
        this.expression.analyze(ctx, issues);
    }

    @Override
    public Object evaluate(Object[] parameters, ExecutionContext ctx) {
        List<Object> l = Arrays.asList(parameters);
        if (this.cache.containsKey(l)) {
            return this.cache.get(l);
        }
        Type t = (ctx = ctx.cloneWithResource(this.getExtensionFile())).getTypeForName(this.returnType.getValue());
        if (t == null) {
            throw new EvaluationException("Couldn't resolve type " + this.returnType, (SyntaxElement)this.returnType, ctx);
        }
        if (t.isAbstract()) {
            throw new EvaluationException("Cannot create instance of abstract class " + this.returnType, (SyntaxElement)this.returnType, ctx);
        }
        Object inst = t.newInstance();
        this.cache.put(l, inst);
        ctx = ctx.cloneWithVariable(new Variable(this.returnVarName, inst));
        int i = 0;
        while (i < parameters.length) {
            Object object = parameters[i];
            ctx = ctx.cloneWithVariable(new Variable(this.getParameterNames().get(i), object));
            ++i;
        }
        this.expression.evaluate(ctx);
        return inst;
    }

    @Override
    protected Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        throw new UnsupportedOperationException();
    }
}

