/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableLabelEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.VisibilityComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.LabelLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.LabelSnapBackEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.ResizableLabelLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class LabelEditPart
extends TopGraphicEditPart {
    private String semanticHint = null;
    private static HashMap snapBackMap = new HashMap();
    static /* synthetic */ Class class$0;

    public static void registerSnapBackPosition(String propertyName, Point offset) {
        snapBackMap.put(propertyName, offset);
    }

    public static Point getSnapBackPosition(String propertyName) {
        return (Point)snapBackMap.get(propertyName);
    }

    public LabelEditPart(View view) {
        super(view);
    }

    protected IFigure createFigure() {
        Figure label = new Figure();
        label.setCursor(Cursors.ARROW);
        label.setLayoutManager((LayoutManager)new ConstrainedToolbarLayout());
        return label;
    }

    protected String getSemanticType() {
        if (this.semanticHint == null) {
            try {
                this.semanticHint = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                    public void run() {
                        this.setResult(((View)LabelEditPart.this.getModel()).getType());
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getSemanticType", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getSemanticType", (Throwable)e);
            }
        }
        return this.semanticHint;
    }

    public void refresh() {
        super.refresh();
        this.refreshBounds();
    }

    public void refreshBounds() {
        if (this.isResizable()) {
            this.handleResizableRefreshBounds();
        } else {
            this.handleNonResizableRefreshBoundS();
        }
    }

    private void handleNonResizableRefreshBoundS() {
        int dx = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int dy = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point offset = new Point(dx, dy);
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new LabelLocator((IFigure)((AbstractConnectionEditPart)this.getParent()).getConnectionFigure(), offset, this.getKeyPoint()));
        } else {
            this.getFigure().getParent().setConstraint(this.getFigure(), (Object)new LabelLocator(this.getFigure().getParent(), offset, this.getKeyPoint()));
        }
    }

    private void handleResizableRefreshBounds() {
        int dx = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int dy = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Rectangle rectangle = new Rectangle(dx, dy, width, height);
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new ResizableLabelLocator((IFigure)((AbstractConnectionEditPart)this.getParent()).getConnectionFigure(), rectangle, this.getKeyPoint()));
        } else {
            this.getFigure().getParent().setConstraint(this.getFigure(), (Object)new ResizableLabelLocator(this.getFigure().getParent(), rectangle, this.getKeyPoint()));
        }
    }

    private boolean isResizable() {
        EditPolicy editPolicy = this.getEditPolicy("PrimaryDrag Policy");
        return editPolicy instanceof ResizableEditPolicy;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableLabelEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new VisibilityComponentEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new LabelSnapBackEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTrackerEx((EditPart)this){

            protected boolean isMove() {
                return true;
            }
        };
    }

    public boolean isSnapBackNeeded() {
        return true;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshForegroundColor();
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature) || NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature)) {
            this.refreshBounds();
        } else if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(feature)) {
            Integer c = (Integer)notification.getNewValue();
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(c));
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = LabelEditPart.this.getAccessibleText();
                }
            };
        }
        return this.accessibleEP;
    }

    protected String getAccessibleText() {
        String accessibleString = "";
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            IFigure fig;
            IGraphicalEditPart ep = (IGraphicalEditPart)iter.next();
            if (!(ep instanceof TextCompartmentEditPart) || !((fig = ep.getFigure()) instanceof WrapLabel)) continue;
            accessibleString = String.valueOf(accessibleString) + ((WrapLabel)fig).getText() + " ";
        }
        return accessibleString;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.getParent().getAdapter(key);
        }
        Object adapterFromSuper = super.getAdapter(key);
        if (adapterFromSuper == null) {
            return this.getParent().getAdapter(key);
        }
        return adapterFromSuper;
    }

    public int getKeyPoint() {
        return 4;
    }

    public Point getReferencePoint() {
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            switch (this.getKeyPoint()) {
                case 3: {
                    return this.calculateRefPoint(15);
                }
                case 2: {
                    return this.calculateRefPoint(85);
                }
                case 4: {
                    return this.calculateRefPoint(50);
                }
            }
            return this.calculateRefPoint(50);
        }
        return ((AbstractGraphicalEditPart)this.getParent()).getFigure().getBounds().getTopLeft();
    }

    private Point calculateRefPoint(int percent) {
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            PointList ptList = ((Connection)((ConnectionEditPart)this.getParent()).getFigure()).getPoints();
            Point refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)percent, (boolean)true);
            return refPoint;
        }
        if (this.getParent() instanceof GraphicalEditPart) {
            return ((AbstractGraphicalEditPart)this.getParent()).getFigure().getBounds().getTopLeft();
        }
        return null;
    }
}

