/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.util.Collection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.HeaderAndFooterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelper;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.PrinterGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DiagramPrinter
implements Runnable {
    protected Printer printer;
    private org.eclipse.swt.graphics.Point display_dpi;
    private boolean isScaledPercent = false;
    private int rows = 1;
    private int columns = 1;
    private boolean printRangePageSelection = false;
    private int pageFrom = 1;
    private int pageTo = 1;
    private GC gc;
    private Graphics swtGraphics;
    private Graphics graphics;
    private PrinterGraphics printerGraphics;
    protected org.eclipse.swt.graphics.Point printerOffset;
    protected Rectangle logicalClientArea;
    private float userScale;
    protected Collection diagrams;
    private org.eclipse.swt.graphics.Point translated = null;
    private PreferencesHint preferencesHint;
    private IMapMode mm;
    private boolean fitToPage = false;

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public DiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        this.preferencesHint = preferencesHint;
        this.mm = mm;
    }

    public DiagramPrinter(PreferencesHint preferencesHint) {
        this(preferencesHint, MapModeUtil.getMapMode());
    }

    protected IMapMode getMapMode() {
        return this.mm;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setDiagrams(Collection diagrams) {
        this.diagrams = diagrams;
    }

    public void setDisplayDPI(org.eclipse.swt.graphics.Point display_dpi) {
        this.display_dpi = new org.eclipse.swt.graphics.Point(display_dpi.x, display_dpi.y);
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void setPrintRangePageSelection(boolean isPrintRangePageSelected) {
        this.printRangePageSelection = isPrintRangePageSelected;
    }

    public void setPrintRangePages(int pageFrom, int pageTo) {
        assert (pageFrom > 0) : "From page in print range page selection must be bigger than zero.";
        assert (pageTo > 0 && pageTo >= pageFrom) : "To page in print range page selection must be bigger than zero and from page.";
        this.pageFrom = pageFrom;
        this.pageTo = pageTo;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setScaledPercent(int scalePercent) {
        this.isScaledPercent = true;
        this.userScale = (float)scalePercent / 100.0f;
    }

    public void run() {
        assert (this.printer != null) : "printer must be set";
        if (!this.printer.startJob("Printing")) {
            return;
        }
        assert (this.diagrams != null);
        for (Object obj : this.diagrams) {
            Assert.isTrue((boolean)(obj instanceof Diagram));
            DiagramEditPart dgrmEP = PrintHelper.createDiagramEditPart((Diagram)obj, this.preferencesHint);
            RootEditPart rep = dgrmEP.getRoot();
            if (rep instanceof DiagramRootEditPart) {
                this.mm = ((DiagramRootEditPart)rep).getMapMode();
            }
            this.initialize();
            boolean loadedPreferences = PrintHelper.initializePreferences(dgrmEP, this.preferencesHint);
            IPreferenceStore pref = null;
            assert (dgrmEP.getViewer() instanceof DiagramGraphicalViewer);
            pref = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore();
            if (pref.getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
                pref = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
            }
            this.doPrintDiagram(dgrmEP, loadedPreferences, pref);
            this.dispose();
        }
        this.printer.endJob();
    }

    private int calculateRowFromPage(int pageNum, int totalNumColumns) {
        int row = pageNum / totalNumColumns;
        if (pageNum % totalNumColumns != 0) {
            ++row;
        }
        return row;
    }

    private int calculateColumnFromPage(int pageNum, int totalNumColumns, int cRow) {
        int col = pageNum - (cRow - 1) * totalNumColumns;
        return col;
    }

    private Point getPageCount(DiagramEditPart dgrmEP, Rectangle figureBounds, Point pageSize, boolean applyUserScale) {
        RootEditPart rootEditPart = dgrmEP.getRoot();
        if (rootEditPart instanceof DiagramRootEditPart) {
            DiagramRootEditPart diagramRootEditPart = (DiagramRootEditPart)rootEditPart;
            PageBreakEditPart pageBreakEditPart = diagramRootEditPart.getPageBreakEditPart();
            float fNumCols = (float)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().y * (applyUserScale ? this.userScale : 1.0f);
            float fNumRows = (float)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().x * (applyUserScale ? this.userScale : 1.0f);
            int numCols = (int)Math.ceil(fNumCols);
            int numRows = (int)Math.ceil(fNumRows);
            return new Point(numCols, numRows);
        }
        float fNumRows = (float)figureBounds.height * (applyUserScale ? this.userScale : 1.0f) / (float)pageSize.y;
        int numRows = (int)Math.ceil(fNumRows);
        float fNumCols = (float)figureBounds.width * (applyUserScale ? this.userScale : 1.0f) / (float)pageSize.x;
        int numCols = (int)Math.ceil(fNumCols);
        return new Point(numCols, numRows);
    }

    private void doPrintDiagram(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        this.graphics.pushState();
        if (this.isScaledPercent) {
            this.printToScale(dgrmEP, loadedPreferences, fPreferences);
        } else {
            this.printToPages(dgrmEP, loadedPreferences, fPreferences);
        }
        this.graphics.popState();
    }

    private void initialize() {
        assert (this.printer != null) : "printer must be set";
        int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
        this.gc = (style & 0x8000000) != 0 ? new GC((Drawable)this.printer, 0x4000000) : new GC((Drawable)this.printer);
        this.gc.setXORMode(false);
        this.swtGraphics = new SWTGraphics(this.gc);
        this.printerGraphics = this.createPrinterGraphics(this.swtGraphics);
        this.graphics = this.createMapModeGraphics((Graphics)this.printerGraphics);
        this.graphics.scale((double)this.computePrinterDisplayScale());
        this.logicalClientArea = this.graphics.getClip(new Rectangle(this.printer.getClientArea()));
    }

    protected org.eclipse.swt.graphics.Point getPrinterOffset() {
        if (this.printerOffset == null) {
            int offsetX = this.printer.getBounds().width - this.printer.getClientArea().width;
            int offsetY = this.printer.getBounds().height - this.printer.getClientArea().height;
            offsetX = (int)((float)this.getMapMode().DPtoLP((int)((float)offsetX / 2.0f * (float)this.display_dpi.x / (float)this.printer.getDPI().x)) / this.userScale);
            offsetY = (int)((float)this.getMapMode().DPtoLP((int)((float)offsetY / 2.0f * (float)this.display_dpi.y / (float)this.printer.getDPI().y)) / this.userScale);
            this.printerOffset = new org.eclipse.swt.graphics.Point(offsetX, offsetY);
        }
        return this.printerOffset;
    }

    /*
     * Unable to fully structure code
     */
    protected void printToScale(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        if (!DiagramPrinter.$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        figureBounds = PrintHelper.getPageBreakBounds(dgrmEP, loadedPreferences);
        pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-figureBounds.x) * this.userScale), (int)((float)(-figureBounds.y) * this.userScale));
        numRows = 0;
        numCols = 0;
        margins = PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        this.adjustMargins(margins, this.userScale, this.getPrinterOffset());
        gc_ = new GC((Drawable)Display.getDefault(), this.gc.getStyle());
        gc_.setAntialias(this.gc.getAntialias());
        fontData = JFaceResources.getDefaultFont().getFontData()[0];
        font = new Font((Device)this.printer, fontData);
        pageCount = this.getPageCount(dgrmEP, figureBounds, pageBounds, true);
        numCols = pageCount.x;
        numRows = pageCount.y;
        row = 1;
        col = 1;
        finalRow = 0;
        finalColumn = 0;
        if (!this.printRangePageSelection) ** GOTO lbl40
        row = this.calculateRowFromPage(this.pageFrom, numCols);
        col = this.calculateColumnFromPage(this.pageFrom, numCols, row);
        finalRow = this.calculateRowFromPage(this.pageTo, numCols);
        finalColumn = this.calculateColumnFromPage(this.pageTo, numCols, finalRow);
        try {
            ** GOTO lbl40
            {
                this.printer.startPage();
                this.drawPage(gc_, dgrmEP, fPreferences, figureBounds, margins, font, row, col);
                this.printer.endPage();
                if (row == finalRow && col == finalColumn && this.printRangePageSelection) ** GOTO lbl36
                ++col;
                do {
                    if (col <= numCols) continue block3;
lbl36:
                    // 2 sources

                    if (row == finalRow && col == finalColumn && this.printRangePageSelection) {
                        break;
                    }
                    col = 1;
                    ++row;
lbl40:
                    // 3 sources

                } while (row <= numRows);
            }
        }
        finally {
            font.dispose();
            gc_.dispose();
        }
    }

    protected void drawHeaderAndFooter(GC gc_, DiagramEditPart dgrmEP, Rectangle figureBounds, Font font, int rowIndex, int colIndex) {
        int width = this.logicalClientArea.width;
        int height = this.logicalClientArea.height;
        this.graphics.pushState();
        this.graphics.setFont(font);
        this.graphics.scale((double)(1.0f / this.userScale));
        this.graphics.translate(-this.translated.x, -this.translated.y);
        String headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("header", rowIndex, colIndex, dgrmEP);
        this.graphics.drawText(headerOrFooter, this.getMapMode().DPtoLP(5) + (width - this.getMapMode().DPtoLP(gc_.textExtent((String)headerOrFooter).x)) / 2, this.getMapMode().DPtoLP(5));
        headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("footer", rowIndex, colIndex, dgrmEP);
        this.graphics.drawText(headerOrFooter, this.getMapMode().DPtoLP(5) + (width - this.getMapMode().DPtoLP(gc_.textExtent((String)headerOrFooter).x)) / 2, height - this.getMapMode().DPtoLP(20));
        this.graphics.popState();
    }

    protected void drawPage(GC gc_, DiagramEditPart dgrmEP, IPreferenceStore fPreferences, Rectangle figureBounds, PageInfoHelper.PageMargins margins, Font font, int rowIndex, int colIndex) {
        boolean rtlEnabled;
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        boolean bl = rtlEnabled = (this.gc.getStyle() & 0x8000000) != 0;
        if (rtlEnabled) {
            Image image = new Image((Device)Display.getDefault(), this.getMapMode().LPtoDP(pageSize.x), this.getMapMode().LPtoDP(pageSize.y));
            GC imgGC = new GC((Drawable)image, rtlEnabled ? 0x4000000 : 0x2000000);
            imgGC.setXORMode(false);
            SWTGraphics sg = new SWTGraphics(imgGC);
            ScaledGraphics g1 = new ScaledGraphics((Graphics)sg);
            MapModeGraphics mmg = this.createMapModeGraphics((Graphics)g1);
            imgGC.setFont(mmg.getFont());
            this.internalDrawPage(dgrmEP, figureBounds, fPreferences, margins, (Graphics)mmg, rowIndex, colIndex, true);
            this.graphics.pushState();
            this.graphics.drawImage(image, 0, 0);
            this.graphics.popState();
            this.drawHeaderAndFooter(gc_, dgrmEP, figureBounds, font, rowIndex, colIndex);
            this.disposeImageVars(imgGC, image, sg, g1, mmg);
        } else {
            this.internalDrawPage(dgrmEP, figureBounds, fPreferences, margins, this.graphics, rowIndex, colIndex, false);
            this.drawHeaderAndFooter(gc_, dgrmEP, figureBounds, font, rowIndex, colIndex);
        }
    }

    private void internalDrawPage(DiagramEditPart dgrmEP, Rectangle figureBounds, IPreferenceStore fPreferences, PageInfoHelper.PageMargins margins, Graphics g, int rowIndex, int colIndex, boolean RTL_ENABLED) {
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        int width = pageSize.x;
        int height = pageSize.y;
        g.pushState();
        g.translate(this.translated.x, this.translated.y);
        g.scale((double)this.userScale);
        int translateX = -(width * (colIndex - 1));
        int translateY = -(height * (rowIndex - 1));
        int scaledTranslateX = (int)((float)translateX / this.userScale);
        int scaledTranslateY = (int)((float)translateY / this.userScale);
        int scaledWidth = (int)((float)width / this.userScale);
        int scaledHeight = (int)((float)height / this.userScale);
        if (RTL_ENABLED) {
            scaledTranslateX += margins.left * (colIndex - 1) + margins.right * colIndex;
            scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1);
        } else {
            scaledTranslateX += margins.left * colIndex + margins.right * (colIndex - 1);
            scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1);
        }
        g.translate(scaledTranslateX, scaledTranslateY);
        Rectangle clip = new Rectangle((scaledWidth - margins.left - margins.right) * (colIndex - 1) + figureBounds.x, (scaledHeight - margins.bottom - margins.top) * (rowIndex - 1) + figureBounds.y, scaledWidth - margins.right - margins.left, scaledHeight - margins.top - margins.bottom);
        g.clipRect(clip);
        dgrmEP.getLayer((Object)"Printable Layers").paint(g);
        g.popState();
    }

    /*
     * Unable to fully structure code
     */
    protected void printToPages(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        if (!DiagramPrinter.$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        figureBounds = PrintHelper.getPageBreakBounds(dgrmEP, loadedPreferences);
        margins = PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        pageCount = this.getPageCount(dgrmEP, figureBounds, pageBounds, false);
        numCols = pageCount.x;
        numRows = pageCount.y;
        actualWidth = 0.0f;
        actualHeight = 0.0f;
        if (this.rows == 1 && this.columns == 1 && this.fitToPage) {
            figureBounds = dgrmEP.getChildrenBounds();
            actualWidth = figureBounds.width;
            actualHeight = figureBounds.height;
        } else {
            actualWidth = numCols * pageBounds.x;
            actualHeight = numRows * pageBounds.y;
        }
        totalHeight = this.rows * pageBounds.y;
        totalWidth = this.columns * pageBounds.x;
        vScale = (float)totalHeight / actualHeight;
        hScale = (float)totalWidth / actualWidth;
        this.userScale = Math.min(hScale, vScale);
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-figureBounds.x) * this.userScale), (int)((float)(-figureBounds.y) * this.userScale));
        this.adjustMargins(margins, this.userScale, this.getPrinterOffset());
        gc_ = new GC((Drawable)Display.getDefault());
        fontData = JFaceResources.getDefaultFont().getFontData()[0];
        font = new Font((Device)this.printer, fontData);
        row = 1;
        col = 1;
        finalRow = 0;
        finalColumn = 0;
        if (!this.printRangePageSelection) ** GOTO lbl51
        row = this.calculateRowFromPage(this.pageFrom, this.columns);
        col = this.calculateColumnFromPage(this.pageFrom, this.columns, row);
        finalRow = this.calculateRowFromPage(this.pageTo, this.columns);
        finalColumn = this.calculateColumnFromPage(this.pageTo, this.columns, finalRow);
        try {
            ** GOTO lbl51
            {
                this.printer.startPage();
                this.drawPage(gc_, dgrmEP, fPreferences, figureBounds, margins, font, row, col);
                this.printer.endPage();
                if (row == finalRow && col == finalColumn && this.printRangePageSelection) ** GOTO lbl47
                ++col;
                do {
                    if (col <= this.columns) continue block3;
lbl47:
                    // 2 sources

                    if (row == finalRow && col == finalColumn && this.printRangePageSelection) {
                        break;
                    }
                    col = 1;
                    ++row;
lbl51:
                    // 3 sources

                } while (row <= this.rows);
            }
        }
        finally {
            font.dispose();
            gc_.dispose();
        }
    }

    private float computePrinterDisplayScale() {
        assert (this.printer != null) : "printer must be set";
        assert (this.display_dpi != null) : "display_dpi must be set";
        org.eclipse.swt.graphics.Point dpi = this.printer.getDPI();
        float scale = (float)dpi.x / (float)this.display_dpi.x;
        return scale;
    }

    private void dispose() {
        block27: {
            block25: {
                block23: {
                    block21: {
                        if (this.graphics != null) {
                            try {
                                try {
                                    this.graphics.dispose();
                                }
                                catch (NullPointerException nullPointerException) {
                                    this.graphics = null;
                                    break block21;
                                }
                            }
                            catch (Throwable throwable) {
                                this.graphics = null;
                                throw throwable;
                            }
                            this.graphics = null;
                        }
                    }
                    if (this.printerGraphics != null) {
                        try {
                            try {
                                this.printerGraphics.dispose();
                            }
                            catch (NullPointerException nullPointerException) {
                                this.printerGraphics = null;
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            this.printerGraphics = null;
                            throw throwable;
                        }
                        this.printerGraphics = null;
                    }
                }
                if (this.swtGraphics != null) {
                    try {
                        try {
                            this.swtGraphics.dispose();
                        }
                        catch (NullPointerException nullPointerException) {
                            this.swtGraphics = null;
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        this.swtGraphics = null;
                        throw throwable;
                    }
                    this.swtGraphics = null;
                }
            }
            if (this.gc != null) {
                try {
                    try {
                        this.gc.dispose();
                    }
                    catch (NullPointerException nullPointerException) {
                        this.gc = null;
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    this.gc = null;
                    throw throwable;
                }
                this.gc = null;
            }
        }
        this.printerOffset = null;
    }

    private void disposeImageVars(GC imgGC, Image image, SWTGraphics sg, ScaledGraphics g1, MapModeGraphics mmg) {
        block33: {
            block31: {
                block29: {
                    block27: {
                        if (mmg != null) {
                            try {
                                try {
                                    mmg.dispose();
                                }
                                catch (NullPointerException nullPointerException) {
                                    mmg = null;
                                    break block27;
                                }
                            }
                            catch (Throwable throwable) {
                                mmg = null;
                                throw throwable;
                            }
                            mmg = null;
                        }
                    }
                    if (g1 != null) {
                        try {
                            try {
                                g1.dispose();
                            }
                            catch (NullPointerException nullPointerException) {
                                g1 = null;
                                break block29;
                            }
                        }
                        catch (Throwable throwable) {
                            g1 = null;
                            throw throwable;
                        }
                        g1 = null;
                    }
                }
                if (sg != null) {
                    try {
                        try {
                            sg.dispose();
                        }
                        catch (NullPointerException nullPointerException) {
                            sg = null;
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        sg = null;
                        throw throwable;
                    }
                    sg = null;
                }
            }
            if (imgGC != null) {
                try {
                    try {
                        imgGC.dispose();
                    }
                    catch (NullPointerException nullPointerException) {
                        imgGC = null;
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    imgGC = null;
                    throw throwable;
                }
                imgGC = null;
            }
        }
        if (image != null) {
            try {
                try {
                    image.dispose();
                }
                catch (NullPointerException nullPointerException) {
                    image = null;
                }
            }
            finally {
                image = null;
            }
        }
    }

    protected MapModeGraphics createMapModeGraphics(Graphics theGraphics) {
        return new MapModeGraphics(theGraphics, this.getMapMode());
    }

    protected PrinterGraphics createPrinterGraphics(Graphics theGraphics) {
        return new PrinterGraphics(theGraphics, this.printer, true);
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    protected void adjustMargins(PageInfoHelper.PageMargins margins, float scale, org.eclipse.swt.graphics.Point offset) {
        margins.left = (int)((float)margins.left / scale);
        margins.top = (int)((float)margins.top / scale);
        margins.right = (int)((float)margins.right / scale);
        margins.bottom = (int)((float)margins.bottom / scale);
        margins.left -= offset.x;
        margins.right += offset.x;
        margins.top -= offset.y;
        margins.bottom += offset.y;
        if (margins.left < 0) {
            margins.left = 0;
        }
        if (margins.right < 0) {
            margins.right = 0;
        }
        if (margins.top < 0) {
            margins.top = 0;
        }
        if (margins.bottom < 0) {
            margins.bottom = 0;
        }
    }
}

