/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DateUtils;
import org.eclipse.test.AbstractJUnitResultFormatter;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class LegacyXmlResultFormatter
extends AbstractJUnitResultFormatter {
    private static final double ONE_SECOND = 1000.0;
    OutputStream outputStream;
    final Map<TestIdentifier, Stats> testIds = new ConcurrentHashMap<TestIdentifier, Stats>();
    final Map<TestIdentifier, Optional<String>> skipped = new ConcurrentHashMap<TestIdentifier, Optional<String>>();
    final Map<TestIdentifier, Optional<Throwable>> failed = new ConcurrentHashMap<TestIdentifier, Optional<Throwable>>();
    final Map<TestIdentifier, Optional<Throwable>> errored = new ConcurrentHashMap<TestIdentifier, Optional<Throwable>>();
    final Map<TestIdentifier, Optional<Throwable>> aborted = new ConcurrentHashMap<TestIdentifier, Optional<Throwable>>();
    TestPlan testPlan;
    long testPlanStartedAt = -1L;
    long testPlanEndedAt = -1L;
    final AtomicLong numTestsRun = new AtomicLong(0L);
    final AtomicLong numTestsFailed = new AtomicLong(0L);
    final AtomicLong numTestsErrored = new AtomicLong(0L);
    final AtomicLong numTestsSkipped = new AtomicLong(0L);
    final AtomicLong numTestsAborted = new AtomicLong(0L);

    public void testPlanExecutionStarted(TestPlan plan) {
        this.testPlan = plan;
        this.testPlanStartedAt = System.currentTimeMillis();
    }

    public void testPlanExecutionFinished(TestPlan plan) {
        this.testPlanEndedAt = System.currentTimeMillis();
        try {
            new XMLReportWriter().write();
        }
        catch (IOException | XMLStreamException e) {
            this.handleException(e);
            return;
        }
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        long currentTime = System.currentTimeMillis();
        this.numTestsSkipped.incrementAndGet();
        this.skipped.put(testIdentifier, Optional.ofNullable(reason));
        Stats stats = new Stats(testIdentifier, currentTime);
        stats.endedAt = currentTime;
        this.testIds.put(testIdentifier, stats);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        long currentTime = System.currentTimeMillis();
        this.testIds.putIfAbsent(testIdentifier, new Stats(testIdentifier, currentTime));
        if (testIdentifier.isTest()) {
            this.numTestsRun.incrementAndGet();
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        long currentTime = System.currentTimeMillis();
        Stats stats = this.testIds.get(testIdentifier);
        if (stats != null) {
            stats.endedAt = currentTime;
        }
        switch (testExecutionResult.getStatus()) {
            case SUCCESSFUL: {
                break;
            }
            case ABORTED: {
                this.numTestsAborted.incrementAndGet();
                this.aborted.put(testIdentifier, testExecutionResult.getThrowable());
                break;
            }
            case FAILED: {
                Optional throwableOptional = testExecutionResult.getThrowable();
                if (throwableOptional.isPresent() && throwableOptional.get() instanceof AssertionError) {
                    this.numTestsFailed.incrementAndGet();
                    this.failed.put(testIdentifier, testExecutionResult.getThrowable());
                    break;
                }
                this.numTestsErrored.incrementAndGet();
                this.errored.put(testIdentifier, testExecutionResult.getThrowable());
            }
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
    }

    public void setDestination(OutputStream os) {
        this.outputStream = os;
    }

    private final class Stats {
        final long startedAt;
        long endedAt;

        Stats(TestIdentifier testIdentifier, long startedAt) {
            this.startedAt = startedAt;
        }
    }

    private final class XMLReportWriter {
        private static final String ELEM_TESTSUITE = "testsuite";
        private static final String ELEM_PROPERTIES = "properties";
        private static final String ELEM_PROPERTY = "property";
        private static final String ELEM_TESTCASE = "testcase";
        private static final String ELEM_SKIPPED = "skipped";
        private static final String ELEM_FAILURE = "failure";
        private static final String ELEM_ERROR = "error";
        private static final String ELEM_ABORTED = "aborted";
        private static final String ELEM_SYSTEM_OUT = "system-out";
        private static final String ELEM_SYSTEM_ERR = "system-err";
        private static final String ATTR_CLASSNAME = "classname";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_VALUE = "value";
        private static final String ATTR_TIME = "time";
        private static final String ATTR_TIMESTAMP = "timestamp";
        private static final String ATTR_NUM_ABORTED = "aborted";
        private static final String ATTR_NUM_FAILURES = "failures";
        private static final String ATTR_NUM_ERRORS = "errors";
        private static final String ATTR_NUM_TESTS = "tests";
        private static final String ATTR_NUM_SKIPPED = "skipped";
        private static final String ATTR_MESSAGE = "message";
        private static final String ATTR_TYPE = "type";

        void write() throws XMLStreamException, IOException {
            try (XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(LegacyXmlResultFormatter.this.outputStream, "UTF-8");){
                writer.writeStartDocument();
                this.writeTestSuite(writer);
                writer.writeEndDocument();
            }
        }

        void writeTestSuite(XMLStreamWriter writer) throws XMLStreamException, IOException {
            writer.writeStartElement(ELEM_TESTSUITE);
            String testsuiteName = this.determineTestSuiteName();
            writer.writeAttribute(ATTR_NAME, testsuiteName);
            writer.writeAttribute(ATTR_TIME, String.valueOf((double)(LegacyXmlResultFormatter.this.testPlanEndedAt - LegacyXmlResultFormatter.this.testPlanStartedAt) / 1000.0));
            String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
            writer.writeAttribute(ATTR_TIMESTAMP, timestamp);
            writer.writeAttribute(ATTR_NUM_TESTS, String.valueOf(LegacyXmlResultFormatter.this.numTestsRun.longValue()));
            writer.writeAttribute(ATTR_NUM_FAILURES, String.valueOf(LegacyXmlResultFormatter.this.numTestsFailed.longValue()));
            writer.writeAttribute(ATTR_NUM_ERRORS, String.valueOf(LegacyXmlResultFormatter.this.numTestsErrored.longValue()));
            writer.writeAttribute("skipped", String.valueOf(LegacyXmlResultFormatter.this.numTestsSkipped.longValue()));
            writer.writeAttribute("aborted", String.valueOf(LegacyXmlResultFormatter.this.numTestsAborted.longValue()));
            this.writeProperties(writer);
            this.writeTestCase(writer);
            this.writeSysOut(writer);
            this.writeSysErr(writer);
            writer.writeEndElement();
        }

        void writeProperties(XMLStreamWriter writer) throws XMLStreamException {
            Properties properties = LegacyXmlResultFormatter.this.context.getProperties();
            if (properties == null || properties.isEmpty()) {
                return;
            }
            writer.writeStartElement(ELEM_PROPERTIES);
            for (String prop : properties.stringPropertyNames()) {
                writer.writeStartElement(ELEM_PROPERTY);
                writer.writeAttribute(ATTR_NAME, prop);
                writer.writeAttribute(ATTR_VALUE, properties.getProperty(prop));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        void writeTestCase(XMLStreamWriter writer) throws XMLStreamException {
            for (Map.Entry<TestIdentifier, Stats> entry : LegacyXmlResultFormatter.this.testIds.entrySet()) {
                Optional parent;
                TestIdentifier testId = entry.getKey();
                if (!testId.isTest() || !(parent = LegacyXmlResultFormatter.this.testPlan.getParent(testId)).isPresent()) continue;
                String classname = ((TestIdentifier)parent.get()).getLegacyReportingName();
                writer.writeStartElement(ELEM_TESTCASE);
                writer.writeAttribute(ATTR_CLASSNAME, classname);
                writer.writeAttribute(ATTR_NAME, testId.getDisplayName());
                Stats stats = entry.getValue();
                writer.writeAttribute(ATTR_TIME, String.valueOf((double)(stats.endedAt - stats.startedAt) / 1000.0));
                this.writeSkipped(writer, testId);
                this.writeFailed(writer, testId);
                this.writeErrored(writer, testId);
                this.writeAborted(writer, testId);
                writer.writeEndElement();
            }
        }

        private void writeSkipped(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.skipped.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement("skipped");
            Optional<String> reason = LegacyXmlResultFormatter.this.skipped.get(testIdentifier);
            if (reason.isPresent()) {
                writer.writeAttribute(ATTR_MESSAGE, reason.get());
            }
            writer.writeEndElement();
        }

        private void writeFailed(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.failed.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement(ELEM_FAILURE);
            Optional<Throwable> cause = LegacyXmlResultFormatter.this.failed.get(testIdentifier);
            if (cause.isPresent()) {
                Throwable t = cause.get();
                String message = t.getMessage();
                if (message != null && !message.trim().isEmpty()) {
                    writer.writeAttribute(ATTR_MESSAGE, message);
                }
                writer.writeAttribute(ATTR_TYPE, t.getClass().getName());
                writer.writeCharacters(ExceptionUtils.readStackTrace((Throwable)t));
            }
            writer.writeEndElement();
        }

        private void writeErrored(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.errored.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement(ELEM_ERROR);
            Optional<Throwable> cause = LegacyXmlResultFormatter.this.errored.get(testIdentifier);
            if (cause.isPresent()) {
                Throwable t = cause.get();
                String message = t.getMessage();
                if (message != null && !message.trim().isEmpty()) {
                    writer.writeAttribute(ATTR_MESSAGE, message);
                }
                writer.writeAttribute(ATTR_TYPE, t.getClass().getName());
                writer.writeCharacters(ExceptionUtils.readStackTrace((Throwable)t));
            }
            writer.writeEndElement();
        }

        private void writeAborted(XMLStreamWriter writer, TestIdentifier testIdentifier) throws XMLStreamException {
            if (!LegacyXmlResultFormatter.this.aborted.containsKey(testIdentifier)) {
                return;
            }
            writer.writeStartElement("aborted");
            Optional<Throwable> cause = LegacyXmlResultFormatter.this.aborted.get(testIdentifier);
            if (cause.isPresent()) {
                Throwable t = cause.get();
                String message = t.getMessage();
                if (message != null && !message.trim().isEmpty()) {
                    writer.writeAttribute(ATTR_MESSAGE, message);
                }
                writer.writeAttribute(ATTR_TYPE, t.getClass().getName());
            }
            writer.writeEndElement();
        }

        private void writeSysOut(XMLStreamWriter writer) throws XMLStreamException, IOException {
            if (!LegacyXmlResultFormatter.this.hasSysOut()) {
                return;
            }
            writer.writeStartElement(ELEM_SYSTEM_OUT);
            Throwable throwable = null;
            Object var3_4 = null;
            try (Reader reader = LegacyXmlResultFormatter.this.getSysOutReader();){
                this.writeCharactersFrom(reader, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            writer.writeEndElement();
        }

        private void writeSysErr(XMLStreamWriter writer) throws XMLStreamException, IOException {
            if (!LegacyXmlResultFormatter.this.hasSysErr()) {
                return;
            }
            writer.writeStartElement(ELEM_SYSTEM_ERR);
            Throwable throwable = null;
            Object var3_4 = null;
            try (Reader reader = LegacyXmlResultFormatter.this.getSysErrReader();){
                this.writeCharactersFrom(reader, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            writer.writeEndElement();
        }

        private void writeCharactersFrom(Reader reader, XMLStreamWriter writer) throws IOException, XMLStreamException {
            char[] chars = new char[1024];
            int numRead = -1;
            while ((numRead = reader.read(chars)) != -1) {
                String encoded = new DOMElementWriter().encode(new String(chars, 0, numRead));
                writer.writeCharacters(encoded);
            }
        }

        private String determineTestSuiteName() {
            Set roots = LegacyXmlResultFormatter.this.testPlan.getRoots();
            if (roots.isEmpty()) {
                return "UNKNOWN";
            }
            for (TestIdentifier root : roots) {
                Optional<ClassSource> classSource = this.findFirstClassSource(root);
                if (!classSource.isPresent()) continue;
                return classSource.get().getClassName();
            }
            return "UNKNOWN";
        }

        private Optional<ClassSource> findFirstClassSource(TestIdentifier root) {
            TestSource source;
            if (root.getSource().isPresent() && (source = (TestSource)root.getSource().get()) instanceof ClassSource) {
                return Optional.of((ClassSource)source);
            }
            for (TestIdentifier child : LegacyXmlResultFormatter.this.testPlan.getChildren(root)) {
                Optional<ClassSource> classSource = this.findFirstClassSource(child);
                if (!classSource.isPresent()) continue;
                return classSource;
            }
            return Optional.empty();
        }
    }
}

