/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.net4j.util.om.pref.OMPreference;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceButton {
    private OMPreference<Boolean> preference;
    private Button button;

    public PreferenceButton(Composite parent, int style, String text, final OMPreference<Boolean> preference) {
        this.preference = preference;
        this.button = new Button(parent, style);
        this.button.setText(text);
        this.button.setSelection(((Boolean)preference.getValue()).booleanValue());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                preference.setValue((Object)PreferenceButton.this.button.getSelection());
            }
        });
    }

    public OMPreference<Boolean> getPreference() {
        return this.preference;
    }

    public Button getButton() {
        return this.button;
    }

    public int getAlignment() {
        return this.button.getAlignment();
    }

    public Image getImage() {
        return this.button.getImage();
    }

    public boolean getSelection(boolean setPreference) {
        boolean selection = this.button.getSelection();
        if (setPreference) {
            this.preference.setValue((Object)selection);
        }
        return selection;
    }

    public boolean getSelection() {
        return this.getSelection(false);
    }

    public String getText() {
        return this.button.getText();
    }

    public void setAlignment(int alignment) {
        this.button.setAlignment(alignment);
    }

    public void setImage(Image image) {
        this.button.setImage(image);
    }

    public void setSelection(boolean selected) {
        this.button.setSelection(selected);
    }

    public void setText(String string) {
        this.button.setText(string);
    }

    public boolean setFocus() {
        return this.button.setFocus();
    }
}

