/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.ocl.wizards;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.query.examples.ocl.internal.l10n.QueryOCLMessages;
import org.eclipse.emf.query.examples.ocl.wizards.IOCLQueryWizardPage;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryWithContextWizardPage
extends WizardPage
implements IOCLQueryWizardPage {
    private static String TITLE = QueryOCLMessages.oclQuery_title;
    private static String METACLASS_PROMPT = QueryOCLMessages.oclQuery_prompt_metaclass;
    private static String METACLASS_DEFAULT = QueryOCLMessages.oclQuery_default_metaclass;
    private static String CONDITION_PROMPT = QueryOCLMessages.oclQuery_prompt_condition;
    private static String CONDITION_DEFAULT = QueryOCLMessages.oclQuery_default_condition;
    private ComboViewer contextCombo;
    private Text conditionText;
    private BooleanOCLCondition<EClassifier, EClass, EObject> condition;

    public QueryWithContextWizardPage() {
        super("main", TITLE, null);
    }

    public void createControl(Composite parent) {
        this.setMessage(QueryOCLMessages.oclQuery_message_wizard);
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout(2, false));
        Label prompt = new Label(page, 0);
        prompt.setText(METACLASS_PROMPT);
        this.contextCombo = new ComboViewer(page, 0);
        this.contextCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fillContextCombo();
        this.contextCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QueryWithContextWizardPage.this.setPageComplete(QueryWithContextWizardPage.this.validatePage());
            }
        });
        Label spacer = new Label(page, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = 15;
        spacer.setLayoutData((Object)data);
        prompt = new Label(page, 0);
        prompt.setText(CONDITION_PROMPT);
        data = new GridData(768);
        data.horizontalSpan = 2;
        prompt.setLayoutData((Object)data);
        this.conditionText = new Text(page, 0x2000802);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.conditionText.setLayoutData((Object)data);
        this.conditionText.setText(CONDITION_DEFAULT);
        this.conditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueryWithContextWizardPage.this.setPageComplete(QueryWithContextWizardPage.this.validatePage());
            }
        });
        this.setControl((Control)page);
        this.setPageComplete(this.validatePage());
    }

    private void fillContextCombo() {
        this.contextCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contextCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((EClassifier)element).getName();
            }
        });
        this.contextCombo.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((EClassifier)e1).getName().compareTo(((EClassifier)e2).getName());
            }
        });
        LinkedList classes = new LinkedList(EXTLibraryPackage.eINSTANCE.getEClassifiers());
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof EClass) continue;
            iter.remove();
        }
        this.contextCombo.setInput(classes);
        EClassifier defaultSelection = EXTLibraryPackage.eINSTANCE.getEClassifier(METACLASS_DEFAULT);
        if (defaultSelection != null) {
            this.contextCombo.setSelection((ISelection)new StructuredSelection((Object)defaultSelection), true);
        }
    }

    private boolean validatePage() {
        boolean result = true;
        try {
            String text = this.conditionText.getText();
            IStructuredSelection selection = (IStructuredSelection)this.contextCombo.getSelection();
            EClass contextClass = (EClass)selection.getFirstElement();
            OCL ocl = OCL.newInstance();
            this.condition = new BooleanOCLCondition(ocl.getEnvironment(), text, (Object)contextClass);
            if (((EClassifier)this.condition.getResultType(null)).getInstanceClass() == Boolean.class) {
                this.setErrorMessage(null);
            } else {
                this.condition = null;
                result = false;
                this.setErrorMessage(QueryOCLMessages.oclQuery_message_boolean);
            }
        }
        catch (Exception e) {
            result = false;
            this.setErrorMessage(e.getLocalizedMessage());
        }
        return result;
    }

    @Override
    public BooleanOCLCondition<EClassifier, EClass, EObject> getCondition() {
        return this.condition;
    }

    public void dispose() {
        super.dispose();
    }
}

