/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.AddMappingCommand;
import org.eclipse.emf.mapping.command.CreateMappingCommand;
import org.eclipse.emf.mapping.command.RemoveMappingCommand;
import org.eclipse.emf.mapping.command.RestoreInitialStateCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.provider.MappingItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingRootItemProvider
extends MappingItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public MappingRootItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            boolean isTypeMapping;
            super.getPropertyDescriptors(object);
            MappingRoot mappingRoot = (MappingRoot)object;
            MappingPackage ePackage = MappingPackage.eINSTANCE;
            boolean bl = isTypeMapping = mappingRoot.getDomain() == null;
            if (!isTypeMapping) {
                this.itemPropertyDescriptors.add(new ItemPropertyDescriptor(this.adapterFactory, MappingPlugin.getPlugin().getString("_UI_OutputReadOnly_property_label"), MappingPlugin.getPlugin().getString("_UI_OutputReadOnly_property_description"), (EStructuralFeature)ePackage.getMappingRoot_OutputReadOnly(), true, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
                this.itemPropertyDescriptors.add(new ItemPropertyDescriptor(this.adapterFactory, MappingPlugin.getPlugin().getString("_UI_TopToBottom_property_label"), MappingPlugin.getPlugin().getString("_UI_TopToBottom_property_description"), (EStructuralFeature)ePackage.getMappingRoot_TopToBottom(), false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
            }
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public void notifyChanged(Notification msg) {
        MappingPackage ePackage = MappingPackage.eINSTANCE;
        if (msg.getFeature() == ePackage.getMappingRoot_OutputReadOnly() || msg.getFeature() == ePackage.getMappingRoot_TopToBottom()) {
            this.fireNotifyChanged(msg);
            return;
        }
        super.notifyChanged(msg);
    }

    @Override
    public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        if (editingDomain instanceof MappingDomain) {
            MappingDomain mappingDomain = (MappingDomain)editingDomain;
            if (commandClass == CreateMappingCommand.class) {
                return this.createCreateMappingCommand(mappingDomain, commandParameter.getCollection());
            }
            if (commandClass == AddMappingCommand.class) {
                return this.createAddMappingCommand(mappingDomain, commandParameter.getCollection());
            }
            if (commandClass == RemoveMappingCommand.class) {
                return this.createRemoveMappingCommand(mappingDomain, commandParameter.getCollection());
            }
            if (commandClass == RestoreInitialStateCommand.class) {
                return this.createRestoreInitialStateCommand(mappingDomain);
            }
        }
        return super.createCommand(object, editingDomain, commandClass, commandParameter);
    }

    protected Command createCreateMappingCommand(MappingDomain domain, Collection<?> collection) {
        return new CreateMappingCommand(domain, collection);
    }

    protected Command createAddMappingCommand(MappingDomain domain, Collection<?> collection) {
        return new AddMappingCommand(domain, collection);
    }

    protected Command createRemoveMappingCommand(MappingDomain domain, Collection<?> collection) {
        return new RemoveMappingCommand(domain, collection);
    }

    protected Command createRestoreInitialStateCommand(MappingDomain domain) {
        return new RestoreInitialStateCommand(domain);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return MappingPlugin.INSTANCE;
    }
}

