/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCommand
extends AbstractOverrideableCommand {
    public static final Object UNSET_VALUE = new Object();
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_SetCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_SetCommand_description");
    protected EObject owner;
    protected EStructuralFeature feature;
    protected EList<Object> ownerList;
    protected Object value;
    protected Object oldValue;
    protected int index;
    protected boolean canUndo = true;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;

    public static Command create(EditingDomain domain, Object owner, Object feature, Object value) {
        return SetCommand.create(domain, owner, feature, value, -1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Command create(EditingDomain domain, final Object owner, Object feature, Object value, int index) {
        if (!(owner instanceof EObject) || !((EObject)owner).eClass().getEAllReferences().contains(feature)) return domain.createCommand(SetCommand.class, new CommandParameter(owner, feature, value, index));
        EReference eReference = (EReference)feature;
        if (eReference.isMany() && index == -1) {
            void var8_15;
            List values = value == UNSET_VALUE ? Collections.EMPTY_LIST : (List)value;
            List oldValues = (List)((EObject)owner).eGet((EStructuralFeature)eReference);
            Object var8_12 = null;
            if (!oldValues.isEmpty() && values.isEmpty() && eReference.isUnsettable()) {
                PessimisticStrictCompoundCommand pessimisticStrictCompoundCommand = new PessimisticStrictCompoundCommand(LABEL, DESCRIPTION){

                    public Collection<?> getAffectedObjects() {
                        return Collections.singleton(owner);
                    }
                };
            } else {
                CompoundCommand compoundCommand = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION){

                    public Collection<?> getAffectedObjects() {
                        return Collections.singleton(owner);
                    }
                };
            }
            if (!oldValues.isEmpty()) {
                if (!values.isEmpty()) {
                    BasicEList.FastCompare removedValues = new BasicEList.FastCompare((Collection)oldValues);
                    removedValues.removeAll(values);
                    if (!removedValues.equals(oldValues)) {
                        if (!removedValues.isEmpty()) {
                            var8_15.append(RemoveCommand.create(domain, owner, feature, new BasicEList((Collection)removedValues)));
                        }
                        BasicEList.FastCompare remainingValues = new BasicEList.FastCompare((Collection)oldValues);
                        remainingValues.removeAll((Collection<?>)removedValues);
                        int count = -1;
                        for (Object object : values) {
                            int position = remainingValues.indexOf(object);
                            if (position == -1 || position == ++count) continue;
                            var8_15.append(MoveCommand.create(domain, owner, feature, object, count));
                        }
                        BasicEList.FastCompare addedValues = new BasicEList.FastCompare((Collection)values);
                        addedValues.removeAll((Collection<?>)remainingValues);
                        ListIterator i = values.listIterator();
                        while (i.hasNext()) {
                            Object object = i.next();
                            if (!addedValues.contains(object)) continue;
                            int addIndex = i.previousIndex();
                            if (addIndex > oldValues.size()) {
                                addIndex = -1;
                            }
                            var8_15.append(AddCommand.create(domain, owner, feature, object, addIndex));
                        }
                        return var8_15;
                    }
                }
                var8_15.append(RemoveCommand.create(domain, owner, feature, new BasicEList((Collection)oldValues)));
            }
            if (!values.isEmpty()) {
                var8_15.append(AddCommand.create(domain, owner, feature, values));
                return var8_15;
            } else if (value == UNSET_VALUE && eReference.isUnsettable()) {
                var8_15.append(domain.createCommand(SetCommand.class, new CommandParameter(owner, feature, value)));
                return var8_15;
            } else {
                if (!var8_15.getCommandList().isEmpty()) return var8_15;
                return IdentityCommand.INSTANCE;
            }
        }
        if (eReference.getEOpposite() == null) return domain.createCommand(SetCommand.class, new CommandParameter(owner, feature, value, index));
        EReference eOtherEnd = eReference.getEOpposite();
        if (eOtherEnd.isMany()) {
            if (eReference.isMany()) {
                EObject eObject;
                EList oppositeList;
                EList list = (EList)((EObject)owner).eGet((EStructuralFeature)eReference);
                if (index != list.size() - 1 || (oppositeList = (EList)(eObject = (EObject)list.get(index)).eGet((EStructuralFeature)eOtherEnd)).get(oppositeList.size() - 1) == owner) return domain.createCommand(SetCommand.class, new CommandParameter(owner, feature, value, index));
                CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION){

                    public Collection<?> getAffectedObjects() {
                        return Collections.singleton(owner);
                    }
                };
                compound.append(RemoveCommand.create(domain, (Object)eObject, (Object)eOtherEnd, owner));
                compound.append(AddCommand.create(domain, owner, feature, value));
                return compound;
            }
            Object oldValue = ((EObject)owner).eGet((EStructuralFeature)eReference);
            if (value == null || value == UNSET_VALUE) {
                if (oldValue == null) {
                    return domain.createCommand(SetCommand.class, new CommandParameter(owner, (Object)eReference, value));
                }
                Command command = RemoveCommand.create(domain, oldValue, (Object)eOtherEnd, (Collection)Collections.singleton(owner));
                if (value != UNSET_VALUE || !eReference.isUnsettable()) {
                    return command;
                }
                PessimisticStrictCompoundCommand compound = new PessimisticStrictCompoundCommand(LABEL, DESCRIPTION);
                compound.append(command);
                compound.append(domain.createCommand(SetCommand.class, new CommandParameter(owner, (Object)eReference, value)));
                return compound;
            }
            CommandWrapper commandWrapper = new CommandWrapper(AddCommand.create(domain, value, (Object)eOtherEnd, (Collection)Collections.singleton(owner))){

                public Collection<?> getAffectedObjects() {
                    return Collections.singleton(owner);
                }
            };
            if (oldValue == null) {
                return commandWrapper;
            }
            CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION);
            compound.append(RemoveCommand.create(domain, oldValue, (Object)eOtherEnd, (Collection)Collections.singleton(owner)));
            compound.append((Command)commandWrapper);
            return compound;
        }
        if (eOtherEnd.isContainment()) {
            if (value == null || value == UNSET_VALUE) return domain.createCommand(SetCommand.class, new CommandParameter(owner, feature, value, index));
            return new CommandWrapper(SetCommand.create(domain, value, eOtherEnd, owner)){

                public Collection<?> getResult() {
                    return Collections.singleton(owner);
                }

                public Collection<?> getAffectedObjects() {
                    return Collections.singleton(owner);
                }
            };
        }
        if (!(value instanceof EObject) || ((EObject)value).eGet((EStructuralFeature)eOtherEnd) == null) return domain.createCommand(SetCommand.class, new CommandParameter(owner, feature, value, index));
        CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE){

            public boolean canUndo() {
                return true;
            }
        };
        if (eReference.isMany()) {
            compound.append(SetCommand.create(domain, value, eOtherEnd, null));
        } else {
            compound.append(domain.createCommand(SetCommand.class, new CommandParameter(value, (Object)eOtherEnd, null)));
        }
        compound.append(domain.createCommand(SetCommand.class, new CommandParameter(owner, (Object)eReference, value, index)));
        return compound;
    }

    public SetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.value = value;
        this.index = -1;
    }

    public SetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.value = value;
        this.index = index;
        if (index != -1) {
            this.ownerList = SetCommand.getOwnerList(owner, feature);
        }
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EList<Object> getOwnerList() {
        return this.ownerList;
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    protected boolean prepare() {
        boolean result = false;
        if (this.owner != null) {
            if (this.domain.isReadOnly(this.owner.eResource())) {
                return false;
            }
            EClass eMetaObject = this.owner.eClass();
            if (eMetaObject.getEAllAttributes().contains((Object)this.feature)) {
                EAttribute eAttribute = (EAttribute)this.feature;
                EClassifier eType = eAttribute.getEType();
                if (this.ownerList != null) {
                    if (!(this.index < 0 || this.index >= this.ownerList.size() || !eType.isInstance(this.value) || eAttribute.isUnique() && this.ownerList.contains(this.value))) {
                        this.oldValue = this.ownerList.get(this.index);
                        result = true;
                    }
                } else if (eAttribute.isMany()) {
                    this.oldValue = this.owner.eIsSet((EStructuralFeature)eAttribute) ? new BasicEList((Collection)((EList)this.owner.eGet(this.feature))) : UNSET_VALUE;
                    if (this.value == UNSET_VALUE) {
                        result = true;
                    } else if (this.value instanceof Collection) {
                        Collection collection = (Collection)this.value;
                        result = true;
                        for (Object object : collection) {
                            if (eType.isInstance(object)) continue;
                            result = false;
                            break;
                        }
                    }
                } else {
                    this.oldValue = this.owner.eIsSet((EStructuralFeature)eAttribute) ? this.owner.eGet(this.feature) : UNSET_VALUE;
                    result = this.value == null || this.value == UNSET_VALUE || eType.isInstance(this.value);
                }
            } else if (eMetaObject.getEAllReferences().contains((Object)this.feature)) {
                EReference eReference = (EReference)this.feature;
                if (this.ownerList != null) {
                    if (!(this.index < 0 || this.index >= this.ownerList.size() || !eReference.getEType().isInstance(this.value) || eReference.isUnique() && this.ownerList.contains(this.value))) {
                        this.oldValue = this.ownerList.get(this.index);
                        result = true;
                    }
                } else if (eReference.isMany()) {
                    if (this.value == UNSET_VALUE || this.value instanceof Collection && ((List)this.value).isEmpty()) {
                        if (!this.owner.eIsSet((EStructuralFeature)eReference)) {
                            result = true;
                            this.oldValue = UNSET_VALUE;
                        } else if (((EList)this.owner.eGet(this.feature)).isEmpty()) {
                            result = true;
                            this.oldValue = Collections.EMPTY_LIST;
                        }
                    }
                } else {
                    this.oldValue = this.owner.eIsSet(this.feature) ? this.owner.eGet(this.feature) : UNSET_VALUE;
                    if (this.value == null || this.value == UNSET_VALUE || eReference.getEType().isInstance(this.value)) {
                        result = true;
                    }
                }
                if (result && eReference.isContainment()) {
                    EObject container = this.owner;
                    while (container != null) {
                        if (this.value == container) {
                            result = false;
                            break;
                        }
                        container = container.eContainer();
                    }
                }
                if (result && eReference.getEOpposite() != null && this.oldValue instanceof EObject) {
                    EReference eOtherEnd = eReference.getEOpposite();
                    if (eOtherEnd.isMany()) {
                        if (this.oldValue != null) {
                            EList oppositeList = (EList)((EObject)this.oldValue).eGet((EStructuralFeature)eOtherEnd);
                            this.canUndo = oppositeList.get(oppositeList.size() - 1) == this.owner;
                        }
                    } else {
                        this.canUndo = this.value == null || this.value == UNSET_VALUE || ((EObject)this.value).eGet((EStructuralFeature)eOtherEnd) == null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void doExecute() {
        if (this.ownerList != null) {
            this.ownerList.set(this.index, this.value);
        } else if (this.value == UNSET_VALUE) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.value);
        }
    }

    @Override
    public boolean doCanUndo() {
        return this.canUndo;
    }

    @Override
    public void doUndo() {
        if (this.ownerList != null) {
            this.ownerList.set(this.index, this.oldValue);
        } else if (this.oldValue == UNSET_VALUE) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.oldValue);
        }
    }

    @Override
    public void doRedo() {
        if (this.ownerList != null) {
            this.ownerList.set(this.index, this.value);
        } else if (this.value == UNSET_VALUE) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.value);
        }
    }

    @Override
    public Collection<?> doGetResult() {
        return Collections.singleton(this.owner);
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.feature + ")");
        if (this.ownerList != null) {
            result.append(" (ownerList: " + this.ownerList + ")");
            result.append(" (index: " + this.index + ")");
        }
        result.append(" (value: " + this.value + ")");
        result.append(" (oldValue: " + this.oldValue + ")");
        return result.toString();
    }

    protected static class PessimisticStrictCompoundCommand
    extends StrictCompoundCommand {
        public PessimisticStrictCompoundCommand(String label, String description) {
            super(label, description);
            this.isPessimistic = true;
        }
    }
}

