/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dnd;

import java.util.ArrayList;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.dnd.DNDDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOObjectDropAdapter
extends DNDDropAdapter<TreeSelection> {
    private static final Transfer[] TRANSFERS = new Transfer[]{LocalTransfer.getInstance()};

    protected CDOObjectDropAdapter(StructuredViewer viewer) {
        super((Transfer)LocalTransfer.getInstance(), viewer);
        this.setExpandEnabled(false);
    }

    protected boolean performDrop(TreeSelection data, Object target) {
        if (target instanceof IContainer.Modifiable) {
            IContainer.Modifiable objectContainer = (IContainer.Modifiable)target;
            ArrayList<CDOObject> elementsToAdd = new ArrayList<CDOObject>();
            Object[] objectArray = data.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (FSMUtil.isWatchable((Object)obj)) {
                    elementsToAdd.add((CDOObject)obj);
                }
                ++n2;
            }
            objectContainer.addAllElements(elementsToAdd);
            return true;
        }
        return false;
    }

    protected boolean validateTarget(Object target, int operation) {
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData type) {
        return this.getTransfer().isSupportedType(type);
    }

    public static void support(StructuredViewer viewer) {
        int dndOperations = 7;
        viewer.addDropSupport(dndOperations, TRANSFERS, (DropTargetListener)new CDOObjectDropAdapter(viewer));
    }
}

