/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOFetchRule;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionIndication.class);
    protected CDOID[] ids;
    protected int referenceChunk;
    protected Map<EClass, CDOFetchRule> fetchRules = new HashMap<EClass, CDOFetchRule>();
    protected CDOID contextID = CDOID.NULL;
    protected int loadRevisionCollectionChunkSize;

    public LoadRevisionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)7);
    }

    public LoadRevisionIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.referenceChunk = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} IDs", new Object[]{size});
        }
        this.ids = new CDOID[size];
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            if (TRACER.isEnabled()) {
                TRACER.format("Read ID: {0}", new Object[]{id});
            }
            this.ids[i] = id;
            ++i;
        }
        int fetchSize = in.readInt();
        if (fetchSize > 0) {
            this.loadRevisionCollectionChunkSize = in.readInt();
            if (this.loadRevisionCollectionChunkSize < 1) {
                this.loadRevisionCollectionChunkSize = 1;
            }
            this.contextID = in.readCDOID();
            if (TRACER.isEnabled()) {
                TRACER.format("Reading fetch rules for context {0}", new Object[]{this.contextID});
            }
            int i2 = 0;
            while (i2 < fetchSize) {
                CDOFetchRule fetchRule = new CDOFetchRule(in, (CDOPackageRegistry)this.getRepository().getPackageRegistry());
                this.fetchRules.put(fetchRule.getEClass(), fetchRule);
                ++i2;
            }
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        ArrayList<CDORevision> additionalRevisions = new ArrayList<CDORevision>();
        HashSet<CDOID> revisionIDs = new HashSet<CDOID>();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} revisions", new Object[]{this.ids.length});
        }
        CDOID[] cDOIDArray = this.ids;
        int n = this.ids.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            revisionIDs.add(id);
            ++n2;
        }
        HashSet<CDOFetchRule> visitedFetchRules = new HashSet<CDOFetchRule>();
        if (!CDOIDUtil.isNull((CDOID)this.contextID) && this.fetchRules.size() > 0) {
            if (TRACER.isEnabled()) {
                TRACER.format("Collecting more revisions based on rules", new Object[0]);
            }
            InternalCDORevision revisionContext = this.getRevision(this.contextID);
            this.collectRevisions(revisionContext, revisionIDs, additionalRevisions, visitedFetchRules);
        }
        CDORevision[] revisions = new CDORevision[this.ids.length];
        int i = 0;
        while (i < this.ids.length) {
            CDOID id = this.ids[i];
            InternalCDORevision revision = this.getRevision(id);
            revisions[i] = revision;
            if (this.loadRevisionCollectionChunkSize > 0) {
                this.collectRevisions(revision, revisionIDs, additionalRevisions, visitedFetchRules);
            }
            ++i;
        }
        this.getRepository().notifyReadAccessHandlers(this.getSession(), revisions, additionalRevisions);
        CDORevision[] cDORevisionArray = revisions;
        int n3 = revisions.length;
        int id = 0;
        while (id < n3) {
            CDORevision revision = cDORevisionArray[id];
            out.writeCDORevision(revision, this.referenceChunk);
            ++id;
        }
        int additionalSize = additionalRevisions.size();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} additional revisions", new Object[]{additionalSize});
        }
        out.writeInt(additionalSize);
        for (CDORevision revision : additionalRevisions) {
            out.writeCDORevision(revision, this.referenceChunk);
        }
    }

    protected InternalCDORevision getRevision(CDOID id) {
        RevisionManager revisionManager = this.getRepository().getRevisionManager();
        return revisionManager.getRevision(id, this.referenceChunk);
    }

    private void collectRevisions(InternalCDORevision revision, Set<CDOID> revisions, List<CDORevision> additionalRevisions, Set<CDOFetchRule> visitedFetchRules) {
        this.getSession().collectContainedRevisions(revision, this.referenceChunk, revisions, additionalRevisions);
        CDOFetchRule fetchRule = this.fetchRules.get(revision.getEClass());
        if (fetchRule == null || visitedFetchRules.contains(fetchRule)) {
            return;
        }
        visitedFetchRules.add(fetchRule);
        RevisionManager revisionManager = (RevisionManager)this.getSession().getSessionManager().getRepository().getRevisionManager();
        for (EStructuralFeature feature : fetchRule.getFeatures()) {
            CDOID id;
            if (feature.isMany()) {
                CDOList list = revision.getList(feature);
                int toIndex = Math.min(this.loadRevisionCollectionChunkSize, list.size()) - 1;
                int i = 0;
                while (i <= toIndex) {
                    CDOID id2;
                    Object value = list.get(i);
                    if (value instanceof CDOID && !CDOIDUtil.isNull((CDOID)(id2 = (CDOID)value)) && !revisions.contains(id2)) {
                        InternalCDORevision containedRevision = revisionManager.getRevision(id2, this.referenceChunk);
                        revisions.add(containedRevision.getID());
                        additionalRevisions.add((CDORevision)containedRevision);
                        this.collectRevisions(containedRevision, revisions, additionalRevisions, visitedFetchRules);
                    }
                    ++i;
                }
                continue;
            }
            Object value = revision.getValue(feature);
            if (!(value instanceof CDOID) || (id = (CDOID)value).isNull() || revisions.contains(id)) continue;
            InternalCDORevision containedRevision = revisionManager.getRevision(id, this.referenceChunk);
            revisions.add(containedRevision.getID());
            additionalRevisions.add((CDORevision)containedRevision);
            this.collectRevisions(containedRevision, revisions, additionalRevisions, visitedFetchRules);
        }
        visitedFetchRules.remove(fetchRule);
    }
}

