/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionDeltaImpl
implements InternalCDORevisionDelta {
    private CDOID cdoID;
    private EClass eClass;
    private int dirtyVersion;
    private int originVersion;
    private Map<EStructuralFeature, CDOFeatureDelta> featureDeltas = new HashMap<EStructuralFeature, CDOFeatureDelta>();

    public CDORevisionDeltaImpl(CDORevision revision) {
        this.cdoID = revision.getID();
        this.eClass = revision.getEClass();
        this.dirtyVersion = revision.getVersion();
        this.originVersion = this.dirtyVersion - 1;
    }

    public CDORevisionDeltaImpl(CDORevisionDelta revisionDelta) {
        this.cdoID = revisionDelta.getID();
        this.eClass = ((CDORevisionDeltaImpl)revisionDelta).eClass;
        this.dirtyVersion = revisionDelta.getDirtyVersion();
        this.originVersion = revisionDelta.getOriginVersion();
        for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
            this.addFeatureDelta(((InternalCDOFeatureDelta)delta).copy());
        }
    }

    public CDORevisionDeltaImpl(CDORevision originRevision, CDORevision dirtyRevision) {
        if (originRevision.getEClass() != dirtyRevision.getEClass()) {
            throw new IllegalArgumentException();
        }
        this.cdoID = originRevision.getID();
        this.eClass = originRevision.getEClass();
        this.dirtyVersion = dirtyRevision.getVersion();
        this.originVersion = originRevision.getVersion();
        this.compare(originRevision, dirtyRevision);
        CDORevisionData originData = originRevision.data();
        CDORevisionData dirtyData = dirtyRevision.data();
        if (!(this.compare(originData.getContainerID(), dirtyData.getContainerID()) && this.compare(originData.getContainingFeatureID(), dirtyData.getContainingFeatureID()) && this.compare(originData.getResourceID(), dirtyData.getResourceID()))) {
            this.addFeatureDelta(new CDOContainerFeatureDeltaImpl(dirtyData.getResourceID(), dirtyData.getContainerID(), dirtyData.getContainingFeatureID()));
        }
    }

    public CDORevisionDeltaImpl(CDODataInput in) throws IOException {
        this.eClass = (EClass)in.readCDOClassifierRefAndResolve();
        this.cdoID = in.readCDOID();
        this.originVersion = in.readInt();
        this.dirtyVersion = in.readInt();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDOFeatureDelta featureDelta = in.readCDOFeatureDelta(this.eClass);
            this.featureDeltas.put(featureDelta.getFeature(), featureDelta);
            ++i;
        }
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOClassifierRef((EClassifier)this.eClass);
        out.writeCDOID(this.cdoID);
        out.writeInt(this.originVersion);
        out.writeInt(this.dirtyVersion);
        out.writeInt(this.featureDeltas.size());
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            out.writeCDOFeatureDelta(this.eClass, featureDelta);
        }
    }

    @Override
    public CDOID getID() {
        return this.cdoID;
    }

    @Override
    public int getOriginVersion() {
        return this.originVersion;
    }

    @Override
    public void setOriginVersion(int originVersion) {
        this.originVersion = originVersion;
    }

    @Override
    public int getDirtyVersion() {
        return this.dirtyVersion;
    }

    @Override
    public void setDirtyVersion(int dirtyVersion) {
        this.dirtyVersion = dirtyVersion;
    }

    @Override
    public List<CDOFeatureDelta> getFeatureDeltas() {
        return new ArrayList<CDOFeatureDelta>(this.featureDeltas.values());
    }

    @Override
    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).setVersion(this.dirtyVersion);
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).apply(revision);
        }
    }

    @Override
    public void addFeatureDelta(CDOFeatureDelta delta) {
        if (delta instanceof CDOListFeatureDelta) {
            CDOListFeatureDelta deltas = (CDOListFeatureDelta)delta;
            for (CDOFeatureDelta childDelta : deltas.getListChanges()) {
                this.addFeatureDelta(childDelta);
            }
        } else {
            this.addSingleFeatureDelta(delta);
        }
    }

    private void addSingleFeatureDelta(CDOFeatureDelta delta) {
        EStructuralFeature feature = delta.getFeature();
        if (feature.isMany()) {
            CDOListFeatureDeltaImpl lookupDelta = (CDOListFeatureDeltaImpl)this.featureDeltas.get(feature);
            if (lookupDelta == null) {
                lookupDelta = new CDOListFeatureDeltaImpl(feature);
                this.featureDeltas.put(lookupDelta.getFeature(), lookupDelta);
            }
            if (delta instanceof CDOClearFeatureDelta) {
                lookupDelta.getListChanges().clear();
            }
            lookupDelta.add(delta);
        } else {
            this.featureDeltas.put(feature, delta);
        }
    }

    @Override
    public void adjustReferences(CDOReferenceAdjuster idMappings) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(idMappings);
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).accept(visitor);
        }
    }

    private void compare(CDORevision originRevision, CDORevision dirtyRevision) {
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures(this.eClass);
        int count = this.eClass.getFeatureCount();
        int i = 0;
        while (i < count) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                int originSize = originRevision.data().size(feature);
                int dirtySize = dirtyRevision.data().size(feature);
                if (dirtySize == 0 && originSize > 0) {
                    this.addFeatureDelta(new CDOClearFeatureDeltaImpl(feature));
                } else {
                    Object dirtyValue;
                    int originIndex = 0;
                    int dirtyIndex = 0;
                    if (originSize == dirtySize) {
                        while (originIndex < originSize && dirtyIndex < dirtySize) {
                            Object originValue = originRevision.data().get(feature, originIndex);
                            if (!this.compare(originValue, dirtyValue = dirtyRevision.data().get(feature, dirtyIndex))) {
                                dirtyIndex = 0;
                                break;
                            }
                            ++dirtyIndex;
                            ++originIndex;
                        }
                    }
                    if (originIndex != originSize || dirtyIndex != dirtySize) {
                        if (originSize > 0) {
                            this.addFeatureDelta(new CDOClearFeatureDeltaImpl(feature));
                        }
                        int k = 0;
                        while (k < dirtySize) {
                            dirtyValue = dirtyRevision.data().get(feature, k);
                            this.addFeatureDelta(new CDOAddFeatureDeltaImpl(feature, k, dirtyValue));
                            ++k;
                        }
                    }
                }
            } else {
                Object dirtyValue;
                Object originValue = originRevision.data().get(feature, 0);
                if (!this.compare(originValue, dirtyValue = dirtyRevision.data().get(feature, 0))) {
                    if (dirtyValue == null) {
                        this.addFeatureDelta(new CDOUnsetFeatureDeltaImpl(feature));
                    } else {
                        this.addFeatureDelta(new CDOSetFeatureDeltaImpl(feature, 0, dirtyValue));
                    }
                }
            }
            ++i;
        }
    }

    private boolean compare(Object originValue, Object dirtyValue) {
        return originValue == dirtyValue || originValue != null && dirtyValue != null && originValue.equals(dirtyValue);
    }
}

