/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LoadChunkRequest
extends CDOClientRequest<Object> {
    private InternalCDORevision revision;
    private EStructuralFeature feature;
    private int accessIndex;
    private int fromIndex;
    private int toIndex;
    private int fetchIndex;

    public LoadChunkRequest(CDOClientProtocol protocol, InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        super(protocol, (short)9);
        this.revision = revision;
        this.feature = feature;
        this.accessIndex = accessIndex;
        this.fetchIndex = fetchIndex;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeCDOID(this.revision.getID());
        out.writeCDOBranch((CDOBranch)this.revision.getBranch());
        out.writeXInt(this.revision.getVersion());
        out.writeCDOClassifierRef((EClassifier)this.feature.getEContainingClass());
        out.writeXInt(this.feature.getFeatureID());
        int diffIndex = this.accessIndex - this.fetchIndex;
        out.writeXInt(this.fromIndex - diffIndex);
        out.writeXInt(this.toIndex - diffIndex);
    }

    @Override
    protected Object confirming(CDODataInput in) throws IOException {
        CDOType type = CDOModelUtil.getType((EStructuralFeature)this.feature);
        Object accessID = null;
        InternalCDOList list = (InternalCDOList)this.revision.getListOrNull(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            Object value = type.readValue(in);
            list.setWithoutFrozenCheck(i, value);
            if (i == this.accessIndex) {
                accessID = value;
            }
            ++i;
        }
        return accessID;
    }
}

