/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.DropReview;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.provider.CommentableItemProvider;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class DropReviewItemProvider
extends ReviewItemProvider {
    public DropReviewItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addVersionPropertyDescriptor(object);
            this.addDeliveryPropertyDescriptor(object);
            this.addTargetTimeStampPropertyDescriptor(object);
            this.addDropTypePropertyDescriptor(object);
            this.addDropLabelPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FixedBaseline_version_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FixedBaseline_version_feature", "_UI_FixedBaseline_type"), (EStructuralFeature)LMPackage.Literals.FIXED_BASELINE__VERSION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDeliveryPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DropReview_delivery_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DropReview_delivery_feature", "_UI_DropReview_type"), (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DELIVERY, false, false, true, null, null, null));
    }

    protected void addTargetTimeStampPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DropReview_targetTimeStamp_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DropReview_targetTimeStamp_feature", "_UI_DropReview_type"), (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__TARGET_TIME_STAMP, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addDropTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DropReview_dropType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DropReview_dropType_feature", "_UI_DropReview_type"), (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DROP_TYPE, false, false, true, null, null, null));
    }

    protected void addDropLabelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DropReview_dropLabel_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DropReview_dropLabel_feature", "_UI_DropReview_type"), (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DROP_LABEL, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(LMPackage.Literals.FIXED_BASELINE__DEPENDENCIES);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        DropReview review = (DropReview)object;
        DropType dropType = review.getDropType();
        String key = dropType != null && dropType.isRelease() ? "Release" : "Drop";
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/" + key + "Review"));
    }

    protected Object overlayImage(Object object, Object image) {
        image = super.overlayImage(object, image);
        return CommentableItemProvider.overlayCommentableImage((Commentable)((Review)object), image);
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return ((StyledString)this.getStyledText(object)).getString();
    }

    @Override
    public Object getStyledText(Object object) {
        DropReview review = (DropReview)object;
        DropType dropType = review.getDropType();
        String type = dropType == null ? this.getString("_UI_Drop") : dropType.getName();
        StyledString styledString = new StyledString(type + " " + this.getString("_UI_Review_type"), StyledString.Style.QUALIFIER_STYLER).append(" ").append(Integer.toString(review.getId()) + " - " + review.getDropLabel());
        return this.appendStatus(styledString, (Review)review);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(DropReview.class)) {
            case 12: 
            case 15: 
            case 17: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 13: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(LMPackage.Literals.FIXED_BASELINE__DEPENDENCIES, LMFactory.eINSTANCE.createDependency()));
    }
}

