/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.etypes.provider.ModelElementItemProvider;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.impl.CommentableImpl;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class CommentableItemProvider
extends ModelElementItemProvider {
    public CommentableItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addReviewPropertyDescriptor(object);
            this.addCommentCountPropertyDescriptor(object);
            this.addUnresolvedCountPropertyDescriptor(object);
            this.addResolvedCountPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addReviewPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Commentable_review_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Commentable_review_feature", "_UI_Commentable_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENTABLE__REVIEW, false, false, false, null, null, null));
    }

    protected void addCommentCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Commentable_commentCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Commentable_commentCount_feature", "_UI_Commentable_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENTABLE__COMMENT_COUNT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addUnresolvedCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Commentable_unresolvedCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Commentable_unresolvedCount_feature", "_UI_Commentable_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENTABLE__UNRESOLVED_COUNT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addResolvedCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Commentable_resolvedCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Commentable_resolvedCount_feature", "_UI_Commentable_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENTABLE__RESOLVED_COUNT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ReviewsPackage.Literals.COMMENTABLE__COMMENTS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        return ((StyledString)this.getStyledText(object)).getString();
    }

    public Object getStyledText(Object object) {
        Commentable commentable = (Commentable)object;
        return new StyledString(this.getString("_UI_Commentable_type"), StyledString.Style.QUALIFIER_STYLER).append(" ").append(Integer.toString(commentable.getCommentCount()));
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        Object notifier = notification.getNotifier();
        switch (notification.getFeatureID(Commentable.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notifier, true, true));
                CommentableItemProvider.propagateNotification((ItemProviderAdapter)this, notification, notifier);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    static Object overlayCommentableImage(Commentable commentable, Object image) {
        CommentableImpl.CommentStatistics statistics = CommentableImpl.getCommentStatistics((Commentable)commentable);
        String overlayKey = null;
        if (statistics.getUnresolvedCount() != 0) {
            overlayKey = "Unresolved";
        } else if (statistics.getResolvedCount() != 0) {
            overlayKey = "Resolved";
        }
        if (overlayKey != null) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(ReviewsEditPlugin.INSTANCE.getImage("full/ovr16/" + overlayKey + ".gif"));
            image = new ComposedImage(images);
        }
        return image;
    }

    static void propagateNotification(ItemProviderAdapter itemProvider, Notification notification, Object notifier) {
        if (notifier instanceof EObject) {
            EObject eContainer = ((EObject)notifier).eContainer();
            while (eContainer instanceof Commentable) {
                itemProvider.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)eContainer, false, true));
                eContainer = eContainer.eContainer();
            }
        }
    }
}

