/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.internal.explorer.AbstractManager;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;

public abstract class LMManager<EE extends CDOExplorerElement, EM extends CDOExplorerManager<EE>, D>
extends Container<D> {
    public static final String STATE_FOLDER_NAME = "lm";
    protected static final String STATE_FILE_NAME = "lm.properties";
    private final IListener explorerManagerListener = new ContainerEventAdapter<EE>(){

        protected void onAdded(IContainer<EE> container, EE explorerElement) {
            LMManager.this.explorerElementAdded(explorerElement);
        }

        protected void onRemoved(IContainer<EE> container, EE explorerElement) {
            LMManager.this.explorerElementRemoved(explorerElement);
        }

        protected void notifyOtherEvent(IEvent event) {
            LMManager.this.notifyExplorerElementEvent(event);
        }
    };
    private final EM explorerManager;
    private final Class<EE> explorerElementType;
    protected final Map<EE, D> descriptors = new HashMap<EE, D>();
    protected int count;

    protected LMManager(EM explorerManager, Class<EE> explorerElementType) {
        this.explorerManager = explorerManager;
        this.explorerElementType = explorerElementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D getDescriptor(EE explorerElement) {
        LMManager lMManager = this;
        synchronized (lMManager) {
            return this.descriptors.get(explorerElement);
        }
    }

    public D[] getDescriptors() {
        ArrayList result = new ArrayList(this.count);
        this.forEachDescriptor(d -> {
            boolean bl = result.add(d);
        });
        return result.toArray(this.newArray(result.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachDescriptor(Consumer<D> consumer) {
        LMManager lMManager = this;
        synchronized (lMManager) {
            for (D descriptor : this.descriptors.values()) {
                if (!this.filterDescriptor(descriptor)) continue;
                consumer.accept(descriptor);
            }
        }
    }

    public D[] getElements() {
        return this.getDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LMManager lMManager = this;
        synchronized (lMManager) {
            return this.count == 0;
        }
    }

    protected final void forEachExplorerElement(Consumer<EE> conumer) {
        CDOExplorerElement[] cDOExplorerElementArray = (CDOExplorerElement[])this.explorerManager.getElements();
        int n = cDOExplorerElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOExplorerElement explorerElement = cDOExplorerElementArray[n2];
            conumer.accept(explorerElement);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doActivate() throws Exception {
        super.doActivate();
        EM EM = this.explorerManager;
        synchronized (EM) {
            this.forEachExplorerElement(explorerElement -> this.explorerElementAdded(explorerElement));
            this.explorerManager.addListener(this.explorerManagerListener);
        }
    }

    protected void doDeactivate() throws Exception {
        this.explorerManager.removeListener(this.explorerManagerListener);
        super.doDeactivate();
    }

    protected boolean filterDescriptor(D descriptor) {
        return true;
    }

    protected abstract D[] newArray(int var1);

    protected abstract void explorerElementAdded(EE var1);

    protected abstract void explorerElementRemoved(EE var1);

    protected void explorerElementChanged(EE explorerElement) {
    }

    protected void notifyExplorerElementEvent(IEvent event) {
        if (event instanceof CDOExplorerManager.ElementsChangedEvent) {
            CDOExplorerManager.ElementsChangedEvent e = (CDOExplorerManager.ElementsChangedEvent)event;
            Object[] objectArray = e.getChangedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.explorerElementType.isInstance(element)) {
                    CDOExplorerElement explorerElement = (CDOExplorerElement)element;
                    this.explorerElementChanged(explorerElement);
                }
                ++n2;
            }
        }
    }

    protected void deleteStateFolder(EE explorerElement) {
        File stateFolder = explorerElement.getStateFolder(STATE_FOLDER_NAME);
        IOUtil.delete((File)stateFolder);
    }

    protected void saveProperties(EE explorerElement, Properties properties) {
        File stateFolder = explorerElement.getStateFolder(STATE_FOLDER_NAME);
        AbstractManager.saveProperties((File)stateFolder, (String)STATE_FILE_NAME, (Properties)properties, (String)(((Object)((Object)this)).getClass().getSimpleName() + " lm.properties"));
    }

    public static <EE extends CDOExplorerElement> Properties loadProperties(EE explorerElement) {
        File stateFolder = explorerElement.getStateFolder(STATE_FOLDER_NAME);
        return AbstractManager.loadProperties((File)stateFolder, (String)STATE_FILE_NAME);
    }
}

