/*
 * Copyright (c) 2013, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.tests.model6;

import org.eclipse.emf.ecore.EObject;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Unsettable Attributes</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigDecimal <em>Attr Big Decimal</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigInteger <em>Attr Big Integer</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#isAttrBoolean <em>Attr Boolean</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBooleanObject <em>Attr Boolean Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByte <em>Attr Byte</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteArray <em>Attr Byte Array</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteObject <em>Attr Byte Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrChar <em>Attr Char</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrCharacterObject <em>Attr Character Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDate <em>Attr Date</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDouble <em>Attr Double</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDoubleObject <em>Attr Double Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloat <em>Attr Float</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloatObject <em>Attr Float Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrInt <em>Attr Int</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrIntegerObject <em>Attr Integer Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaClass <em>Attr Java Class</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaObject <em>Attr Java Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLong <em>Attr Long</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLongObject <em>Attr Long Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShort <em>Attr Short</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShortObject <em>Attr Short Object</em>}</li>
 *   <li>{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrString <em>Attr String</em>}</li>
 * </ul>
 *
 * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes()
 * @model
 * @generated
 */
public interface UnsettableAttributes extends EObject
{
  /**
   * Returns the value of the '<em><b>Attr Big Decimal</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Big Decimal</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Big Decimal</em>' attribute.
   * @see #isSetAttrBigDecimal()
   * @see #unsetAttrBigDecimal()
   * @see #setAttrBigDecimal(BigDecimal)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrBigDecimal()
   * @model unsettable="true"
   * @generated
   */
  BigDecimal getAttrBigDecimal();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigDecimal <em>Attr Big Decimal</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Big Decimal</em>' attribute.
   * @see #isSetAttrBigDecimal()
   * @see #unsetAttrBigDecimal()
   * @see #getAttrBigDecimal()
   * @generated
   */
  void setAttrBigDecimal(BigDecimal value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigDecimal <em>Attr Big Decimal</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrBigDecimal()
   * @see #getAttrBigDecimal()
   * @see #setAttrBigDecimal(BigDecimal)
   * @generated
   */
  void unsetAttrBigDecimal();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigDecimal <em>Attr Big Decimal</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Big Decimal</em>' attribute is set.
   * @see #unsetAttrBigDecimal()
   * @see #getAttrBigDecimal()
   * @see #setAttrBigDecimal(BigDecimal)
   * @generated
   */
  boolean isSetAttrBigDecimal();

  /**
   * Returns the value of the '<em><b>Attr Big Integer</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Big Integer</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Big Integer</em>' attribute.
   * @see #isSetAttrBigInteger()
   * @see #unsetAttrBigInteger()
   * @see #setAttrBigInteger(BigInteger)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrBigInteger()
   * @model unsettable="true"
   * @generated
   */
  BigInteger getAttrBigInteger();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigInteger <em>Attr Big Integer</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Big Integer</em>' attribute.
   * @see #isSetAttrBigInteger()
   * @see #unsetAttrBigInteger()
   * @see #getAttrBigInteger()
   * @generated
   */
  void setAttrBigInteger(BigInteger value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigInteger <em>Attr Big Integer</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrBigInteger()
   * @see #getAttrBigInteger()
   * @see #setAttrBigInteger(BigInteger)
   * @generated
   */
  void unsetAttrBigInteger();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBigInteger <em>Attr Big Integer</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Big Integer</em>' attribute is set.
   * @see #unsetAttrBigInteger()
   * @see #getAttrBigInteger()
   * @see #setAttrBigInteger(BigInteger)
   * @generated
   */
  boolean isSetAttrBigInteger();

  /**
   * Returns the value of the '<em><b>Attr Boolean</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Boolean</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Boolean</em>' attribute.
   * @see #isSetAttrBoolean()
   * @see #unsetAttrBoolean()
   * @see #setAttrBoolean(boolean)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrBoolean()
   * @model unsettable="true"
   * @generated
   */
  boolean isAttrBoolean();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#isAttrBoolean <em>Attr Boolean</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Boolean</em>' attribute.
   * @see #isSetAttrBoolean()
   * @see #unsetAttrBoolean()
   * @see #isAttrBoolean()
   * @generated
   */
  void setAttrBoolean(boolean value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#isAttrBoolean <em>Attr Boolean</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrBoolean()
   * @see #isAttrBoolean()
   * @see #setAttrBoolean(boolean)
   * @generated
   */
  void unsetAttrBoolean();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#isAttrBoolean <em>Attr Boolean</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Boolean</em>' attribute is set.
   * @see #unsetAttrBoolean()
   * @see #isAttrBoolean()
   * @see #setAttrBoolean(boolean)
   * @generated
   */
  boolean isSetAttrBoolean();

  /**
   * Returns the value of the '<em><b>Attr Boolean Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Boolean Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Boolean Object</em>' attribute.
   * @see #isSetAttrBooleanObject()
   * @see #unsetAttrBooleanObject()
   * @see #setAttrBooleanObject(Boolean)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrBooleanObject()
   * @model unsettable="true"
   * @generated
   */
  Boolean getAttrBooleanObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBooleanObject <em>Attr Boolean Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Boolean Object</em>' attribute.
   * @see #isSetAttrBooleanObject()
   * @see #unsetAttrBooleanObject()
   * @see #getAttrBooleanObject()
   * @generated
   */
  void setAttrBooleanObject(Boolean value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBooleanObject <em>Attr Boolean Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrBooleanObject()
   * @see #getAttrBooleanObject()
   * @see #setAttrBooleanObject(Boolean)
   * @generated
   */
  void unsetAttrBooleanObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrBooleanObject <em>Attr Boolean Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Boolean Object</em>' attribute is set.
   * @see #unsetAttrBooleanObject()
   * @see #getAttrBooleanObject()
   * @see #setAttrBooleanObject(Boolean)
   * @generated
   */
  boolean isSetAttrBooleanObject();

  /**
   * Returns the value of the '<em><b>Attr Byte</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Byte</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Byte</em>' attribute.
   * @see #isSetAttrByte()
   * @see #unsetAttrByte()
   * @see #setAttrByte(byte)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrByte()
   * @model unsettable="true"
   * @generated
   */
  byte getAttrByte();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByte <em>Attr Byte</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Byte</em>' attribute.
   * @see #isSetAttrByte()
   * @see #unsetAttrByte()
   * @see #getAttrByte()
   * @generated
   */
  void setAttrByte(byte value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByte <em>Attr Byte</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrByte()
   * @see #getAttrByte()
   * @see #setAttrByte(byte)
   * @generated
   */
  void unsetAttrByte();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByte <em>Attr Byte</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Byte</em>' attribute is set.
   * @see #unsetAttrByte()
   * @see #getAttrByte()
   * @see #setAttrByte(byte)
   * @generated
   */
  boolean isSetAttrByte();

  /**
   * Returns the value of the '<em><b>Attr Byte Array</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Byte Array</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Byte Array</em>' attribute.
   * @see #isSetAttrByteArray()
   * @see #unsetAttrByteArray()
   * @see #setAttrByteArray(byte[])
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrByteArray()
   * @model unsettable="true"
   * @generated
   */
  byte[] getAttrByteArray();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteArray <em>Attr Byte Array</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Byte Array</em>' attribute.
   * @see #isSetAttrByteArray()
   * @see #unsetAttrByteArray()
   * @see #getAttrByteArray()
   * @generated
   */
  void setAttrByteArray(byte[] value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteArray <em>Attr Byte Array</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrByteArray()
   * @see #getAttrByteArray()
   * @see #setAttrByteArray(byte[])
   * @generated
   */
  void unsetAttrByteArray();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteArray <em>Attr Byte Array</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Byte Array</em>' attribute is set.
   * @see #unsetAttrByteArray()
   * @see #getAttrByteArray()
   * @see #setAttrByteArray(byte[])
   * @generated
   */
  boolean isSetAttrByteArray();

  /**
   * Returns the value of the '<em><b>Attr Byte Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Byte Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Byte Object</em>' attribute.
   * @see #isSetAttrByteObject()
   * @see #unsetAttrByteObject()
   * @see #setAttrByteObject(Byte)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrByteObject()
   * @model unsettable="true"
   * @generated
   */
  Byte getAttrByteObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteObject <em>Attr Byte Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Byte Object</em>' attribute.
   * @see #isSetAttrByteObject()
   * @see #unsetAttrByteObject()
   * @see #getAttrByteObject()
   * @generated
   */
  void setAttrByteObject(Byte value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteObject <em>Attr Byte Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrByteObject()
   * @see #getAttrByteObject()
   * @see #setAttrByteObject(Byte)
   * @generated
   */
  void unsetAttrByteObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrByteObject <em>Attr Byte Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Byte Object</em>' attribute is set.
   * @see #unsetAttrByteObject()
   * @see #getAttrByteObject()
   * @see #setAttrByteObject(Byte)
   * @generated
   */
  boolean isSetAttrByteObject();

  /**
   * Returns the value of the '<em><b>Attr Char</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Char</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Char</em>' attribute.
   * @see #isSetAttrChar()
   * @see #unsetAttrChar()
   * @see #setAttrChar(char)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrChar()
   * @model unsettable="true"
   * @generated
   */
  char getAttrChar();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrChar <em>Attr Char</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Char</em>' attribute.
   * @see #isSetAttrChar()
   * @see #unsetAttrChar()
   * @see #getAttrChar()
   * @generated
   */
  void setAttrChar(char value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrChar <em>Attr Char</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrChar()
   * @see #getAttrChar()
   * @see #setAttrChar(char)
   * @generated
   */
  void unsetAttrChar();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrChar <em>Attr Char</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Char</em>' attribute is set.
   * @see #unsetAttrChar()
   * @see #getAttrChar()
   * @see #setAttrChar(char)
   * @generated
   */
  boolean isSetAttrChar();

  /**
   * Returns the value of the '<em><b>Attr Character Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Character Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Character Object</em>' attribute.
   * @see #isSetAttrCharacterObject()
   * @see #unsetAttrCharacterObject()
   * @see #setAttrCharacterObject(Character)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrCharacterObject()
   * @model unsettable="true"
   * @generated
   */
  Character getAttrCharacterObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrCharacterObject <em>Attr Character Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Character Object</em>' attribute.
   * @see #isSetAttrCharacterObject()
   * @see #unsetAttrCharacterObject()
   * @see #getAttrCharacterObject()
   * @generated
   */
  void setAttrCharacterObject(Character value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrCharacterObject <em>Attr Character Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrCharacterObject()
   * @see #getAttrCharacterObject()
   * @see #setAttrCharacterObject(Character)
   * @generated
   */
  void unsetAttrCharacterObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrCharacterObject <em>Attr Character Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Character Object</em>' attribute is set.
   * @see #unsetAttrCharacterObject()
   * @see #getAttrCharacterObject()
   * @see #setAttrCharacterObject(Character)
   * @generated
   */
  boolean isSetAttrCharacterObject();

  /**
   * Returns the value of the '<em><b>Attr Date</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Date</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Date</em>' attribute.
   * @see #isSetAttrDate()
   * @see #unsetAttrDate()
   * @see #setAttrDate(Date)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrDate()
   * @model unsettable="true"
   * @generated
   */
  Date getAttrDate();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDate <em>Attr Date</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Date</em>' attribute.
   * @see #isSetAttrDate()
   * @see #unsetAttrDate()
   * @see #getAttrDate()
   * @generated
   */
  void setAttrDate(Date value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDate <em>Attr Date</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrDate()
   * @see #getAttrDate()
   * @see #setAttrDate(Date)
   * @generated
   */
  void unsetAttrDate();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDate <em>Attr Date</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Date</em>' attribute is set.
   * @see #unsetAttrDate()
   * @see #getAttrDate()
   * @see #setAttrDate(Date)
   * @generated
   */
  boolean isSetAttrDate();

  /**
   * Returns the value of the '<em><b>Attr Double</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Double</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Double</em>' attribute.
   * @see #isSetAttrDouble()
   * @see #unsetAttrDouble()
   * @see #setAttrDouble(double)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrDouble()
   * @model unsettable="true"
   * @generated
   */
  double getAttrDouble();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDouble <em>Attr Double</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Double</em>' attribute.
   * @see #isSetAttrDouble()
   * @see #unsetAttrDouble()
   * @see #getAttrDouble()
   * @generated
   */
  void setAttrDouble(double value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDouble <em>Attr Double</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrDouble()
   * @see #getAttrDouble()
   * @see #setAttrDouble(double)
   * @generated
   */
  void unsetAttrDouble();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDouble <em>Attr Double</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Double</em>' attribute is set.
   * @see #unsetAttrDouble()
   * @see #getAttrDouble()
   * @see #setAttrDouble(double)
   * @generated
   */
  boolean isSetAttrDouble();

  /**
   * Returns the value of the '<em><b>Attr Double Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Double Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Double Object</em>' attribute.
   * @see #isSetAttrDoubleObject()
   * @see #unsetAttrDoubleObject()
   * @see #setAttrDoubleObject(Double)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrDoubleObject()
   * @model unsettable="true"
   * @generated
   */
  Double getAttrDoubleObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDoubleObject <em>Attr Double Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Double Object</em>' attribute.
   * @see #isSetAttrDoubleObject()
   * @see #unsetAttrDoubleObject()
   * @see #getAttrDoubleObject()
   * @generated
   */
  void setAttrDoubleObject(Double value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDoubleObject <em>Attr Double Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrDoubleObject()
   * @see #getAttrDoubleObject()
   * @see #setAttrDoubleObject(Double)
   * @generated
   */
  void unsetAttrDoubleObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrDoubleObject <em>Attr Double Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Double Object</em>' attribute is set.
   * @see #unsetAttrDoubleObject()
   * @see #getAttrDoubleObject()
   * @see #setAttrDoubleObject(Double)
   * @generated
   */
  boolean isSetAttrDoubleObject();

  /**
   * Returns the value of the '<em><b>Attr Float</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Float</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Float</em>' attribute.
   * @see #isSetAttrFloat()
   * @see #unsetAttrFloat()
   * @see #setAttrFloat(float)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrFloat()
   * @model unsettable="true"
   * @generated
   */
  float getAttrFloat();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloat <em>Attr Float</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Float</em>' attribute.
   * @see #isSetAttrFloat()
   * @see #unsetAttrFloat()
   * @see #getAttrFloat()
   * @generated
   */
  void setAttrFloat(float value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloat <em>Attr Float</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrFloat()
   * @see #getAttrFloat()
   * @see #setAttrFloat(float)
   * @generated
   */
  void unsetAttrFloat();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloat <em>Attr Float</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Float</em>' attribute is set.
   * @see #unsetAttrFloat()
   * @see #getAttrFloat()
   * @see #setAttrFloat(float)
   * @generated
   */
  boolean isSetAttrFloat();

  /**
   * Returns the value of the '<em><b>Attr Float Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Float Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Float Object</em>' attribute.
   * @see #isSetAttrFloatObject()
   * @see #unsetAttrFloatObject()
   * @see #setAttrFloatObject(Float)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrFloatObject()
   * @model unsettable="true"
   * @generated
   */
  Float getAttrFloatObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloatObject <em>Attr Float Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Float Object</em>' attribute.
   * @see #isSetAttrFloatObject()
   * @see #unsetAttrFloatObject()
   * @see #getAttrFloatObject()
   * @generated
   */
  void setAttrFloatObject(Float value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloatObject <em>Attr Float Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrFloatObject()
   * @see #getAttrFloatObject()
   * @see #setAttrFloatObject(Float)
   * @generated
   */
  void unsetAttrFloatObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrFloatObject <em>Attr Float Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Float Object</em>' attribute is set.
   * @see #unsetAttrFloatObject()
   * @see #getAttrFloatObject()
   * @see #setAttrFloatObject(Float)
   * @generated
   */
  boolean isSetAttrFloatObject();

  /**
   * Returns the value of the '<em><b>Attr Int</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Int</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Int</em>' attribute.
   * @see #isSetAttrInt()
   * @see #unsetAttrInt()
   * @see #setAttrInt(int)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrInt()
   * @model unsettable="true"
   * @generated
   */
  int getAttrInt();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrInt <em>Attr Int</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Int</em>' attribute.
   * @see #isSetAttrInt()
   * @see #unsetAttrInt()
   * @see #getAttrInt()
   * @generated
   */
  void setAttrInt(int value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrInt <em>Attr Int</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrInt()
   * @see #getAttrInt()
   * @see #setAttrInt(int)
   * @generated
   */
  void unsetAttrInt();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrInt <em>Attr Int</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Int</em>' attribute is set.
   * @see #unsetAttrInt()
   * @see #getAttrInt()
   * @see #setAttrInt(int)
   * @generated
   */
  boolean isSetAttrInt();

  /**
   * Returns the value of the '<em><b>Attr Integer Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Integer Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Integer Object</em>' attribute.
   * @see #isSetAttrIntegerObject()
   * @see #unsetAttrIntegerObject()
   * @see #setAttrIntegerObject(Integer)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrIntegerObject()
   * @model unsettable="true"
   * @generated
   */
  Integer getAttrIntegerObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrIntegerObject <em>Attr Integer Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Integer Object</em>' attribute.
   * @see #isSetAttrIntegerObject()
   * @see #unsetAttrIntegerObject()
   * @see #getAttrIntegerObject()
   * @generated
   */
  void setAttrIntegerObject(Integer value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrIntegerObject <em>Attr Integer Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrIntegerObject()
   * @see #getAttrIntegerObject()
   * @see #setAttrIntegerObject(Integer)
   * @generated
   */
  void unsetAttrIntegerObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrIntegerObject <em>Attr Integer Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Integer Object</em>' attribute is set.
   * @see #unsetAttrIntegerObject()
   * @see #getAttrIntegerObject()
   * @see #setAttrIntegerObject(Integer)
   * @generated
   */
  boolean isSetAttrIntegerObject();

  /**
   * Returns the value of the '<em><b>Attr Java Class</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Java Class</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Java Class</em>' attribute.
   * @see #isSetAttrJavaClass()
   * @see #unsetAttrJavaClass()
   * @see #setAttrJavaClass(Class)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrJavaClass()
   * @model unsettable="true"
   * @generated
   */
  Class<?> getAttrJavaClass();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaClass <em>Attr Java Class</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Java Class</em>' attribute.
   * @see #isSetAttrJavaClass()
   * @see #unsetAttrJavaClass()
   * @see #getAttrJavaClass()
   * @generated
   */
  void setAttrJavaClass(Class<?> value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaClass <em>Attr Java Class</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrJavaClass()
   * @see #getAttrJavaClass()
   * @see #setAttrJavaClass(Class)
   * @generated
   */
  void unsetAttrJavaClass();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaClass <em>Attr Java Class</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Java Class</em>' attribute is set.
   * @see #unsetAttrJavaClass()
   * @see #getAttrJavaClass()
   * @see #setAttrJavaClass(Class)
   * @generated
   */
  boolean isSetAttrJavaClass();

  /**
   * Returns the value of the '<em><b>Attr Java Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Java Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Java Object</em>' attribute.
   * @see #isSetAttrJavaObject()
   * @see #unsetAttrJavaObject()
   * @see #setAttrJavaObject(Object)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrJavaObject()
   * @model unsettable="true"
   * @generated
   */
  Object getAttrJavaObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaObject <em>Attr Java Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Java Object</em>' attribute.
   * @see #isSetAttrJavaObject()
   * @see #unsetAttrJavaObject()
   * @see #getAttrJavaObject()
   * @generated
   */
  void setAttrJavaObject(Object value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaObject <em>Attr Java Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrJavaObject()
   * @see #getAttrJavaObject()
   * @see #setAttrJavaObject(Object)
   * @generated
   */
  void unsetAttrJavaObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrJavaObject <em>Attr Java Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Java Object</em>' attribute is set.
   * @see #unsetAttrJavaObject()
   * @see #getAttrJavaObject()
   * @see #setAttrJavaObject(Object)
   * @generated
   */
  boolean isSetAttrJavaObject();

  /**
   * Returns the value of the '<em><b>Attr Long</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Long</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Long</em>' attribute.
   * @see #isSetAttrLong()
   * @see #unsetAttrLong()
   * @see #setAttrLong(long)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrLong()
   * @model unsettable="true"
   * @generated
   */
  long getAttrLong();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLong <em>Attr Long</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Long</em>' attribute.
   * @see #isSetAttrLong()
   * @see #unsetAttrLong()
   * @see #getAttrLong()
   * @generated
   */
  void setAttrLong(long value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLong <em>Attr Long</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrLong()
   * @see #getAttrLong()
   * @see #setAttrLong(long)
   * @generated
   */
  void unsetAttrLong();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLong <em>Attr Long</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Long</em>' attribute is set.
   * @see #unsetAttrLong()
   * @see #getAttrLong()
   * @see #setAttrLong(long)
   * @generated
   */
  boolean isSetAttrLong();

  /**
   * Returns the value of the '<em><b>Attr Long Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Long Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Long Object</em>' attribute.
   * @see #isSetAttrLongObject()
   * @see #unsetAttrLongObject()
   * @see #setAttrLongObject(Long)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrLongObject()
   * @model unsettable="true"
   * @generated
   */
  Long getAttrLongObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLongObject <em>Attr Long Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Long Object</em>' attribute.
   * @see #isSetAttrLongObject()
   * @see #unsetAttrLongObject()
   * @see #getAttrLongObject()
   * @generated
   */
  void setAttrLongObject(Long value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLongObject <em>Attr Long Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrLongObject()
   * @see #getAttrLongObject()
   * @see #setAttrLongObject(Long)
   * @generated
   */
  void unsetAttrLongObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrLongObject <em>Attr Long Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Long Object</em>' attribute is set.
   * @see #unsetAttrLongObject()
   * @see #getAttrLongObject()
   * @see #setAttrLongObject(Long)
   * @generated
   */
  boolean isSetAttrLongObject();

  /**
   * Returns the value of the '<em><b>Attr Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Short</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Short</em>' attribute.
   * @see #isSetAttrShort()
   * @see #unsetAttrShort()
   * @see #setAttrShort(short)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrShort()
   * @model unsettable="true"
   * @generated
   */
  short getAttrShort();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShort <em>Attr Short</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Short</em>' attribute.
   * @see #isSetAttrShort()
   * @see #unsetAttrShort()
   * @see #getAttrShort()
   * @generated
   */
  void setAttrShort(short value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShort <em>Attr Short</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrShort()
   * @see #getAttrShort()
   * @see #setAttrShort(short)
   * @generated
   */
  void unsetAttrShort();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShort <em>Attr Short</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Short</em>' attribute is set.
   * @see #unsetAttrShort()
   * @see #getAttrShort()
   * @see #setAttrShort(short)
   * @generated
   */
  boolean isSetAttrShort();

  /**
   * Returns the value of the '<em><b>Attr Short Object</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr Short Object</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr Short Object</em>' attribute.
   * @see #isSetAttrShortObject()
   * @see #unsetAttrShortObject()
   * @see #setAttrShortObject(Short)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrShortObject()
   * @model unsettable="true"
   * @generated
   */
  Short getAttrShortObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShortObject <em>Attr Short Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr Short Object</em>' attribute.
   * @see #isSetAttrShortObject()
   * @see #unsetAttrShortObject()
   * @see #getAttrShortObject()
   * @generated
   */
  void setAttrShortObject(Short value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShortObject <em>Attr Short Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrShortObject()
   * @see #getAttrShortObject()
   * @see #setAttrShortObject(Short)
   * @generated
   */
  void unsetAttrShortObject();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrShortObject <em>Attr Short Object</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr Short Object</em>' attribute is set.
   * @see #unsetAttrShortObject()
   * @see #getAttrShortObject()
   * @see #setAttrShortObject(Short)
   * @generated
   */
  boolean isSetAttrShortObject();

  /**
   * Returns the value of the '<em><b>Attr String</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Attr String</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Attr String</em>' attribute.
   * @see #isSetAttrString()
   * @see #unsetAttrString()
   * @see #setAttrString(String)
   * @see org.eclipse.emf.cdo.tests.model6.Model6Package#getUnsettableAttributes_AttrString()
   * @model unsettable="true"
   * @generated
   */
  String getAttrString();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrString <em>Attr String</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Attr String</em>' attribute.
   * @see #isSetAttrString()
   * @see #unsetAttrString()
   * @see #getAttrString()
   * @generated
   */
  void setAttrString(String value);

  /**
   * Unsets the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrString <em>Attr String</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isSetAttrString()
   * @see #getAttrString()
   * @see #setAttrString(String)
   * @generated
   */
  void unsetAttrString();

  /**
   * Returns whether the value of the '{@link org.eclipse.emf.cdo.tests.model6.UnsettableAttributes#getAttrString <em>Attr String</em>}' attribute is set.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return whether the value of the '<em>Attr String</em>' attribute is set.
   * @see #unsetAttrString()
   * @see #getAttrString()
   * @see #setAttrString(String)
   * @generated
   */
  boolean isSetAttrString();

} // UnsettableAttributes
