/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.tcp.ssl.SSLUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public abstract class AbstractTransportTest
extends AbstractOMTest {
    protected static final String HOST = "localhost";
    protected IManagedContainer container;
    protected IManagedContainer separateContainer;
    private IAcceptor acceptor;
    private IConnector connector;

    protected AbstractTransportTest() {
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.container = this.createContainer();
        LifecycleUtil.activate((Object)this.container);
        if (!this.useJVMTransport() && this.useSSLTransport()) {
            this.separateContainer = this.createContainer();
            LifecycleUtil.activate((Object)this.separateContainer);
        }
    }

    @Override
    protected void doTearDown() throws Exception {
        try {
            AbstractTransportTest.sleep(20L);
            LifecycleUtil.deactivate((Object)this.container);
        }
        finally {
            this.connector = null;
            this.acceptor = null;
            this.container = null;
            if (!this.useJVMTransport() && this.useSSLTransport()) {
                this.separateContainer = null;
            }
            super.doTearDown();
        }
    }

    protected boolean useJVMTransport() {
        return false;
    }

    protected boolean useSSLTransport() {
        return false;
    }

    protected IManagedContainer createContainer() {
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        if (this.useJVMTransport()) {
            JVMUtil.prepareContainer((IManagedContainer)container);
        } else if (this.useSSLTransport()) {
            SSLUtil.prepareContainer((IManagedContainer)container);
        } else {
            TCPUtil.prepareContainer((IManagedContainer)container);
        }
        return container;
    }

    protected IAcceptor getAcceptor() {
        if (this.acceptor == null) {
            this.acceptor = this.useJVMTransport() ? JVMUtil.getAcceptor((IManagedContainer)this.container, (String)"default") : (this.useSSLTransport() ? SSLUtil.getAcceptor((IManagedContainer)this.container, null) : TCPUtil.getAcceptor((IManagedContainer)this.container, null));
        }
        return this.acceptor;
    }

    protected IConnector getConnector() {
        if (this.connector == null) {
            this.connector = this.useJVMTransport() ? JVMUtil.getConnector((IManagedContainer)this.container, (String)"default") : (this.useSSLTransport() ? SSLUtil.getConnector((IManagedContainer)this.separateContainer, (String)HOST) : TCPUtil.getConnector((IManagedContainer)this.container, (String)HOST));
        }
        return this.connector;
    }

    protected void startTransport() throws Exception {
        if (this.container != null) {
            IAcceptor acceptor = this.getAcceptor();
            LifecycleUtil.activate((Object)acceptor);
            IConnector connector = this.getConnector();
            LifecycleUtil.activate((Object)connector);
        }
    }

    protected void stopTransport() throws Exception {
        this.connector.close();
        this.connector = null;
        this.acceptor.close();
        this.acceptor = null;
    }

    protected void restartContainer() throws Exception {
        AbstractTransportTest.msg("RESTARTING CONTAINER");
        this.stopTransport();
        LifecycleUtil.deactivate((Object)this.container);
        this.container = this.createContainer();
        LifecycleUtil.activate((Object)this.container);
        if (!this.useJVMTransport() && this.useSSLTransport()) {
            LifecycleUtil.deactivate((Object)this.separateContainer);
            this.separateContainer = this.createContainer();
            LifecycleUtil.activate((Object)this.separateContainer);
        }
        this.startTransport();
        AbstractTransportTest.msg("RESTARTING CONTAINER - FINISHED");
    }
}

