/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.buddies.IBuddyCollaboration;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IFacility;
import org.eclipse.net4j.buddies.common.IFacilityInstalledEvent;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.internal.ui.messages.Messages;
import org.eclipse.net4j.buddies.internal.ui.views.CollaborationsView;
import org.eclipse.net4j.buddies.internal.ui.views.FacilityPane;
import org.eclipse.net4j.buddies.ui.IFacilityPaneCreator;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IContainerEventVisitor;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class CollaborationsPane
extends Composite
implements IListener {
    private CollaborationsView collaborationsView;
    private IBuddySession session;
    private IBuddyCollaboration activeCollaboration;
    private Map<IBuddyCollaboration, IFacility> activeFacilities = new HashMap<IBuddyCollaboration, IFacility>();
    private Map<IFacility, FacilityPane> facilityPanes = new HashMap<IFacility, FacilityPane>();
    private List<ActivateFacilityAction> activateFacilityActions = new ArrayList<ActivateFacilityAction>();
    private StackLayout paneStack = new StackLayout();

    public CollaborationsPane(Composite parent, CollaborationsView collaborationsView) {
        super(parent, 0);
        this.setLayout((Layout)this.paneStack);
        this.collaborationsView = collaborationsView;
    }

    public CollaborationsView getCollaborationsView() {
        return this.collaborationsView;
    }

    public IBuddySession getSession() {
        return this.session;
    }

    public void setSession(IBuddySession session) {
        this.session = session;
        if (session != null) {
            ICollaboration[] iCollaborationArray = session.getSelf().getCollaborations();
            int n = iCollaborationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICollaboration collaboration = iCollaborationArray[n2];
                this.collaborationAdded((IBuddyCollaboration)collaboration);
                ++n2;
            }
        }
        this.updateState();
    }

    public IBuddyCollaboration getActiveCollaboration() {
        return this.activeCollaboration;
    }

    public void setActiveCollaboration(IBuddyCollaboration collaboration) {
        if (this.activeCollaboration != collaboration) {
            this.activeCollaboration = collaboration;
            IFacility facility = this.activeFacilities.get(collaboration);
            this.setActiveFacility(collaboration, facility);
            this.updateState();
            this.collaborationsView.refreshViewer(true);
        }
    }

    public void setActiveFacility(IBuddyCollaboration collaboration, IFacility facility) {
        this.activeFacilities.put(collaboration, facility);
        if (collaboration == this.activeCollaboration) {
            FacilityPane facilityPane = this.facilityPanes.get(facility);
            this.setActiveFacilityPane(facilityPane);
            this.updateState();
        }
    }

    protected void setActiveFacilityPane(FacilityPane newPane) {
        if (this.paneStack.topControl != newPane) {
            FacilityPane oldPane = (FacilityPane)this.paneStack.topControl;
            if (oldPane != null) {
                oldPane.hidden(newPane);
            }
            this.paneStack.topControl = newPane;
            this.layout();
            if (newPane != null) {
                newPane.showed(oldPane);
            }
            this.updateState();
        }
    }

    public void fillActionBars(IActionBars bars) {
        IToolBarManager manager = bars.getToolBarManager();
        for (IFacilityPaneCreator c : this.collaborationsView.getFacilityPaneCreators().values()) {
            ActivateFacilityAction action = new ActivateFacilityAction(c.getType(), c.getImageDescriptor());
            this.activateFacilityActions.add(action);
            manager.add((IAction)action);
        }
    }

    public void updateState() {
        for (ActivateFacilityAction action : this.activateFacilityActions) {
            if (this.activeCollaboration == null) {
                action.setEnabled(false);
                continue;
            }
            String type = action.getType();
            action.setEnabled(this.activeCollaboration.getFacility(type) != null);
            IFacility activeFacility = this.activeFacilities.get(this.activeCollaboration);
            action.setChecked(activeFacility != null && ObjectUtil.equals((Object)activeFacility.getType(), (Object)type));
        }
    }

    public void notifyEvent(IEvent event) {
        if (this.session == null) {
            return;
        }
        if (event.getSource() == this.session.getSelf() && event instanceof IContainerEvent) {
            IContainerEvent e = (IContainerEvent)event;
            e.accept((IContainerEventVisitor)new IContainerEventVisitor<IMembership>(){

                public void added(IMembership membership) {
                    CollaborationsPane.this.collaborationAdded((IBuddyCollaboration)membership.getCollaboration());
                }

                public void removed(IMembership membership) {
                    CollaborationsPane.this.collaborationRemoved((IBuddyCollaboration)membership.getCollaboration());
                }
            });
        } else if (event instanceof IFacilityInstalledEvent) {
            IFacilityInstalledEvent e = (IFacilityInstalledEvent)event;
            this.facilityInstalled(e.getFacility(), e.fromRemote());
        }
    }

    protected void collaborationAdded(IBuddyCollaboration collaboration) {
        IFacility[] facilities;
        IFacility[] iFacilityArray = facilities = collaboration.getFacilities();
        int n = facilities.length;
        int n2 = 0;
        while (n2 < n) {
            IFacility facility = iFacilityArray[n2];
            this.addFacilityPane(facility);
            ++n2;
        }
        if (this.activeCollaboration == null) {
            this.setActiveCollaboration(collaboration);
        }
        if (facilities.length != 0) {
            this.setActiveFacility(collaboration, facilities[0]);
        }
        collaboration.addListener((IListener)this);
    }

    protected void collaborationRemoved(IBuddyCollaboration collaboration) {
        collaboration.removeListener((IListener)this);
        if (this.activeCollaboration == collaboration) {
            this.setActiveCollaboration(this.activeFacilities.isEmpty() ? null : this.activeFacilities.keySet().iterator().next());
        }
        this.activeFacilities.remove(collaboration);
        IFacility[] iFacilityArray = collaboration.getFacilities();
        int n = iFacilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacility facility = iFacilityArray[n2];
            FacilityPane pane = this.facilityPanes.remove(facility);
            if (pane != null) {
                pane.dispose();
            }
            ++n2;
        }
    }

    protected void facilityInstalled(final IFacility facility, boolean fromRemote) {
        block5: {
            final IBuddyCollaboration collaboration = (IBuddyCollaboration)facility.getCollaboration();
            if (fromRemote) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CollaborationsPane.this.addFacilityPane(facility);
                            IFacility activeFacility = (IFacility)CollaborationsPane.this.activeFacilities.get(collaboration);
                            if (activeFacility == null) {
                                CollaborationsPane.this.setActiveFacility(collaboration, facility);
                            } else {
                                CollaborationsPane.this.updateState();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                };
                try {
                    Display display = this.getDisplay();
                    if (display.getThread() == Thread.currentThread()) {
                        runnable.run();
                        break block5;
                    }
                    display.asyncExec(runnable);
                }
                catch (RuntimeException runtimeException) {}
            } else {
                this.addFacilityPane(facility);
                this.setActiveCollaboration(collaboration);
                this.setActiveFacility(collaboration, facility);
            }
        }
    }

    protected FacilityPane addFacilityPane(IFacility facility) {
        IFacilityPaneCreator creator = this.collaborationsView.getFacilityPaneCreators().get(facility.getType());
        FacilityPane pane = creator.createPane(this, 0);
        pane.setFacility(facility);
        this.facilityPanes.put(facility, pane);
        return pane;
    }

    private final class ActivateFacilityAction
    extends SafeAction {
        private final String type;

        private ActivateFacilityAction(String type, ImageDescriptor descriptor) {
            super(StringUtil.cap((String)type), 8);
            this.setToolTipText(MessageFormat.format(Messages.getString("CollaborationsPane_0"), type));
            this.setImageDescriptor(descriptor);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        protected void safeRun() throws Exception {
            if (CollaborationsPane.this.activeCollaboration != null) {
                IFacility facility = CollaborationsPane.this.activeCollaboration.getFacility(this.type);
                CollaborationsPane.this.setActiveFacility(CollaborationsPane.this.activeCollaboration, facility);
            }
        }
    }
}

