/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompositeUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.DelegatingUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformPluginUnitResolver
extends DelegatingUnitResolver {
    public static final String SOURCE_CONTAINER_POINT = "org.eclipse.m2m.qvt.oml.runtime.qvtTransformationContainer";
    public static final String SOURCE_CONTAINER = "sourceContainer";
    public static final String CONTAINER_PATH = "path";
    private final Bundle fBundle;
    private final List<IPath> fSrcContainers;
    private static final Map<String, Set<IPath>> ourPluginSourceContainers = PlatformPluginUnitResolver.loadPluginSourceContainers();

    public PlatformPluginUnitResolver(Bundle bundle) {
        this(bundle, PlatformPluginUnitResolver.getSourceContainers(bundle));
    }

    public PlatformPluginUnitResolver(Bundle bundle, IPath ... sourceContainers) {
        if (bundle == null) {
            throw new IllegalArgumentException("null bundle");
        }
        if (sourceContainers == null) {
            throw new IllegalArgumentException("null source containter");
        }
        List<IPath> containers = Arrays.asList(sourceContainers);
        if (containers.contains(null)) {
            throw new IllegalArgumentException("null source containter");
        }
        this.fBundle = bundle;
        this.fSrcContainers = new ArrayList<IPath>(containers);
    }

    public UnitProxy doResolveUnit(String qualifiedName) {
        Path unitNsRelativePath = new Path(ResolverUtils.toNamespaceRelativeUnitFilePath((String)qualifiedName));
        for (IPath nextContainer : this.fSrcContainers) {
            IPath unitBundleRelativePath = nextContainer.append((IPath)unitNsRelativePath);
            URL unitURL = this.fBundle.getEntry(unitBundleRelativePath.toString());
            if (unitURL == null) continue;
            IPath unitAbsolutePath = new Path(this.fBundle.getSymbolicName()).append(unitBundleRelativePath);
            URI unitURI = URI.createPlatformPluginURI((String)unitAbsolutePath.toString(), (boolean)false);
            String[] segments = ResolverUtils.getNameSegments((String)qualifiedName);
            String namespace = null;
            if (segments.length > 1) {
                namespace = ResolverUtils.toQualifiedName((String[])segments, (int)0, (int)(segments.length - 2));
            }
            String name = segments[segments.length - 1];
            return new BundleUnit(namespace, name, unitURI, unitURL);
        }
        return null;
    }

    public static void setupResolver(PlatformPluginUnitResolver resolver, boolean useBlackbox, boolean useDeployed) {
        BlackboxUnitResolver blackboxResolver = new BlackboxUnitResolver(URI.createPlatformPluginURI((String)resolver.fBundle.getSymbolicName(), (boolean)true));
        if (useBlackbox && !useDeployed) {
            resolver.setParent((UnitResolver)blackboxResolver);
        } else if (useBlackbox && useDeployed) {
            resolver.setParent((UnitResolver)new CompositeUnitResolver(new UnitResolver[]{DeployedImportResolver.INSTANCE, blackboxResolver}));
        }
    }

    private static Map<String, Set<IPath>> loadPluginSourceContainers() {
        HashMap<String, HashSet<Path>> sourceContainers = new HashMap<String, HashSet<Path>>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(SOURCE_CONTAINER_POINT);
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            if (SOURCE_CONTAINER.equals(element.getName())) {
                String namespace = element.getNamespaceIdentifier();
                String containerPath = element.getAttribute(CONTAINER_PATH);
                if (containerPath != null && containerPath.trim().length() != 0) {
                    HashSet<Path> containers = (HashSet<Path>)sourceContainers.get(namespace);
                    if (containers == null) {
                        containers = new HashSet<Path>();
                        sourceContainers.put(namespace, containers);
                    }
                    containers.add(new Path(containerPath));
                }
            }
            ++i;
        }
        return Collections.unmodifiableMap(sourceContainers);
    }

    static IPath[] getSourceContainers(Bundle bundle) {
        Set<IPath> containers = ourPluginSourceContainers.get(bundle.getSymbolicName());
        if (containers != null) {
            return containers.toArray(new IPath[containers.size()]);
        }
        return new IPath[]{Path.ROOT};
    }

    private final class BundleUnit
    extends UnitProxy {
        private final URL url;

        private BundleUnit(String namespace, String unitName, URI unitURI, URL unitURL) {
            super(namespace, unitName, unitURI);
            this.url = unitURL;
        }

        public int getContentType() {
            return 0;
        }

        public UnitContents getContents() throws IOException {
            return new UnitContents.CSTContents(){

                public Reader getContents() throws IOException {
                    URLConnection connection = BundleUnit.this.url.openConnection();
                    String charset = connection.getContentEncoding();
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    return new InputStreamReader(connection.getInputStream(), charset);
                }
            };
        }

        public UnitResolver getResolver() {
            return PlatformPluginUnitResolver.this;
        }
    }
}

