/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox.JdtModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox.ProjectClassLoader;
import org.eclipse.m2m.qvt.oml.blackbox.java.Module;

public class JdtBlackboxProvider
extends JavaBlackboxProvider {
    public static final String URI_BLACKBOX_JDT_QUERY = "jdt";
    private static Map<IProject, Map<String, JdtDescriptor>> descriptors = new HashMap<IProject, Map<String, JdtDescriptor>>();

    public Collection<? extends BlackboxUnitDescriptor> getUnitDescriptors(ResolutionContext resolutionContext) {
        IProject project = this.getProject(resolutionContext);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<BlackboxUnitDescriptor> descriptors = new ArrayList<BlackboxUnitDescriptor>();
        List<String> classes = this.getAllClasses(project, resolutionContext);
        for (String qualifiedName : classes) {
            BlackboxUnitDescriptor jdtUnitDescriptor = this.getJdtUnitDescriptor(project, qualifiedName);
            if (jdtUnitDescriptor == null) continue;
            descriptors.add(jdtUnitDescriptor);
        }
        return descriptors;
    }

    public BlackboxUnitDescriptor getUnitDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        IProject project = this.getProject(resolutionContext);
        if (project == null) {
            return null;
        }
        return this.getJdtUnitDescriptor(project, qualifiedName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlackboxUnitDescriptor getJdtUnitDescriptor(IProject project, String qualifiedName) {
        Map<String, JdtDescriptor> projectDescriptors = descriptors.get(project);
        if (projectDescriptors != null) {
            if (projectDescriptors.containsKey(qualifiedName)) {
                return (BlackboxUnitDescriptor)projectDescriptors.get(qualifiedName);
            }
        } else {
            projectDescriptors = new HashMap<String, JdtDescriptor>();
            descriptors.put(project, projectDescriptors);
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return null;
            }
        }
        catch (CoreException e) {
            return null;
        }
        final IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            ProjectClassLoader loader = ProjectClassLoader.getProjectClassLoader(javaProject);
            try {
                Class<?> moduleJavaClass = loader.loadClass(qualifiedName);
                JdtDescriptor descriptor = new JdtDescriptor(this, qualifiedName, moduleJavaClass){

                    @Override
                    protected String getUnitQuery() {
                        return "jdt=" + javaProject.getElementName();
                    }
                };
                projectDescriptors.put(qualifiedName, descriptor);
                return descriptor;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
        }
        catch (CoreException e2) {
            QvtPlugin.error((Throwable)e2);
            return null;
        }
        catch (MalformedURLException e3) {
            QvtPlugin.error((Throwable)e3);
        }
        return null;
    }

    private IProject getProject(ResolutionContext resolutionContext) {
        URI uri = resolutionContext.getURI();
        IResource resource = URIUtils.getResource((URI)(uri = JdtBlackboxProvider.reconvert(uri)));
        if (resource == null || !resource.exists()) {
            return null;
        }
        return resource.getProject();
    }

    private static SearchPattern createSearchPattern(ResolutionContext context) {
        if (context.getImports().isEmpty()) {
            return SearchPattern.createPattern((String)Module.class.getCanonicalName(), (int)8, (int)65536, (int)0);
        }
        SearchPattern pattern = null;
        for (String fqn : context.getImports()) {
            SearchPattern p = SearchPattern.createPattern((String)fqn, (int)5, (int)0, (int)0);
            pattern = pattern == null ? p : SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)p);
        }
        return pattern;
    }

    private List<String> getAllClasses(IProject project, ResolutionContext context) {
        final ArrayList<String> classes = new ArrayList<String>();
        try {
            SearchPattern searchPattern = JdtBlackboxProvider.createSearchPattern(context);
            SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JavaCore.create((IProject)project)}, (int)11);
            SearchRequestor searchRequestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) {
                    Object element = match.getElement();
                    if (element instanceof IType) {
                        String fqn = ((IType)element).getFullyQualifiedName();
                        classes.add(fqn);
                    }
                }
            };
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(searchPattern, searchParticipants, searchScope, searchRequestor, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return classes;
    }

    public void cleanup() {
        ProjectClassLoader.resetAllProjectClassLoaders();
        descriptors.clear();
    }

    @Deprecated
    public static void clearDescriptors(IProject project) {
        descriptors.remove(project);
    }

    static boolean requiresReset(IJavaProject javaProject) {
        return descriptors.containsKey(javaProject.getProject()) || ProjectClassLoader.isProjectClassLoaderExisting(javaProject);
    }

    static void reset(IJavaProject javaProject) {
        ProjectClassLoader.resetProjectClassLoader(javaProject);
        descriptors.remove(javaProject.getProject());
    }

    private static URI reconvert(URI uri) {
        String projectName;
        if (BlackboxUnitResolver.isBlackboxUnitURI((URI)uri) && (projectName = ResolverUtils.getQueryValue((URI)uri, (String)URI_BLACKBOX_JDT_QUERY)) != null) {
            return URI.createPlatformResourceURI((String)projectName, (boolean)true);
        }
        return uri;
    }

    private class JdtDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        private final Class<?> fModuleJavaClass;
        private volatile int hashCode;
        private EPackage.Registry fPackageRegistry;

        public JdtDescriptor(String unitQualifiedName, Class<?> moduleJavaClass) {
            super((JavaBlackboxProvider)JdtBlackboxProvider.this, unitQualifiedName);
            this.addModuleHandle(new JdtModuleHandle(moduleJavaClass.getSimpleName(), moduleJavaClass));
            this.fModuleJavaClass = moduleJavaClass;
        }

        protected String getUnitQuery() {
            return JdtBlackboxProvider.URI_BLACKBOX_JDT_QUERY;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JdtDescriptor)) {
                return false;
            }
            JdtDescriptor other = (JdtDescriptor)((Object)obj);
            return this.getQualifiedName().equals(other.getQualifiedName()) && this.fModuleJavaClass.equals(other.fModuleJavaClass);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                result = 17;
                result = 31 * result + this.getQualifiedName().hashCode();
                this.hashCode = result = 31 * result + this.fModuleJavaClass.hashCode();
            }
            return result;
        }

        public synchronized BlackboxUnit load(LoadContext context) throws BlackboxException {
            if (this.fPackageRegistry != context.getMetamodelRegistry()) {
                this.unload();
                this.fPackageRegistry = context.getMetamodelRegistry();
            }
            return super.load(context);
        }

        public URI reconvertURI() {
            return JdtBlackboxProvider.reconvert(this.getURI());
        }
    }
}

