/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.ConstantTargetCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.MultipleEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NavigableEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NonNullInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.SpeculationCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ComposedNode;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EnumLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ErrorNode;
import org.eclipse.qvtd.pivot.qvtschedule.InputNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NullLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.NumericLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.RecursionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.StringLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.TypeLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.UnknownNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CheckedConditionAnalysis {
    protected final @NonNull PartitionAnalysis partitionAnalysis;
    protected final @NonNull Partition partition;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ReachabilityForest reachabilityForest;
    private @Nullable Set<@NonNull PropertyDatum> allCheckedPropertyDatums;
    private final @NonNull List<@NonNull Edge> oldUnconditionalEdges = new ArrayList<Edge>();
    private final @Nullable List<@NonNull SuccessEdge> speculatedEdges;

    public CheckedConditionAnalysis(@NonNull MappingPartitionAnalysis<?> partitionAnalysis, @NonNull ScheduleManager scheduleManager) {
        this.partitionAnalysis = partitionAnalysis;
        this.partition = partitionAnalysis.getPartition();
        this.scheduleManager = scheduleManager;
        this.reachabilityForest = partitionAnalysis.getReachabilityForest();
        this.speculatedEdges = this.analyzeEdges();
    }

    private @Nullable List<@NonNull SuccessEdge> analyzeEdges() {
        ArrayList<@NonNull SuccessEdge> speculatedEdges = null;
        for (Edge edge : this.partition.getPartialEdges()) {
            Node targetNode;
            Role targetNodeRole;
            Node sourceNode;
            Role sourceNodeRole;
            Role edgeRole;
            if (edge.isConditional() || (edgeRole = this.partition.getRole(edge)) == null) continue;
            if (edgeRole.isSpeculated()) {
                if (speculatedEdges == null) {
                    speculatedEdges = new ArrayList<SuccessEdge>();
                }
                speculatedEdges.add((SuccessEdge)edge);
                continue;
            }
            if (!edgeRole.isOld() || edge.isConditional() || (sourceNodeRole = this.partition.getRole(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) == null || !sourceNodeRole.isOld() || (targetNodeRole = this.partition.getRole(targetNode = QVTscheduleUtil.getTargetNode((Edge)edge))) == null || !targetNodeRole.isOld()) continue;
            this.oldUnconditionalEdges.add(edge);
        }
        if (this.oldUnconditionalEdges.size() > 1) {
            Collections.sort(this.oldUnconditionalEdges, this.reachabilityForest.getEdgeCostComparator());
        }
        if (speculatedEdges != null && speculatedEdges.size() > 1) {
            Collections.sort(speculatedEdges, this.reachabilityForest.getEdgeCostComparator());
        }
        return speculatedEdges;
    }

    public @NonNull Set<@NonNull CheckedCondition> computeCheckedConditions() {
        HashSet<@NonNull CheckedCondition> checkedConditions = new HashSet<CheckedCondition>();
        Visitor visitor = new Visitor(checkedConditions);
        visitor.analyze();
        return checkedConditions;
    }

    public @NonNull Set<@NonNull PropertyDatum> computeCheckedPropertyDatums(@Nullable StringBuilder s) {
        if (this.allCheckedPropertyDatums != null) {
            return this.allCheckedPropertyDatums;
        }
        @NonNull ConnectionManager connectionManager = this.scheduleManager.getConnectionManager();
        HashSet<@NonNull PropertyDatum> allCheckedPropertyDatums = new HashSet<PropertyDatum>();
        for (Edge edge : this.partition.getPartialEdges()) {
            NavigationEdge oppositeEdge;
            NavigationEdge navigationEdge;
            if (!(edge instanceof NavigationEdge) || !this.partitionAnalysis.isChecked(edge) || !connectionManager.isHazardousRead(s, this.partition, navigationEdge = (NavigationEdge)edge)) continue;
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(navigationEdge);
            allCheckedPropertyDatums.add(propertyDatum);
            PropertyDatum oppositePropertyDatum = propertyDatum.getOpposite();
            if (oppositePropertyDatum != null || (oppositeEdge = navigationEdge.getOppositeEdge()) == null) continue;
            oppositePropertyDatum = this.scheduleManager.getPropertyDatum(oppositeEdge);
            allCheckedPropertyDatums.add(oppositePropertyDatum);
        }
        return allCheckedPropertyDatums;
    }

    public @NonNull Set<@NonNull PropertyDatum> getAllCheckedPropertyDatums() {
        return this.allCheckedPropertyDatums != null ? this.allCheckedPropertyDatums : this.computeCheckedPropertyDatums(null);
    }

    public @NonNull Iterable<@NonNull Edge> getOldUnconditionalEdges() {
        return this.oldUnconditionalEdges;
    }

    public @Nullable Iterable<@NonNull SuccessEdge> getSpeculatedEdges() {
        return this.speculatedEdges;
    }

    public String toString() {
        return this.partition.toString();
    }

    protected class Visitor
    extends AbstractExtendingQVTscheduleVisitor<Object, Set<CheckedCondition>> {
        private Set<@NonNull NavigableEdge> checkedNavigableEdges;
        protected final @NonNull CompleteModel completeModel;

        public Visitor(Set<CheckedCondition> checkedConditions) {
            super(checkedConditions);
            this.checkedNavigableEdges = null;
            this.completeModel = CheckedConditionAnalysis.this.scheduleManager.getEnvironmentFactory().getMetamodelManager().getCompleteModel();
        }

        public void analyze() {
            if (CheckedConditionAnalysis.this.speculatedEdges != null) {
                ((Set)this.context).add(new SpeculationCheckedCondition(CheckedConditionAnalysis.this.speculatedEdges));
            }
            for (Edge edge : CheckedConditionAnalysis.this.oldUnconditionalEdges) {
                edge.accept((org.eclipse.ocl.pivot.util.Visitor)this);
            }
            for (Node node : CheckedConditionAnalysis.this.partition.getPartialNodes()) {
                Role nodeRole = CheckedConditionAnalysis.this.partition.getRole(node);
                if (nodeRole == null || !nodeRole.isOld() || node.isConditional() || node.isDependency() || nodeRole == Role.CONSTANT_SUCCESS_TRUE) continue;
                node.accept((org.eclipse.ocl.pivot.util.Visitor)this);
            }
        }

        public @Nullable Element visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public Object visitBooleanLiteralNode(@NonNull BooleanLiteralNode object) {
            return null;
        }

        public Object visitCastEdge(@NonNull CastEdge castEdge) {
            return this.visiting((Visitable)castEdge);
        }

        public Object visitComposedNode(@NonNull ComposedNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitDependencyNode(@NonNull DependencyNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitEdge(@NonNull Edge edge) {
            return null;
        }

        public Object visitEnumLiteralNode(@NonNull EnumLiteralNode object) {
            return null;
        }

        public Object visitErrorNode(@NonNull ErrorNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitInputNode(@NonNull InputNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitNavigationEdge(@NonNull NavigationEdge navigationEdge) {
            ClassDatum targetNodeClassDatum;
            Role sourceNodeRole1 = CheckedConditionAnalysis.this.partition.getRole(QVTscheduleUtil.getSourceNode((Edge)navigationEdge));
            assert (sourceNodeRole1 != null);
            Role targetNodeRole1 = CheckedConditionAnalysis.this.partition.getRole(QVTscheduleUtil.getTargetNode((Edge)navigationEdge));
            assert (targetNodeRole1 != null);
            if (targetNodeRole1.isConstant() && !sourceNodeRole1.isNew()) {
                ((Set)this.context).add(new ConstantTargetCheckedCondition(navigationEdge));
                return null;
            }
            Role navigableEdgeRole = CheckedConditionAnalysis.this.partition.getRole((Edge)navigationEdge);
            assert (navigableEdgeRole != null);
            if (navigationEdge.isRealized() && !navigableEdgeRole.isRealized()) {
                return null;
            }
            NavigationEdge primaryEdge = QVTscheduleUtil.getPrimaryEdge((NavigationEdge)navigationEdge);
            NavigationEdge oppositeEdge = primaryEdge.getOppositeEdge();
            if (oppositeEdge != null) {
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)primaryEdge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)primaryEdge);
                Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode);
                Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
                if (targetCost > 0 && targetCost < sourceCost) {
                    primaryEdge = oppositeEdge;
                }
            }
            Set<@NonNull PropertyDatum> allCheckedPropertyDatums2 = CheckedConditionAnalysis.this.getAllCheckedPropertyDatums();
            for (PropertyDatum checkedPropertyDatum : CheckedConditionAnalysis.this.scheduleManager.getPropertyDatums(primaryEdge)) {
                if (!allCheckedPropertyDatums2.contains(checkedPropertyDatum)) continue;
                if (this.checkedNavigableEdges == null) {
                    this.checkedNavigableEdges = new HashSet<NavigableEdge>();
                }
                if (!this.checkedNavigableEdges.add((NavigableEdge)primaryEdge)) continue;
                ((Set)this.context).add(new NavigableEdgeCheckedCondition((NavigableEdge)primaryEdge));
            }
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)navigationEdge);
            if (navigableEdgeRole.isPredicated() && targetNode.isConstant()) {
                ((Set)this.context).add(new ConstantTargetCheckedCondition(navigationEdge));
            }
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
            CompleteClass edgeTargetCompleteClass = this.completeModel.getCompleteClass(QVTrelationUtil.getType((TypedElement)property));
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)navigationEdge);
            Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode);
            Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
            if (sourceCost < targetCost && !QVTscheduleUtil.conformsTo((CompleteClass)edgeTargetCompleteClass, (ClassDatum)(targetNodeClassDatum = QVTscheduleUtil.getClassDatum((Node)targetNode)))) {
                ((Set)this.context).add(new CastEdgeCheckedCondition((NavigableEdge)navigationEdge));
            }
            return null;
        }

        public Object visitNode(@NonNull Node targetNode) {
            Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
            Edge firstEdge = null;
            MultipleEdgeCheckedCondition checkedCondition = null;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                Node sourceNode;
                Integer sourceCost;
                Role edgeRole = CheckedConditionAnalysis.this.partition.getRole(edge);
                if (edgeRole == null || !edgeRole.isOld() || edge.isExpression() || (sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) > targetCost) continue;
                if (firstEdge == null) {
                    firstEdge = edge;
                    continue;
                }
                if (checkedCondition == null) {
                    checkedCondition = new MultipleEdgeCheckedCondition(targetNode, firstEdge, edge);
                    ((Set)this.context).add(checkedCondition);
                    continue;
                }
                checkedCondition.addEdge(edge);
            }
            return null;
        }

        public Object visitNullLiteralNode(@NonNull NullLiteralNode object) {
            return null;
        }

        public Object visitNumericLiteralNode(@NonNull NumericLiteralNode object) {
            return null;
        }

        public Object visitOperationNode(@NonNull OperationNode operationNode) {
            Element originatingElement = operationNode.basicGetOriginatingElement();
            if (originatingElement instanceof TypedElement) {
                ClassDatum targetClassDatum;
                Type initializerType;
                CompleteClass initializerCompleteClass;
                TypedElement typedElement = (TypedElement)originatingElement;
                if (operationNode.isRequired() && !typedElement.isIsRequired()) {
                    ((Set)this.context).add(new NonNullInitializerCheckedCondition(operationNode));
                }
                if (!QVTscheduleUtil.conformsTo((CompleteClass)(initializerCompleteClass = this.completeModel.getCompleteClass(initializerType = QVTbaseUtil.getType((TypedElement)typedElement))), (ClassDatum)(targetClassDatum = QVTscheduleUtil.getClassDatum((Node)operationNode)))) {
                    ((Set)this.context).add(new CastInitializerCheckedCondition(operationNode));
                }
            }
            return super.visitOperationNode(operationNode);
        }

        public Object visitPredicateEdge(@NonNull PredicateEdge predicateEdge) {
            ((Set)this.context).add(new PredicateEdgeCheckedCondition(predicateEdge));
            return null;
        }

        public Object visitRecursionEdge(@NonNull RecursionEdge object) {
            return this.visiting((Visitable)object);
        }

        public Object visitStringLiteralNode(@NonNull StringLiteralNode object) {
            return null;
        }

        public Object visitSuccessEdge(@NonNull SuccessEdge successEdge) {
            Role role = CheckedConditionAnalysis.this.partition.getRole((Edge)successEdge);
            assert (role != null);
            if (role.isSpeculated()) {
                assert (CheckedConditionAnalysis.this.speculatedEdges != null && CheckedConditionAnalysis.this.speculatedEdges.contains(successEdge));
                return null;
            }
            Role sourceNodeRole = CheckedConditionAnalysis.this.partition.getRole(QVTscheduleUtil.getSourceNode((Edge)successEdge));
            assert (sourceNodeRole != null);
            assert (!sourceNodeRole.isNew());
            Role targetNodeRole = CheckedConditionAnalysis.this.partition.getRole(QVTscheduleUtil.getTargetNode((Edge)successEdge));
            assert (targetNodeRole != null);
            assert (targetNodeRole.isConstant());
            RuleRegion ruleRegion = (RuleRegion)CheckedConditionAnalysis.this.partitionAnalysis.getRegion();
            Rule rule = QVTscheduleUtil.getReferredRule((RuleRegion)ruleRegion);
            AbstractTransformationAnalysis transformationAnalysis = CheckedConditionAnalysis.this.partitionAnalysis.getPartitionedTransformationAnalysis().getTransformationAnalysis();
            RuleAnalysis ruleAnalysis = transformationAnalysis.getRuleAnalysis(rule);
            Rule2TraceGroup rule2TraceGroup = ruleAnalysis.getRule2TraceGroup();
            boolean isLocalSuccess = false;
            Element2MiddleProperty basicGetRelation2LocalSuccessProperty = rule2TraceGroup.basicGetRelation2LocalSuccessProperty();
            if (basicGetRelation2LocalSuccessProperty != null) {
                Property localSuccessProperty = basicGetRelation2LocalSuccessProperty.getTraceProperty();
                isLocalSuccess = successEdge.getReferredProperty() == localSuccessProperty;
            }
            ((Set)this.context).add(new ConstantTargetCheckedCondition(successEdge, isLocalSuccess));
            return null;
        }

        public Object visitTypeLiteralNode(@NonNull TypeLiteralNode object) {
            return null;
        }

        public Object visitUnknownNode(@NonNull UnknownNode object) {
            return this.visiting((Visitable)object);
        }
    }
}

