/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTiModelManager
implements DomainModelManager {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private Map<TypedModel, Resource> modelResourceMap = new HashMap<TypedModel, Resource>();
    @NonNull
    private Map<TypedModel, EList<EObject>> modelElementsMap = new HashMap<TypedModel, EList<EObject>>();
    @NonNull
    private Set<Type> allInstancesTypes;
    @NonNull
    private Map<?, ?>[] middleOpposites;

    public QVTiModelManager(@NonNull QVTiTransformationAnalysis transformationAnalysis) {
        this.metaModelManager = transformationAnalysis.getMetaModelManager();
        this.allInstancesTypes = transformationAnalysis.getAllInstancesTypes();
        int cacheIndexes = transformationAnalysis.getCacheIndexes();
        this.middleOpposites = new Map[cacheIndexes];
        int i = 0;
        while (i < cacheIndexes) {
            this.middleOpposites[i] = new HashMap();
            ++i;
        }
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource model) {
        this.modelResourceMap.put(typedModel, model);
    }

    public void addModelElement(@NonNull TypedModel model, @NonNull Object element) {
        BasicEList elements = null;
        elements = this.modelElementsMap.containsKey(model) ? this.modelElementsMap.get(model) : new BasicEList((Collection)this.modelResourceMap.get(model).getContents());
        elements.add((Object)((EObject)element));
        this.modelElementsMap.put(model, (EList<EObject>)elements);
    }

    public void dispose() {
        this.modelElementsMap.clear();
        this.modelResourceMap.clear();
        this.allInstancesTypes.clear();
        Map<?, ?>[] mapArray = this.middleOpposites;
        int n = this.middleOpposites.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> middleOpposite = mapArray[n2];
            middleOpposite.clear();
            ++n2;
        }
    }

    @NonNull
    public Set<EObject> get(@NonNull DomainType type) {
        throw new UnsupportedOperationException();
    }

    public Resource getModel(@NonNull TypedModel typedModel) {
        return this.modelResourceMap.get(typedModel);
    }

    public Collection<Resource> getAllModelResources() {
        return this.modelResourceMap.values();
    }

    public List<Object> getElementsByType(@Nullable TypedModel model, @NonNull Type type) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.modelElementsMap.containsKey(model)) {
            for (EObject root : this.modelElementsMap.get(model)) {
                if (root == null) continue;
                if (this.isInstance((DomainType)type, root)) {
                    elements.add(root);
                }
                TreeIterator contents = root.eAllContents();
                while (contents.hasNext()) {
                    EObject element = (EObject)contents.next();
                    if (element == null || !this.isInstance((DomainType)type, element)) continue;
                    elements.add(element);
                }
            }
        } else {
            TreeIterator contents = this.modelResourceMap.get(model).getAllContents();
            while (contents.hasNext()) {
                EObject element = (EObject)contents.next();
                if (element == null || !this.isInstance((DomainType)type, element)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public Object getMiddleOpposite(@NonNull Integer cacheIndex, @NonNull Object outerObject) {
        return this.middleOpposites[cacheIndex].get(outerObject);
    }

    protected boolean isInstance(@NonNull DomainType requiredType, @NonNull EObject eObject) {
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        Type objectType = null;
        if (ePackage == PivotPackage.eINSTANCE) {
            String name = (String)DomainUtil.nonNullEMF((Object)eClass.getName());
            objectType = this.metaModelManager.getPivotType(name);
        } else {
            try {
                objectType = (Type)this.metaModelManager.getPivotOf(Type.class, (EObject)eClass);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return objectType != null && objectType.conformsTo((DomainStandardLibrary)this.metaModelManager, requiredType);
    }

    public List<EObject> getTypeModelEObjectList(TypedModel model) {
        if (this.modelElementsMap.containsKey(model)) {
            return (List)this.modelElementsMap.get(model);
        }
        return new ArrayList<EObject>();
    }

    public void saveModels() {
        TypedModel key;
        Resource model;
        for (Map.Entry<TypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            model = entry.getValue();
            key = entry.getKey();
            if (!this.modelElementsMap.containsKey(key)) continue;
            for (EObject e : this.modelElementsMap.get(key)) {
                if (e.eContainer() != null) continue;
                model.getContents().add((Object)e);
            }
        }
        for (Map.Entry<TypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            model = entry.getValue();
            key = entry.getKey();
            if (!this.modelElementsMap.containsKey(key)) continue;
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("SCHEMA_LOCATION", Boolean.TRUE);
                model.save(options);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveMiddleModel(@NonNull URI uri) {
    }

    public void setMiddleOpposite(@NonNull Integer cacheIndex, @NonNull Object middleObject, Object outerObject) {
        this.middleOpposites[cacheIndex].put(outerObject, middleObject);
    }
}

