/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.environment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.InvalidLiteralExp;
import org.eclipse.qvt.declarative.parser.environment.CSTEnvironment;
import org.eclipse.qvt.declarative.parser.environment.CSTFormattingHelper;
import org.eclipse.qvt.declarative.parser.environment.ICSTEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTNodeEnvironment;
import org.eclipse.qvt.declarative.parser.environment.IHasName;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTNodeEnvironment<E extends ICSTEnvironment, AST extends Notifier, CST extends CSTNode>
extends CSTEnvironment<E>
implements ICSTNodeEnvironment,
Adapter {
    protected AST ast;
    protected CST cst;

    public static <E extends ICSTEnvironment> E getEnvironmentFromAST(Notifier ast, Class<E> envClass) {
        if (ast != null) {
            ICSTEnvironment adapter = (ICSTEnvironment)EcoreUtil.getAdapter((List)ast.eAdapters(), envClass);
            return (E)adapter;
        }
        return null;
    }

    public static <E extends ICSTEnvironment> E getEnvironmentFromCST(CSTNode cst, Class<E> envClass) {
        Object ast = cst.getAst();
        if (ast instanceof Notifier) {
            ICSTEnvironment adapter = (ICSTEnvironment)EcoreUtil.getAdapter((List)((Notifier)ast).eAdapters(), envClass);
            return (E)adapter;
        }
        return null;
    }

    public static void setNameFromIdentifier(ENamedElement astNode, IdentifierCS identifier) {
        if (identifier != null) {
            astNode.setName(identifier.getValue());
            identifier.setAst(astNode);
        }
    }

    protected CSTNodeEnvironment(ICSTEnvironment parent, AST astNode, CST cstNode) {
        super(parent);
        assert (cstNode != null);
        this.ast = astNode;
        this.cst = cstNode;
        if (astNode != null) {
            this.internalSetAdapter();
        }
    }

    @Override
    public InvalidLiteralExp createInvalidLiteralExp(CSTNode cstNode) {
        InvalidLiteralExp invalidLiteralExp = EcoreFactory.eINSTANCE.createInvalidLiteralExp();
        this.initASTMapping(invalidLiteralExp, cstNode);
        return invalidLiteralExp;
    }

    @Override
    public String formatLookupException(LookupException e) {
        List matches = e.getAmbiguousMatches();
        ArrayList<String> matchNames = new ArrayList<String>();
        for (Object match : matches) {
            matchNames.add(this.formatQualifiedName(match));
        }
        Collections.sort(matchNames);
        StringBuilder s = new StringBuilder();
        s.append(e.getMessage());
        String separator = " { ";
        for (String matchName : matchNames) {
            s.append(separator);
            s.append(matchName);
            separator = ", ";
        }
        s.append(" }");
        return s.toString();
    }

    public String formatName(Object object) {
        return this.getFormatter().formatName(object);
    }

    public String formatPath(List<String> names) {
        return this.getFormatter().formatPath(names);
    }

    @Deprecated
    public String formatPathName(Object object) {
        return this.formatQualifiedName(object);
    }

    public String formatQualifiedName(Object object) {
        return this.getFormatter().formatQualifiedName(object);
    }

    public String formatString(String string) {
        return this.getFormatter().formatString(string);
    }

    public String formatType(Object type) {
        return this.getFormatter().formatType(type);
    }

    public AST getASTNode() {
        return this.ast;
    }

    public CST getCSTNode() {
        return this.cst;
    }

    @Override
    public abstract CSTFormattingHelper getFormatter();

    public Notifier getTarget() {
        return this.ast;
    }

    protected void internalSetAST(AST astNode) {
        assert (this.ast == null);
        assert (astNode != null);
        this.ast = astNode;
    }

    protected void internalSetAdapter() {
        this.ast.eAdapters().add((Object)this);
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(this.getClass());
    }

    public void notifyChanged(Notification notification) {
    }

    @Override
    @Deprecated
    public CSTNode setCSTNode(CSTNode cstNode) {
        CST oldCSTNode = this.cst;
        this.cst = cstNode;
        return oldCSTNode;
    }

    public final void setTarget(Notifier newTarget) {
        if (newTarget != this.ast) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".setTarget");
        }
    }

    public String toString() {
        String parentString = this.getInternalParent() != null ? String.valueOf(this.getInternalParent().toString()) + "." : "";
        CST cstNode = this.getCSTNode();
        String childString = cstNode instanceof IHasName ? ((IHasName)cstNode).getName() : this.getClass().getSimpleName();
        return String.valueOf(parentString) + childString;
    }
}

