/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.environment;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import lpg.lpgjavaruntime.Monitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.qvt.declarative.ecore.utils.XMIUtils;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractModelResolver;
import org.eclipse.qvt.declarative.parser.environment.CSTEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileAnalyzer;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTNodeEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTRootEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.LPGProgressMonitor;
import org.eclipse.qvt.declarative.parser.utils.CSTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTFileEnvironment<R extends ICSTRootEnvironment, E extends ICSTNodeEnvironment, CST extends CSTNode>
extends CSTEnvironment<E>
implements ICSTFileEnvironment {
    protected final EPackage.Registry registryToo;
    protected final XMIResource ast;
    protected final AbstractModelResolver resolver;

    private CSTFileEnvironment(EPackage.Registry registry, AbstractFileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        super(registry, (Resource)astResource);
        this.ast = astResource;
        this.registryToo = registry;
        if (file != null) {
            this.resolver = new AbstractModelResolver(file);
            this.resolver.setResourceSet(resourceSet);
        } else {
            this.resolver = null;
        }
    }

    protected CSTFileEnvironment(AbstractFileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        this((EPackage.Registry)new EPackageRegistryImpl(), file, resourceSet, astResource);
    }

    public abstract ICSTFileAnalyzer<R> createAnalyzer(Monitor var1);

    protected abstract R createRootEnvironment(XMIResource var1, CST var2);

    @Override
    public XMIResource getASTResource() {
        return this.ast;
    }

    protected abstract String getContentTypeIdentifier();

    @Override
    public AbstractFileHandle getFile() {
        return this.getResolver().getHandle();
    }

    @Override
    public ICSTFileEnvironment getFileEnvironment() {
        return this;
    }

    @Override
    public EPackage.Registry getRegistry() {
        return this.registryToo;
    }

    @Override
    public AbstractModelResolver getResolver() {
        return this.resolver;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resolver.getResourceSet();
    }

    @Override
    public void initializePackageNs(EPackage ePackage) {
        ePackage.setNsPrefix(ePackage.getName());
        ePackage.setNsURI(CSTUtils.computePackageNs(this.resolver.getHandle(), ePackage));
    }

    @Override
    public ICSTRootEnvironment parse(Reader reader, AbstractFileHandle file, IProgressMonitor monitor) throws IOException, CoreException {
        LPGProgressMonitor lpgMonitor = new LPGProgressMonitor(monitor);
        ICSTFileAnalyzer<R> analyzer = this.createAnalyzer(lpgMonitor);
        analyzer.setFileName(file.getName());
        if (reader == null) {
            reader = new InputStreamReader(file.getContents());
        } else if (!file.exists()) {
            return null;
        }
        analyzer.initialize(reader);
        AbstractParser parser = this.getParser();
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        parser.getLexer().lexToTokens(parser);
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        CSTNode cst = parser.parseTokensToCST();
        if (cst == null) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        R rootEnvironment = this.createRootEnvironment(this.ast, cst);
        if (!analyzer.analyze(rootEnvironment)) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        this.postParse(rootEnvironment);
        return rootEnvironment;
    }

    protected void postParse(R rootEnvironment) {
        rootEnvironment.postParse();
        XMIUtils.assignLinearIds((Resource)this.ast, (String)"ast");
    }
}

