/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.builder.ProjectNatureBase;
import org.eclipse.imp.runtime.IPluginLog;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;

public abstract class CommonNature
extends ProjectNatureBase {
    protected final ICreationFactory creationFactory;

    protected CommonNature(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
    }

    public void addToProject(IProject project) {
        super.addToProject(project);
    }

    public void deconfigure() throws CoreException {
        try {
            this.getProject().deleteMarkers(this.creationFactory.getProblemMarkerId(), false, 2);
        }
        catch (CoreException coreException) {}
        super.deconfigure();
    }

    public String getBuilderID() {
        return this.creationFactory.getBuilderId();
    }

    public String getLanguageName() {
        return this.creationFactory.getLanguageName();
    }

    public IPluginLog getLog() {
        return this.creationFactory.getPlugin();
    }

    public String getNatureID() {
        return this.creationFactory.getNatureId();
    }

    protected void refreshPrefs() {
    }

    public boolean removeFromProject(IProject project) throws CoreException {
        String natureId = this.getNatureID();
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natureId.equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return true;
            }
            ++i;
        }
        return false;
    }
}

