/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.projection.AnnotationBag;

public class AnnotationHoverBase
implements IAnnotationHover,
ILanguageService {
    private static Set<String> sAnnotationTypesToFilter = new HashSet<String>();

    static {
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffUnchanged");
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffChange");
        sAnnotationTypesToFilter.add("org.eclipse.debug.core.breakpoint");
        sAnnotationTypesToFilter.add("org.eclipse.imp.runtime.occurrenceAnnotation");
        sAnnotationTypesToFilter.add("org.eclipse.projection");
    }

    protected static boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected static IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    public static List getSourceAnnotationsForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = AnnotationHoverBase.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        ArrayList<Annotation> srcAnnotations = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation2 = (Annotation)iterator.next();
            Position position = model.getPosition(annotation2);
            if (position == null || !AnnotationHoverBase.isRulerLine(position, document, line)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !AnnotationHoverBase.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
                    srcAnnotations.add(annotation2);
                }
                continue;
            }
            if (!AnnotationHoverBase.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
            srcAnnotations.add(annotation2);
        }
        return srcAnnotations;
    }

    private static boolean includeAnnotation(Annotation annotation, Position position, HashMap messagesAtPosition) {
        String type = annotation.getType();
        return !sAnnotationTypesToFilter.contains(type);
    }

    public static String formatAnnotationList(List javaAnnotations) {
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                Annotation annotation = (Annotation)javaAnnotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return AnnotationHoverBase.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (Annotation annotation : javaAnnotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return AnnotationHoverBase.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return AnnotationHoverBase.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    public static String formatSingleMessage(String message) {
        return message;
    }

    public static String formatMultipleMessages(List messages) {
        StringBuffer buff = new StringBuffer();
        buff.append("Multiple messages:\n");
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            String msg = (String)iter.next();
            buff.append("  ");
            buff.append(msg);
            if (!iter.hasNext()) continue;
            buff.append('\n');
        }
        return buff.toString();
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List javaAnnotations = AnnotationHoverBase.getSourceAnnotationsForLine(sourceViewer, lineNumber);
        return AnnotationHoverBase.formatAnnotationList(javaAnnotations);
    }
}

