/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.builder.DependencyInfo;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.utils.UnimplementedError;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuilderBase
extends IncrementalProjectBuilder {
    private final ResourceVisitor fResourceVisitor = new ResourceVisitor();
    private final DeltaVisitor fDeltaVisitor = new DeltaVisitor();
    protected DependencyInfo fDependencyInfo;
    private final Collection<IFile> fSourcesToCompile = new ArrayList<IFile>();

    protected abstract PluginBase getPlugin();

    public String getBuilderID() {
        throw new UnimplementedError("Not implemented for builder for plug-in " + this.getPlugin().getID());
    }

    protected abstract boolean isSourceFile(IFile var1);

    protected abstract boolean isNonRootSourceFile(IFile var1);

    protected abstract boolean isOutputFolder(IResource var1);

    protected abstract void compile(IFile var1, IProgressMonitor var2);

    protected abstract void collectDependencies(IFile var1);

    protected abstract String getErrorMarkerID();

    protected abstract String getWarningMarkerID();

    protected abstract String getInfoMarkerID();

    private boolean processResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (file.exists() && (this.isSourceFile(file) || this.isNonRootSourceFile(file))) {
                this.fSourcesToCompile.add(file);
            }
            return false;
        }
        return !this.isOutputFolder(resource);
    }

    protected DependencyInfo createDependencyInfo(IProject project) {
        return new DependencyInfo(project);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        if (this.fDependencyInfo == null || kind == 6 || kind == 15) {
            this.fDependencyInfo = this.createDependencyInfo(this.getProject());
        }
        try {
            this.fSourcesToCompile.clear();
            this.collectSourcesToCompile(monitor);
            this.clearDependencyInfoForChangedFiles();
            this.compileNecessarySources(monitor);
            this.fDependencyInfo.dump();
        }
        catch (CoreException e) {
            this.getPlugin().writeErrorMsg("Build failed: " + e.getMessage());
        }
        return new IProject[0];
    }

    protected void compileNecessarySources(IProgressMonitor monitor) {
        for (IFile srcFile : this.fSourcesToCompile) {
            this.clearMarkersOn(srcFile);
            if (this.isSourceFile(srcFile)) {
                this.compile(srcFile, monitor);
                continue;
            }
            if (!this.isNonRootSourceFile(srcFile)) continue;
            this.collectDependencies(srcFile);
        }
    }

    protected void clearMarkersOn(IFile file) {
        try {
            file.deleteMarkers(this.getErrorMarkerID(), true, 2);
            file.deleteMarkers(this.getWarningMarkerID(), true, 2);
            file.deleteMarkers(this.getInfoMarkerID(), true, 2);
        }
        catch (CoreException coreException) {}
    }

    private void dumpSourceList(Collection<IFile> sourcesToCompile) {
        for (IFile srcFile : sourcesToCompile) {
            System.out.println("  " + srcFile.getFullPath());
        }
    }

    private void clearDependencyInfoForChangedFiles() {
        for (IFile srcFile : this.fSourcesToCompile) {
            this.fDependencyInfo.clearDependenciesOf(srcFile.getFullPath().toString());
        }
    }

    private void collectSourcesToCompile(IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta != null) {
            this.getPlugin().maybeWriteInfoMsg("==> Scanning resource delta for project '" + this.getProject().getName() + "'... <==");
            delta.accept((IResourceDeltaVisitor)this.fDeltaVisitor);
            this.getPlugin().maybeWriteInfoMsg("Delta scan completed for project '" + this.getProject().getName() + "'...");
        } else {
            this.getPlugin().maybeWriteInfoMsg("==> Scanning for source files in project '" + this.getProject().getName() + "'... <==");
            this.getProject().accept((IResourceVisitor)this.fResourceVisitor);
            this.getPlugin().maybeWriteInfoMsg("Source file scan completed for project '" + this.getProject().getName() + "'...");
        }
        this.collectChangeDependents();
    }

    private void collectChangeDependents() {
        ArrayList<IFile> changeDependents = new ArrayList<IFile>();
        this.scanSourceList(this.fSourcesToCompile, changeDependents);
        this.fSourcesToCompile.addAll(changeDependents);
    }

    private void scanSourceList(Collection<IFile> srcList, Collection<IFile> changeDependents) {
        for (IFile srcFile : srcList) {
            Set fileDependents = this.fDependencyInfo.getDependentsOf(srcFile.getFullPath().toString());
            if (fileDependents == null) continue;
            for (String depPath : fileDependents) {
                IFile depFile = this.getProject().getWorkspace().getRoot().getFile((IPath)new Path(depPath));
                changeDependents.add(depFile);
            }
        }
    }

    protected void doRefresh(final IResource resource) {
        new Thread(){

            public void run() {
                try {
                    resource.getProject().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected String getMarkerIDFor(int severity) {
        switch (severity) {
            case 2: {
                return this.getErrorMarkerID();
            }
            case 1: {
                return this.getWarningMarkerID();
            }
            case 0: {
                return this.getInfoMarkerID();
            }
        }
        return this.getInfoMarkerID();
    }

    protected void createMarker(IResource errorResource, int startLine, int charStart, int charEnd, String message, int severity) {
        try {
            if (!errorResource.exists()) {
                return;
            }
            IMarker m = errorResource.createMarker(this.getMarkerIDFor(severity));
            String[] attributeNames = new String[]{"lineNumber", "message", "priority", "severity"};
            Object[] values = new Object[]{startLine, message, 2, 2};
            m.setAttributes(attributeNames, values);
            if (charStart >= 0 && charEnd >= 0) {
                attributeNames = new String[]{"charStart", "charEnd"};
                values = new Object[]{charStart, charEnd};
                m.setAttributes(attributeNames, values);
            } else if (charStart >= 0) {
                m.setAttribute("charStart", charStart);
            } else if (charEnd >= 0) {
                m.setAttribute("charEnd", charEnd);
            }
        }
        catch (CoreException e) {
            this.getPlugin().writeErrorMsg("Unable to create marker: " + e.getMessage());
        }
    }

    protected void postMsgDialog(final String title, final String msg) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            }
        });
    }

    protected void postQuestionDialog(final String title, final String query, final Runnable runIfYes, final Runnable runIfNo) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
                boolean response = MessageDialog.openQuestion((Shell)shell, (String)title, (String)query);
                if (response) {
                    runIfYes.run();
                } else if (runIfNo != null) {
                    runIfNo.run();
                }
            }
        });
    }

    protected MessageConsole findConsole(String consoleName) {
        MessageConsole myConsole = null;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console.getName().equals(consoleName)) {
                myConsole = (MessageConsole)console;
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(consoleName, null);
            consoleManager.addConsoles(new IConsole[]{myConsole});
        }
        consoleManager.showConsoleView(myConsole);
        return myConsole;
    }

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return BuilderBase.this.processResource(delta.getResource());
        }
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private ResourceVisitor() {
        }

        public boolean visit(IResource res) throws CoreException {
            return BuilderBase.this.processResource(res);
        }
    }
}

