/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.HashedMapCollectionExtractorBase;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.MessageUtil;

public class HashMapCollectionExtractor
extends HashedMapCollectionExtractorBase {
    protected final String sizeField;

    public HashMapCollectionExtractor(String sizeField, String arrayField, String keyField, String valueField) {
        super(arrayField, keyField, valueField);
        this.sizeField = sizeField;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        return null;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        ArrayInt entries = new ArrayInt();
        IObjectArray table = this.getBackingArray(coll);
        if (table != null) {
            long[] addresses = table.getReferenceArray();
            int i = 0;
            while (i < addresses.length) {
                if (addresses[i] != 0L) {
                    int id = snapshot.mapAddressToId(addresses[i]);
                    this.collectEntriesFromTable(entries, coll.getObjectId(), id, snapshot);
                }
                ++i;
            }
        }
        return entries.toArray();
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        IObjectArray table = this.getBackingArray(coll);
        if (table != null) {
            return table.getLength();
        }
        return null;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        Integer value = ExtractionUtils.toInteger(coll.resolveValue(this.sizeField));
        if (value != null) {
            return ((Number)value).intValue();
        }
        if (this.hasExtractableContents()) {
            return this.getMapSize(coll, this.extractEntryIds(coll));
        }
        IObject header = ExtractionUtils.followOnlyOutgoingReferencesExceptLast(this.arrayField, coll);
        if (header != null) {
            ISnapshot snapshot = coll.getSnapshot();
            return this.getMapSize(coll, snapshot.getOutboundReferentIds(header.getObjectId()));
        }
        return null;
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        IObjectArray arrayObject = this.extractBackingArray(collection);
        if (arrayObject == null) {
            return 0;
        }
        return ExtractionUtils.getNumberOfNotNullArrayElements(arrayObject);
    }

    public IObjectArray getBackingArray(IObject coll) throws SnapshotException {
        if (this.arrayField == null) {
            return null;
        }
        Object obj = coll.resolveValue(this.arrayField);
        IObjectArray ret = null;
        if (obj instanceof IObjectArray) {
            ret = (IObjectArray)obj;
            return ret;
        }
        if (obj instanceof IObject) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), ((IObject)obj).getTechnicalName()});
            throw new SnapshotException(msg);
        }
        if (obj != null) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), obj.toString()});
            throw new SnapshotException(msg);
        }
        IObject next = ExtractionUtils.followOnlyOutgoingReferencesExceptLast(this.arrayField, coll);
        if (next == null) {
            return null;
        }
        ISnapshot snapshot = next.getSnapshot();
        int[] nArray = snapshot.getOutboundReferentIds(next.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IObjectArray) {
                if (ret != null) {
                    return null;
                }
                ret = (IObjectArray)o;
            }
            ++n2;
        }
        return ret;
    }
}

