/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.json4j;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.lyo.oslc4j.core.NestedWildcardProperties;
import org.eclipse.lyo.oslc4j.core.OSLC4JConstants;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.OslcGlobalNamespaceProvider;
import org.eclipse.lyo.oslc4j.core.SingletonWildcardProperties;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespaceDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRdfCollectionType;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcSchema;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyTypeException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingNamespaceDeclarationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingNamespacePrefixException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingSetMethodException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreRelativeURIException;
import org.eclipse.lyo.oslc4j.core.model.AnyResource;
import org.eclipse.lyo.oslc4j.core.model.IExtendedResource;
import org.eclipse.lyo.oslc4j.core.model.IOslcCustomNamespaceProvider;
import org.eclipse.lyo.oslc4j.core.model.IReifiedResource;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.core.model.InheritedMethodAnnotationHelper;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import org.eclipse.lyo.oslc4j.core.model.TypeFactory;
import org.eclipse.lyo.oslc4j.core.model.XMLLiteral;

@Deprecated
public final class JsonHelper {
    private static final String JSON_PROPERTY_DELIMITER = ":";
    private static final String JSON_PROPERTY_PREFIXES = "prefixes";
    private static final String JSON_PROPERTY_SUFFIX_ABOUT = "about";
    private static final String JSON_PROPERTY_SUFFIX_MEMBER = "member";
    private static final String JSON_PROPERTY_SUFFIX_RESOURCE = "resource";
    private static final String JSON_PROPERTY_SUFFIX_RESPONSE_INFO = "responseInfo";
    private static final String JSON_PROPERTY_SUFFIX_RESULTS = "results";
    private static final String JSON_PROPERTY_SUFFIX_TOTAL_COUNT = "totalCount";
    private static final String JSON_PROPERTY_SUFFIX_NEXT_PAGE = "nextPage";
    private static final String JSON_PROPERTY_SUFFIX_TYPE = "type";
    private static final String JSON_PROPERTY_SUFFIX_FIRST = "first";
    private static final String JSON_PROPERTY_SUFFIX_REST = "rest";
    private static final String JSON_PROPERTY_SUFFIX_NIL = "nil";
    private static final String JSON_PROPERTY_SUFFIX_LIST = "List";
    private static final String JSON_PROPERTY_SUFFIX_ALT = "Alt";
    private static final String JSON_PROPERTY_SUFFIX_BAG = "Bag";
    private static final String JSON_PROPERTY_SUFFIX_SEQ = "Seq";
    private static final String RDF_ABOUT_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#about";
    private static final String RDF_TYPE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final String RDF_NIL_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil";
    private static final String RDF_RESOURCE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#resource";
    private static final String METHOD_NAME_START_GET = "get";
    private static final String METHOD_NAME_START_IS = "is";
    private static final String METHOD_NAME_START_SET = "set";
    private static final int METHOD_NAME_START_GET_LENGTH = "get".length();
    private static final int METHOD_NAME_START_IS_LENGTH = "is".length();
    private static final String POSITIVE_INF = "INF";
    private static final String NEGATIVE_INF = "-INF";
    private static final String NOT_A_NUMBER = "NaN";
    public static final String OSLC4J_WRITE_SPECIAL_NUMS = "org.eclipse.lyo.oslc4j.writeSpecialNumberValues";
    public static final String OSLC4J_READ_SPECIAL_NUMS = "org.eclipse.lyo.oslc4j.readSpecialNumberValues";
    private static final Logger logger = Logger.getLogger(JsonHelper.class.getName());

    private JsonHelper() {
    }

    public static JSONObject createJSON(String descriptionAbout, String responseInfoAbout, ResponseInfo<?> responseInfo, Object[] objects, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException, OslcCoreApplicationException {
        JSONObject resultJSONObject = new JSONObject();
        TreeMap<String, String> namespaceMappings = new TreeMap<String, String>();
        HashMap<String, String> reverseNamespaceMappings = new HashMap<String, String>();
        Map globalPrefixDefinitionMap = OslcGlobalNamespaceProvider.getInstance().getPrefixDefinitionMap();
        for (Map.Entry entry : globalPrefixDefinitionMap.entrySet()) {
            namespaceMappings.put((String)entry.getKey(), (String)entry.getValue());
            reverseNamespaceMappings.put((String)entry.getValue(), (String)entry.getKey());
        }
        if (descriptionAbout != null) {
            HashMap<Object, Object> visitedObjects;
            JSONArray jsonArray = new JSONArray();
            for (Object object : objects) {
                visitedObjects = new HashMap<Object, JSONObject>();
                JSONObject jsonObject = JsonHelper.handleSingleResource(object, new JSONObject(), namespaceMappings, reverseNamespaceMappings, properties, visitedObjects);
                if (jsonObject == null) continue;
                jsonArray.add((Object)jsonObject);
            }
            String string = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
            String rdfsPrefix = JsonHelper.ensureNamespacePrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#", namespaceMappings, reverseNamespaceMappings);
            resultJSONObject.put(string + ":about", (Object)descriptionAbout);
            if (OSLC4JUtils.isQueryResultListAsContainer()) {
                JSONArray containerTypesJSONArray = new JSONArray();
                JSONObject containerTypeJSONObject = new JSONObject();
                containerTypeJSONObject.put(string + ":resource", (Object)"http://www.w3.org/2000/01/rdf-schema#Container");
                containerTypesJSONArray.add((Object)containerTypeJSONObject);
                resultJSONObject.put(string + ":type", (Collection)containerTypesJSONArray);
                visitedObjects = new HashMap();
                JsonHelper.addExtendedProperties(namespaceMappings, reverseNamespaceMappings, resultJSONObject, (IExtendedResource)responseInfo.getContainer(), properties, visitedObjects);
            }
            resultJSONObject.put(rdfsPrefix + ":member", (Collection)jsonArray);
            if (responseInfoAbout != null) {
                String oslcPrefix = JsonHelper.ensureNamespacePrefix("oslc", "http://open-services.net/ns/core#", namespaceMappings, reverseNamespaceMappings);
                JSONObject responseInfoJSONObject = new JSONObject();
                responseInfoJSONObject.put(string + ":about", (Object)responseInfoAbout);
                if (responseInfo != null) {
                    responseInfoJSONObject.put(oslcPrefix + ":totalCount", responseInfo.totalCount() == null ? objects.length : responseInfo.totalCount());
                    if (responseInfo.nextPage() != null) {
                        JSONObject nextPageJSONObject = new JSONObject();
                        nextPageJSONObject.put(string + ":resource", (Object)responseInfo.nextPage());
                        responseInfoJSONObject.put(oslcPrefix + ":nextPage", (Map)nextPageJSONObject);
                    }
                    JSONArray responseInfoTypesJSONArray = new JSONArray();
                    JSONObject responseInfoTypeJSONObject = new JSONObject();
                    responseInfoTypeJSONObject.put(string + ":resource", (Object)"http://open-services.net/ns/core#ResponseInfo");
                    responseInfoTypesJSONArray.add((Object)responseInfoTypeJSONObject);
                    responseInfoJSONObject.put(string + ":type", (Collection)responseInfoTypesJSONArray);
                    resultJSONObject.put(oslcPrefix + ":responseInfo", (Map)responseInfoJSONObject);
                    HashMap<Object, JSONObject> visitedObjects2 = new HashMap<Object, JSONObject>();
                    JsonHelper.addExtendedProperties(namespaceMappings, reverseNamespaceMappings, responseInfoJSONObject, responseInfo, properties, visitedObjects2);
                }
            }
        } else if (objects.length == 1) {
            HashMap<Object, JSONObject> visitedObjects = new HashMap<Object, JSONObject>();
            JsonHelper.handleSingleResource(objects[0], resultJSONObject, namespaceMappings, reverseNamespaceMappings, properties, visitedObjects);
        }
        JSONObject namespaces = new JSONObject();
        for (Map.Entry namespaceMapping : namespaceMappings.entrySet()) {
            namespaces.put((String)namespaceMapping.getKey(), namespaceMapping.getValue());
        }
        if (namespaces.size() > 0) {
            resultJSONObject.put(JSON_PROPERTY_PREFIXES, (Map)namespaces);
        }
        return resultJSONObject;
    }

    public static Object[] fromJSON(JSONObject jsonObject, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException {
        Object results;
        Object oslcPrefix;
        Object members;
        String rdfPrefix;
        ArrayList<URI> beans = new ArrayList<URI>();
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        HashMap<String, String> reverseNamespaceMappings = new HashMap<String, String>();
        Object prefixes = jsonObject.opt(JSON_PROPERTY_PREFIXES);
        if (prefixes instanceof JSONObject) {
            JSONObject prefixesJSONObject = (JSONObject)prefixes;
            Set prefixesEntrySet = prefixesJSONObject.entrySet();
            for (Map.Entry prefixEntry : prefixesEntrySet) {
                String prefix = (String)prefixEntry.getKey();
                Object namespace = prefixEntry.getValue();
                if (!(namespace instanceof String)) continue;
                namespaceMappings.put(prefix, namespace.toString());
                reverseNamespaceMappings.put(namespace.toString(), prefix.toString());
            }
        }
        if ((rdfPrefix = (String)reverseNamespaceMappings.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) == null) {
            throw new OslcCoreMissingNamespaceDeclarationException("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        }
        HashMap classPropertyDefinitionsToSetMethods = new HashMap();
        JSONArray jsonArray = null;
        String rdfsPrefix = (String)reverseNamespaceMappings.get("http://www.w3.org/2000/01/rdf-schema#");
        if (rdfsPrefix != null && (members = jsonObject.opt(rdfsPrefix + ":member")) instanceof JSONArray) {
            jsonArray = (JSONArray)members;
        }
        if (jsonArray == null && (oslcPrefix = (String)reverseNamespaceMappings.get("http://open-services.net/ns/core#")) != null && (results = jsonObject.opt((String)oslcPrefix + ":results")) instanceof JSONArray) {
            jsonArray = (JSONArray)results;
        }
        if (jsonArray != null) {
            for (Object object : jsonArray) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject resourceJSONObject = (JSONObject)object;
                if (URI.class.equals(beanClass)) {
                    String uri = resourceJSONObject.optString(rdfPrefix + ":resource");
                    beans.add(URI.create(uri));
                    continue;
                }
                Object bean = beanClass.newInstance();
                HashSet<String> rdfTypes = new HashSet<String>();
                JsonHelper.fromJSON(rdfPrefix, namespaceMappings, classPropertyDefinitionsToSetMethods, resourceJSONObject, beanClass, bean, rdfTypes);
                beans.add((URI)bean);
            }
        } else {
            Object bean = beanClass.newInstance();
            HashSet<String> rdfTypes = new HashSet<String>();
            JsonHelper.fromJSON(rdfPrefix, namespaceMappings, classPropertyDefinitionsToSetMethods, jsonObject, beanClass, bean, rdfTypes);
            beans.add((URI)bean);
        }
        return beans.toArray((Object[])Array.newInstance(beanClass, beans.size()));
    }

    private static void buildAttributeResource(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, JSONObject jsonObject, Object value, Map<String, Object> nestedProperties, boolean onlyNested) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException, OslcCoreApplicationException {
        Object localResourceValue;
        JSONArray jsonArray;
        OslcName nameAnnotation;
        String name;
        String propertyDefinition = propertyDefinitionAnnotation.value();
        if (!propertyDefinition.endsWith(name = (nameAnnotation = (OslcName)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcName.class)) != null ? nameAnnotation.value() : JsonHelper.getDefaultPropertyName(method))) {
            throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, propertyDefinitionAnnotation);
        }
        OslcRdfCollectionType collectionType = (OslcRdfCollectionType)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcRdfCollectionType.class);
        boolean isRdfContainer = collectionType != null && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(collectionType.namespaceURI()) && (JSON_PROPERTY_SUFFIX_LIST.equals(collectionType.collectionType()) || JSON_PROPERTY_SUFFIX_ALT.equals(collectionType.collectionType()) || JSON_PROPERTY_SUFFIX_BAG.equals(collectionType.collectionType()) || JSON_PROPERTY_SUFFIX_SEQ.equals(collectionType.collectionType()));
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            jsonArray = new JSONArray();
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object object = Array.get(value, index);
                Object localResource = JsonHelper.handleLocalResource(namespaceMappings, reverseNamespaceMappings, resourceClass, method, object, nestedProperties, onlyNested);
                if (localResource == null) continue;
                jsonArray.add(localResource);
            }
            localResourceValue = isRdfContainer ? JsonHelper.buildContainer(namespaceMappings, reverseNamespaceMappings, collectionType, jsonArray) : (jsonArray.size() > 0 ? jsonArray : null);
        } else if (Collection.class.isAssignableFrom(returnType)) {
            jsonArray = new JSONArray();
            Collection collection = (Collection)value;
            for (Object object : collection) {
                Object localResource = JsonHelper.handleLocalResource(namespaceMappings, reverseNamespaceMappings, resourceClass, method, object, nestedProperties, onlyNested);
                if (localResource == null) continue;
                jsonArray.add(localResource);
            }
            localResourceValue = isRdfContainer ? JsonHelper.buildContainer(namespaceMappings, reverseNamespaceMappings, collectionType, jsonArray) : (jsonArray.size() > 0 ? jsonArray : null);
        } else {
            localResourceValue = JsonHelper.handleLocalResource(namespaceMappings, reverseNamespaceMappings, resourceClass, method, value, nestedProperties, onlyNested);
        }
        if (localResourceValue != null) {
            String namespace = propertyDefinition.substring(0, propertyDefinition.length() - name.length());
            String prefix = reverseNamespaceMappings.get(namespace);
            if (prefix == null) {
                throw new OslcCoreMissingNamespaceDeclarationException(namespace);
            }
            jsonObject.put(prefix + JSON_PROPERTY_DELIMITER + name, localResourceValue);
        }
    }

    private static Object buildContainer(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, OslcRdfCollectionType collectionType, JSONArray jsonArray) throws JSONException {
        String rdfPrefix = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
        if (JSON_PROPERTY_SUFFIX_LIST.equals(collectionType.collectionType())) {
            JSONObject listObject = new JSONObject();
            listObject.put(rdfPrefix + ":resource", (Object)RDF_NIL_URI);
            for (int i = jsonArray.size() - 1; i >= 0; --i) {
                Object o = jsonArray.get(i);
                JSONObject newListObject = new JSONObject();
                newListObject.put(rdfPrefix + ":first", o);
                newListObject.put(rdfPrefix + ":rest", (Map)listObject);
                listObject = newListObject;
            }
            return listObject;
        }
        JSONObject container = new JSONObject();
        container.put(rdfPrefix + JSON_PROPERTY_DELIMITER + collectionType.collectionType(), (Collection)jsonArray);
        return container;
    }

    private static void buildResource(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Object object, Class<?> objectClass, JSONObject jsonObject, Map<String, Object> properties, Map<Object, JSONObject> visitedObjects) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException, OslcCoreApplicationException {
        visitedObjects.put(object, jsonObject);
        JsonHelper.buildResourceAttributes(namespaceMappings, reverseNamespaceMappings, object, objectClass, jsonObject, properties, visitedObjects);
        String rdfPrefix = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
        if (rdfPrefix != null) {
            String qualifiedName;
            JSONArray rdfTypesJSONArray = new JSONArray();
            if (objectClass.getAnnotation(OslcResourceShape.class) != null) {
                qualifiedName = TypeFactory.getQualifiedName(objectClass);
                if (qualifiedName != null) {
                    JsonHelper.addType(rdfPrefix, rdfTypesJSONArray, qualifiedName);
                }
            } else {
                qualifiedName = null;
            }
            if (object instanceof IExtendedResource) {
                IExtendedResource extendedResource = (IExtendedResource)object;
                for (URI type : extendedResource.getTypes()) {
                    String typeString = type.toString();
                    if (typeString.equals(qualifiedName)) continue;
                    JsonHelper.addType(rdfPrefix, rdfTypesJSONArray, typeString);
                }
            }
            jsonObject.put(rdfPrefix + ":type", (Collection)rdfTypesJSONArray);
        }
    }

    private static void addType(String rdfPrefix, JSONArray rdfTypesJSONArray, String typeURI) throws JSONException {
        JSONObject rdfTypeJSONObject = new JSONObject();
        rdfTypeJSONObject.put(rdfPrefix + ":resource", (Object)typeURI);
        rdfTypesJSONArray.add((Object)rdfTypeJSONObject);
    }

    private static void buildResourceAttributes(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Object object, Class<?> objectClass, JSONObject jsonObject, Map<String, Object> properties, Map<Object, JSONObject> visitedObjects) throws IllegalAccessException, InvocationTargetException, DatatypeConfigurationException, JSONException, OslcCoreApplicationException {
        if (properties == OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
            return;
        }
        for (Method method : objectClass.getMethods()) {
            Object value;
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String methodName;
            if (method.getParameterTypes().length != 0 || (!(methodName = method.getName()).startsWith(METHOD_NAME_START_GET) || methodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!methodName.startsWith(METHOD_NAME_START_IS) || methodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = (OslcPropertyDefinition)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcPropertyDefinition.class)) == null || (value = method.invoke(object, new Object[0])) == null) continue;
            Map nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map map = (Map)properties.get(oslcPropertyDefinitionAnnotation.value());
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)properties).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            JsonHelper.buildAttributeResource(namespaceMappings, reverseNamespaceMappings, objectClass, method, oslcPropertyDefinitionAnnotation, jsonObject, value, nestedProperties, onlyNested);
        }
        if (object instanceof IExtendedResource) {
            IExtendedResource extendedResource = (IExtendedResource)object;
            JsonHelper.addExtendedProperties(namespaceMappings, reverseNamespaceMappings, jsonObject, extendedResource, properties, visitedObjects);
        }
    }

    protected static void addExtendedProperties(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, JSONObject jsonObject, IExtendedResource extendedResource, Map<String, Object> properties, Map<Object, JSONObject> visitedObjects) throws JSONException, DatatypeConfigurationException, IllegalAccessException, InvocationTargetException, OslcCoreApplicationException {
        String rdfPrefix = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
        String rdfTypeKey = rdfPrefix + ":type";
        JSONArray typesJSONArray = jsonObject.containsKey((Object)rdfTypeKey) ? (JSONArray)jsonObject.get(rdfTypeKey) : new JSONArray();
        JSONObject typeJSONObject = new JSONObject();
        for (URI uRI : extendedResource.getTypes()) {
            String propertyName = uRI.toString();
            if (properties != null && properties.get(propertyName) == null && !(properties instanceof NestedWildcardProperties) && !(properties instanceof SingletonWildcardProperties)) continue;
            typeJSONObject.put(rdfPrefix + ":resource", (Object)propertyName);
            typesJSONArray.add((Object)typeJSONObject);
        }
        if (typesJSONArray.size() > 0) {
            jsonObject.put(rdfPrefix + ":type", (Collection)typesJSONArray);
        }
        for (Map.Entry entry : extendedResource.getExtendedProperties().entrySet()) {
            Object value;
            String namespace = ((QName)entry.getKey()).getNamespaceURI();
            String localName = ((QName)entry.getKey()).getLocalPart();
            Map nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map map = (Map)properties.get(namespace + localName);
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)properties).commonNestedProperties();
                    boolean bl = onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            if ((value = JsonHelper.getExtendedPropertyJsonValue(namespaceMappings, reverseNamespaceMappings, entry.getValue(), nestedProperties, onlyNested, visitedObjects)) == null && !onlyNested) {
                logger.warning("Could not add extended property " + entry.getKey() + " for resource " + extendedResource.getAbout());
                continue;
            }
            String prefix = reverseNamespaceMappings.get(namespace);
            if (prefix == null) {
                prefix = ((QName)entry.getKey()).getPrefix();
                namespaceMappings.put(prefix, namespace);
                reverseNamespaceMappings.put(namespace, prefix);
            }
            jsonObject.put(prefix + JSON_PROPERTY_DELIMITER + localName, value);
        }
    }

    private static Object getExtendedPropertyJsonValue(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Object object, Map<String, Object> nestedProperties, boolean onlyNested, Map<Object, JSONObject> visitedObjects) throws JSONException, DatatypeConfigurationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, OslcCoreApplicationException {
        JSONObject returnObject;
        Class<?> resourceClass = object.getClass();
        if (object instanceof Collection) {
            JSONArray jsonArray = new JSONArray();
            Collection c = (Collection)object;
            for (Object next : c) {
                Object nextJson = JsonHelper.getExtendedPropertyJsonValue(namespaceMappings, reverseNamespaceMappings, next, nestedProperties, onlyNested, visitedObjects);
                if (nextJson == null) continue;
                jsonArray.add(nextJson);
            }
            return jsonArray;
        }
        if (object instanceof String || object instanceof Boolean || object instanceof Number) {
            if (onlyNested) {
                return null;
            }
            return object;
        }
        if (object instanceof XMLLiteral) {
            if (onlyNested) {
                return null;
            }
            XMLLiteral xmlLiteral = (XMLLiteral)object;
            return xmlLiteral.getValue();
        }
        if (object instanceof Date) {
            if (onlyNested) {
                return null;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)object);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar).toString();
        }
        if (object instanceof URI) {
            if (onlyNested) {
                return null;
            }
            return JsonHelper.handleResourceReference(namespaceMappings, reverseNamespaceMappings, resourceClass, null, (URI)object);
        }
        if (object instanceof IResource && !visitedObjects.containsKey(object)) {
            return JsonHelper.handleSingleResource(object, new JSONObject(), namespaceMappings, reverseNamespaceMappings, nestedProperties, visitedObjects);
        }
        if (visitedObjects.containsKey(object) && !(returnObject = visitedObjects.get(object)).isEmpty()) {
            return returnObject;
        }
        return null;
    }

    private static String getDefaultPropertyName(Method method) {
        String methodName = method.getName();
        int startingIndex = methodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_GET_LENGTH : METHOD_NAME_START_IS_LENGTH;
        int endingIndex = startingIndex + 1;
        String lowercasedFirstCharacter = methodName.substring(startingIndex, endingIndex).toLowerCase(Locale.ENGLISH);
        if (methodName.length() == endingIndex) {
            return lowercasedFirstCharacter;
        }
        return lowercasedFirstCharacter + methodName.substring(endingIndex);
    }

    private static Object handleLocalResource(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Class<?> resourceClass, Method method, Object object, Map<String, Object> nestedProperties, boolean onlyNested) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException, OslcCoreApplicationException {
        if (object instanceof Float && JsonHelper.writeSpecialNumberValues()) {
            if (onlyNested) {
                return null;
            }
            Float f = (Float)object;
            if (f.compareTo(Float.valueOf(Float.POSITIVE_INFINITY)) == 0) {
                return POSITIVE_INF;
            }
            if (f.compareTo(Float.valueOf(Float.NEGATIVE_INFINITY)) == 0) {
                return NEGATIVE_INF;
            }
            if (f.isNaN()) {
                return NOT_A_NUMBER;
            }
        }
        if (object instanceof Double && JsonHelper.writeSpecialNumberValues()) {
            if (onlyNested) {
                return null;
            }
            Double d = (Double)object;
            if (d.compareTo(Double.POSITIVE_INFINITY) == 0) {
                return POSITIVE_INF;
            }
            if (d.compareTo(Double.NEGATIVE_INFINITY) == 0) {
                return NEGATIVE_INF;
            }
            if (d.isNaN()) {
                return NOT_A_NUMBER;
            }
        }
        if (object instanceof String || object instanceof Boolean || object instanceof Number) {
            if (onlyNested) {
                return null;
            }
            return object;
        }
        if (object instanceof URI) {
            if (onlyNested) {
                return null;
            }
            return JsonHelper.handleResourceReference(namespaceMappings, reverseNamespaceMappings, resourceClass, method, (URI)object);
        }
        if (object instanceof Date) {
            if (onlyNested) {
                return null;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)object);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar).toString();
        }
        if (object instanceof IReifiedResource) {
            return JsonHelper.handleReifiedResource(namespaceMappings, reverseNamespaceMappings, object.getClass(), method, (IReifiedResource)object, nestedProperties);
        }
        HashMap<Object, JSONObject> visitedObjects = new HashMap<Object, JSONObject>();
        return JsonHelper.handleSingleResource(object, new JSONObject(), namespaceMappings, reverseNamespaceMappings, nestedProperties, visitedObjects);
    }

    private static Object handleReifiedResource(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Class<?> resourceClass, Method method, IReifiedResource<?> reifiedResource, Map<String, Object> properties) throws OslcCoreInvalidPropertyTypeException, OslcCoreRelativeURIException, JSONException, IllegalAccessException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException {
        Object value = reifiedResource.getValue();
        if (value == null) {
            return null;
        }
        if (!(value instanceof URI)) {
            throw new OslcCoreInvalidPropertyTypeException(resourceClass, method, method.getReturnType());
        }
        JSONObject jsonObject = JsonHelper.handleResourceReference(namespaceMappings, reverseNamespaceMappings, resourceClass, method, (URI)value);
        HashMap<Object, JSONObject> visitedObjects = new HashMap<Object, JSONObject>();
        JsonHelper.buildResourceAttributes(namespaceMappings, reverseNamespaceMappings, reifiedResource, resourceClass, jsonObject, properties, visitedObjects);
        return jsonObject;
    }

    protected static JSONObject handleResourceReference(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Class<?> resourceClass, Method method, URI uri) throws OslcCoreRelativeURIException, JSONException {
        if (OSLC4JUtils.relativeURIsAreDisabled() && !uri.isAbsolute()) {
            throw new OslcCoreRelativeURIException(resourceClass, method == null ? "<none>" : method.getName(), uri);
        }
        JSONObject jsonObject = new JSONObject();
        String rdfPrefix = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
        jsonObject.put(rdfPrefix + ":resource", (Object)uri.toString());
        return jsonObject;
    }

    private static JSONObject handleSingleResource(Object object, JSONObject jsonObject, Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Map<String, Object> properties, Map<Object, JSONObject> visitedObjects) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException, OslcCoreApplicationException {
        Class<?> objectClass = object.getClass();
        if (object instanceof URI) {
            String rdfPrefix = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
            jsonObject.put(rdfPrefix + ":resource", (Object)((URI)object).toASCIIString());
            visitedObjects.put(object, jsonObject);
        } else {
            JsonHelper.recursivelyCollectNamespaceMappings(namespaceMappings, reverseNamespaceMappings, objectClass);
            if (object instanceof IResource) {
                URI aboutURI = ((IResource)object).getAbout();
                JsonHelper.addAboutURI(jsonObject, namespaceMappings, reverseNamespaceMappings, objectClass, aboutURI);
            }
            JsonHelper.buildResource(namespaceMappings, reverseNamespaceMappings, object, objectClass, jsonObject, properties, visitedObjects);
        }
        return jsonObject;
    }

    protected static void addAboutURI(JSONObject jsonObject, Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Class<? extends Object> objectClass, URI aboutURI) throws OslcCoreRelativeURIException, JSONException {
        if (aboutURI != null) {
            if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
            }
            String rdfPrefix = JsonHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings, reverseNamespaceMappings);
            jsonObject.put(rdfPrefix + ":about", (Object)aboutURI.toString());
        }
    }

    private static String ensureNamespacePrefix(String prefix, String namespace, Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings) {
        String existingPrefix = reverseNamespaceMappings.get(namespace);
        if (existingPrefix != null) {
            return existingPrefix;
        }
        String existingNamespace = namespaceMappings.get(prefix);
        if (existingNamespace == null) {
            namespaceMappings.put(prefix, namespace);
            reverseNamespaceMappings.put(namespace, prefix);
            return prefix;
        }
        int index = 1;
        while (true) {
            String newPrefix;
            if (!namespaceMappings.containsKey(newPrefix = prefix + index)) {
                namespaceMappings.put(newPrefix, namespace);
                reverseNamespaceMappings.put(namespace, newPrefix);
                return newPrefix;
            }
            ++index;
        }
    }

    private static void recursivelyCollectNamespaceMappings(Map<String, String> namespaceMappings, Map<String, String> reverseNamespaceMappings, Class<? extends Object> objectClass) {
        Class<?>[] interfaces;
        Class<? extends Object> superClass;
        OslcSchema oslcSchemaAnnotation = objectClass.getPackage().getAnnotation(OslcSchema.class);
        if (oslcSchemaAnnotation != null) {
            OslcNamespaceDefinition[] oslcNamespaceDefinitionAnnotations;
            for (OslcNamespaceDefinition oslcNamespaceDefinitionAnnotation : oslcNamespaceDefinitionAnnotations = oslcSchemaAnnotation.value()) {
                String prefix = oslcNamespaceDefinitionAnnotation.prefix();
                String namespaceURI = oslcNamespaceDefinitionAnnotation.namespaceURI();
                namespaceMappings.put(prefix, namespaceURI);
                reverseNamespaceMappings.put(namespaceURI, prefix);
            }
            Class customNamespaceProvider = oslcSchemaAnnotation.customNamespaceProvider();
            if (!customNamespaceProvider.isInterface()) {
                try {
                    IOslcCustomNamespaceProvider customNamespaceProviderImpl = (IOslcCustomNamespaceProvider)customNamespaceProvider.newInstance();
                    Map customNamespacePrefixes = customNamespaceProviderImpl.getCustomNamespacePrefixes();
                    if (null != customNamespacePrefixes) {
                        for (Map.Entry namespaceEntry : customNamespacePrefixes.entrySet()) {
                            namespaceMappings.put((String)namespaceEntry.getKey(), (String)namespaceEntry.getValue());
                            reverseNamespaceMappings.put((String)namespaceEntry.getValue(), (String)namespaceEntry.getKey());
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("The custom namespace provider implementation: " + customNamespaceProvider.getClass().getName() + ", must have a public no args construtor", e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("The custom namespace provider must not be a abstract, nor interface class and must have a public no args constructor", e);
                }
            }
        }
        if ((superClass = objectClass.getSuperclass()) != null) {
            JsonHelper.recursivelyCollectNamespaceMappings(namespaceMappings, reverseNamespaceMappings, superClass);
        }
        if ((interfaces = objectClass.getInterfaces()) != null) {
            for (Class<?> interfac : interfaces) {
                JsonHelper.recursivelyCollectNamespaceMappings(namespaceMappings, reverseNamespaceMappings, interfac);
            }
        }
    }

    private static HashSet<String> getRdfTypesFromJsonObject(JSONObject jsonObject, String rdfPrefix, HashSet<String> types) {
        String typeProperty;
        if (OSLC4JUtils.inferTypeFromShape() && types.isEmpty() && jsonObject.has(typeProperty = rdfPrefix + ":type")) {
            try {
                JSONArray array = jsonObject.getJSONArray(typeProperty);
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject typeObj = array.getJSONObject(i);
                    String resTypePropertyValue = typeObj.getString(rdfPrefix + ":resource");
                    types.add(resTypePropertyValue);
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return types;
    }

    private static void fromJSON(String rdfPrefix, Map<String, String> jsonNamespaceMappings, Map<Class<?>, Map<String, Method>> classPropertyDefinitionsToSetMethods, JSONObject jsonObject, Class<?> beanClass, Object bean, HashSet<String> rdfTypes) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException {
        HashMap<QName, Object> extendedProperties;
        IExtendedResource extendedResource;
        Map<String, Method> setMethodMap = classPropertyDefinitionsToSetMethods.get(beanClass);
        if (setMethodMap == null) {
            setMethodMap = JsonHelper.createPropertyDefinitionToSetMethods(beanClass);
            classPropertyDefinitionsToSetMethods.put(beanClass, setMethodMap);
        }
        boolean isIReifiedResource = false;
        if (bean instanceof IResource) {
            Object aboutURIObject = jsonObject.opt(rdfPrefix + ":about");
            if (aboutURIObject instanceof String) {
                URI aboutURI = new URI(aboutURIObject.toString());
                if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(beanClass, "setAbout", aboutURI);
                }
                ((IResource)bean).setAbout(aboutURI);
            }
        } else if (bean instanceof IReifiedResource) {
            String resourceReference;
            isIReifiedResource = true;
            IReifiedResource reifiedResource = (IReifiedResource)bean;
            try {
                resourceReference = jsonObject.getString(rdfPrefix + ":resource");
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
            try {
                reifiedResource.setValue((Object)new URI(resourceReference));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (bean instanceof IExtendedResource) {
            extendedResource = (IExtendedResource)bean;
            extendedProperties = new HashMap<QName, Object>();
            extendedResource.setExtendedProperties(extendedProperties);
        } else {
            extendedResource = null;
            extendedProperties = null;
        }
        rdfTypes = JsonHelper.getRdfTypesFromJsonObject(jsonObject, rdfPrefix, rdfTypes);
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            Object parameter;
            Type actualTypeArgument;
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Type genericParameterType;
            String prefixedName = (String)entry.getKey();
            Object jsonValue = entry.getValue();
            String[] split = prefixedName.split(JSON_PROPERTY_DELIMITER);
            if (split.length != 2) {
                if (JSON_PROPERTY_PREFIXES.equals(prefixedName)) continue;
                logger.warning("Ignored JSON property '" + prefixedName + "'.");
                continue;
            }
            String namespacePrefix = split[0];
            String name = split[1];
            String namespace = jsonNamespaceMappings.get(namespacePrefix);
            if (namespace == null) {
                throw new OslcCoreMissingNamespacePrefixException(namespacePrefix);
            }
            String propertyDefinition = namespace + name;
            Method setMethod = setMethodMap.get(propertyDefinition);
            if (setMethod == null) {
                if (RDF_ABOUT_URI.equals(propertyDefinition) || isIReifiedResource && RDF_RESOURCE_URI.equals(propertyDefinition)) continue;
                if (RDF_TYPE_URI.equals(propertyDefinition)) {
                    if (extendedResource == null) continue;
                    JsonHelper.fillInRdfType(rdfPrefix, jsonObject, extendedResource);
                    continue;
                }
                if (extendedProperties == null) {
                    logger.fine("Set method not found for object type:\t" + beanClass.getName() + ", propertyDefinition:\t" + propertyDefinition);
                    continue;
                }
                QName qName = new QName(namespace, name, namespacePrefix);
                Object value = JsonHelper.fromExtendedJSONValue(jsonValue, rdfPrefix, jsonNamespaceMappings, beanClass, qName, rdfTypes);
                extendedProperties.put(qName, value);
                continue;
            }
            Class setMethodParameterClass = setMethod.getParameterTypes()[0];
            Class setMethodComponentParameterClass = setMethodParameterClass;
            if (setMethodComponentParameterClass.isArray()) {
                setMethodComponentParameterClass = setMethodComponentParameterClass.getComponentType();
            } else if (Collection.class.isAssignableFrom(setMethodComponentParameterClass) && (genericParameterType = setMethod.getGenericParameterTypes()[0]) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                setMethodComponentParameterClass = (Class)actualTypeArgument;
            }
            if ((parameter = JsonHelper.fromJSONValue(rdfPrefix, jsonNamespaceMappings, classPropertyDefinitionsToSetMethods, beanClass, setMethod, setMethodParameterClass, setMethodComponentParameterClass, jsonValue, rdfTypes)) == null) continue;
            setMethod.invoke(bean, parameter);
        }
    }

    private static Object fromExtendedJSONValue(Object jsonValue, String rdfPrefix, Map<String, String> jsonNamespaceMappings, Class<?> beanClass, QName propertyQName, HashSet<String> rdfTypes) throws DatatypeConfigurationException, URISyntaxException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, OslcCoreApplicationException {
        Object newObject;
        if (jsonValue instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)jsonValue;
            ArrayList<Object> collection = new ArrayList<Object>();
            Iterator i = jsonArray.iterator();
            while (i.hasNext()) {
                collection.add(JsonHelper.fromExtendedJSONValue(i.next(), rdfPrefix, jsonNamespaceMappings, beanClass, propertyQName, rdfTypes));
            }
            return collection;
        }
        if (jsonValue instanceof JSONObject) {
            JSONObject o = (JSONObject)jsonValue;
            Object resourceURIValue = o.opt(rdfPrefix + ":resource");
            if (resourceURIValue != null) {
                URI uri = new URI((String)resourceURIValue);
                if (OSLC4JUtils.relativeURIsAreDisabled() && !uri.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(beanClass, "<none>", uri);
                }
                return new URI((String)resourceURIValue);
            }
            AnyResource any = new AnyResource();
            JsonHelper.fromJSON(rdfPrefix, jsonNamespaceMappings, new HashMap(), o, AnyResource.class, any, rdfTypes);
            return any;
        }
        if (jsonValue instanceof String) {
            Object newObject2;
            if (OSLC4JUtils.inferTypeFromShape() && null != (newObject2 = OSLC4JUtils.getValueBasedOnResourceShapeType(rdfTypes, (QName)propertyQName, (Object)jsonValue)) && (newObject2 instanceof String || newObject2 instanceof XMLLiteral || newObject2 instanceof Date)) {
                return newObject2;
            }
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar((String)jsonValue).toGregorianCalendar().getTime();
            }
            catch (IllegalArgumentException e) {
                return jsonValue;
            }
        }
        if (jsonValue instanceof Integer) {
            return jsonValue;
        }
        if (jsonValue instanceof Double && OSLC4JUtils.inferTypeFromShape() && null != (newObject = OSLC4JUtils.getValueBasedOnResourceShapeType(rdfTypes, (QName)propertyQName, (Object)jsonValue)) && (newObject instanceof Double || newObject instanceof Float || newObject instanceof BigDecimal)) {
            return newObject;
        }
        return jsonValue;
    }

    protected static void fillInRdfType(String rdfPrefix, JSONObject jsonObject, IExtendedResource resource) throws URISyntaxException {
        String typeProperty = rdfPrefix + ":type";
        if (jsonObject.has(typeProperty)) {
            try {
                JSONArray array = jsonObject.getJSONArray(typeProperty);
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject typeObj = array.getJSONObject(i);
                    resource.addType(new URI(typeObj.getString(rdfPrefix + ":resource")));
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static boolean isRdfListNode(String rdfPrefix, Class<?> beanClass, Method setMethod, Object jsonValue) {
        boolean isListNode;
        if (!(jsonValue instanceof JSONObject)) {
            return false;
        }
        JSONObject jsonObject = (JSONObject)jsonValue;
        boolean bl = isListNode = jsonObject.has(rdfPrefix + ":first") && jsonObject.has(rdfPrefix + ":rest");
        if (isListNode) {
            return true;
        }
        boolean isNilResource = RDF_NIL_URI.equals(jsonObject.optString(rdfPrefix + ":resource"));
        if (!isNilResource) {
            return false;
        }
        String setMethodName = setMethod.getName();
        if (setMethodName.startsWith(METHOD_NAME_START_SET)) {
            Method getMethod;
            String getMethodName = METHOD_NAME_START_GET + setMethodName.substring(METHOD_NAME_START_GET_LENGTH);
            try {
                getMethod = beanClass.getMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String isMethodName = METHOD_NAME_START_IS + setMethodName.substring(METHOD_NAME_START_GET_LENGTH);
                try {
                    getMethod = beanClass.getMethod(isMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    return false;
                }
            }
            OslcRdfCollectionType collectionType = (OslcRdfCollectionType)InheritedMethodAnnotationHelper.getAnnotation((Method)getMethod, OslcRdfCollectionType.class);
            if (collectionType != null && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(collectionType.namespaceURI()) && JSON_PROPERTY_SUFFIX_LIST.equals(collectionType.collectionType())) {
                return true;
            }
        }
        return false;
    }

    private static Object fromJSONValue(String rdfPrefix, Map<String, String> jsonNamespaceMappings, Map<Class<?>, Map<String, Method>> classPropertyDefinitionsToSetMethods, Class<?> beanClass, Method setMethod, Class<?> setMethodParameterClass, Class<?> setMethodComponentParameterClass, Object jsonValue, HashSet<String> rdfTypes) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException {
        boolean isRdfContainerNode = JsonHelper.isRdfListNode(rdfPrefix, beanClass, setMethod, jsonValue);
        JSONArray container = null;
        if (!isRdfContainerNode && jsonValue instanceof JSONObject) {
            JSONObject parent = (JSONObject)jsonValue;
            try {
                container = parent.optJSONArray(rdfPrefix + ":Alt", null);
                if (container == null) {
                    container = parent.optJSONArray(rdfPrefix + ":Bag", null);
                }
                if (container == null) {
                    container = parent.optJSONArray(rdfPrefix + ":Seq", null);
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
            boolean bl = isRdfContainerNode = container != null;
        }
        if (!isRdfContainerNode && jsonValue instanceof JSONObject) {
            Object uriObject;
            JSONObject nestedJSONObject = (JSONObject)jsonValue;
            if (!IReifiedResource.class.isAssignableFrom(setMethodComponentParameterClass) && (uriObject = nestedJSONObject.opt(rdfPrefix + ":resource")) instanceof String) {
                URI uri = new URI(uriObject.toString());
                if (OSLC4JUtils.relativeURIsAreDisabled() && !uri.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(beanClass, setMethod.getName(), uri);
                }
                return uri;
            }
            Object nestedBean = setMethodComponentParameterClass.newInstance();
            JsonHelper.fromJSON(rdfPrefix, jsonNamespaceMappings, classPropertyDefinitionsToSetMethods, nestedJSONObject, setMethodComponentParameterClass, nestedBean, rdfTypes);
            return nestedBean;
        }
        if (jsonValue instanceof JSONArray || isRdfContainerNode) {
            Collection<Object> collection;
            JSONArray jsonArray;
            if (isRdfContainerNode && container == null) {
                jsonArray = new ArrayList();
                for (JSONObject listNode = (JSONObject)jsonValue; listNode != null && !RDF_NIL_URI.equals(listNode.opt(rdfPrefix + ":resource")); listNode = listNode.optJSONObject(rdfPrefix + ":rest")) {
                    Object o = listNode.opt(rdfPrefix + ":first");
                    jsonArray.add(o);
                }
            } else {
                JSONArray array;
                jsonArray = isRdfContainerNode ? (array = container) : (array = (JSONArray)jsonValue);
            }
            ArrayList<Object> tempList = new ArrayList<Object>();
            for (Object jsonArrayEntryObject : jsonArray) {
                Object parameterArrayObject = JsonHelper.fromJSONValue(rdfPrefix, jsonNamespaceMappings, classPropertyDefinitionsToSetMethods, beanClass, setMethod, setMethodComponentParameterClass, setMethodComponentParameterClass, jsonArrayEntryObject, rdfTypes);
                tempList.add(parameterArrayObject);
            }
            if (setMethodParameterClass.isArray()) {
                Object array = Array.newInstance(setMethodComponentParameterClass, jsonArray.size());
                int index = 0;
                for (Object e : tempList) {
                    Array.set(array, index, e);
                    ++index;
                }
                return array;
            }
            if (Collection.class == setMethodParameterClass || List.class == setMethodParameterClass || Deque.class == setMethodParameterClass || Queue.class == setMethodParameterClass || AbstractCollection.class == setMethodParameterClass || AbstractList.class == setMethodParameterClass || AbstractSequentialList.class == setMethodParameterClass) {
                collection = new LinkedList<Object>();
            } else if (Set.class == setMethodParameterClass || AbstractSet.class == setMethodParameterClass) {
                collection = new HashSet();
            } else if (SortedSet.class == setMethodParameterClass || NavigableSet.class == setMethodParameterClass) {
                collection = new TreeSet();
            } else {
                Collection tempCollection = (Collection)setMethodParameterClass.newInstance();
                collection = tempCollection;
            }
            collection.addAll(tempList);
            return collection;
        }
        if (jsonValue == null) {
            if (Boolean.class == setMethodComponentParameterClass || Boolean.TYPE == setMethodComponentParameterClass) {
                throw new IllegalArgumentException("Boolean cannot be null.");
            }
            if (Double.TYPE == setMethodComponentParameterClass) {
                if (JsonHelper.readSpecialNumberValues()) {
                    logger.warning("Null double value treated as NaN.");
                    return Double.NaN;
                }
                throw new IllegalArgumentException("Null double value not allowed. You can change this behavior by setting system property of org.eclipse.lyo.oslc4j.readSpecialNumberValues to true.");
            }
            if (Float.TYPE == setMethodComponentParameterClass) {
                if (JsonHelper.readSpecialNumberValues()) {
                    logger.warning("Null float value treated as NaN.");
                    return Float.valueOf(Float.NaN);
                }
                throw new IllegalArgumentException("Null float value not allowed. You can change this behavior by setting system property of org.eclipse.lyo.oslc4j.readSpecialNumberValues to true.");
            }
            if (Short.TYPE == setMethodComponentParameterClass || Integer.TYPE == setMethodComponentParameterClass || Long.TYPE == setMethodComponentParameterClass) {
                throw new IllegalArgumentException("Null values not allowed for type " + setMethodComponentParameterClass);
            }
            return null;
        }
        String stringValue = jsonValue.toString();
        if (String.class == setMethodComponentParameterClass) {
            return stringValue;
        }
        if (Boolean.class == setMethodComponentParameterClass || Boolean.TYPE == setMethodComponentParameterClass) {
            if (Boolean.TRUE.toString().equals(stringValue)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equals(stringValue)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("'" + stringValue + "' has wrong format for Boolean.");
        }
        if (Byte.class == setMethodComponentParameterClass || Byte.TYPE == setMethodComponentParameterClass) {
            return Byte.valueOf(stringValue);
        }
        if (Short.class == setMethodComponentParameterClass || Short.TYPE == setMethodComponentParameterClass) {
            return Short.valueOf(stringValue);
        }
        if (Integer.class == setMethodComponentParameterClass || Integer.TYPE == setMethodComponentParameterClass) {
            return Integer.valueOf(stringValue);
        }
        if (Long.class == setMethodComponentParameterClass || Long.TYPE == setMethodComponentParameterClass) {
            return Long.valueOf(stringValue);
        }
        if (BigInteger.class == setMethodComponentParameterClass) {
            return new BigInteger(stringValue);
        }
        if (Float.class == setMethodComponentParameterClass || Float.TYPE == setMethodComponentParameterClass) {
            if (JsonHelper.readSpecialNumberValues()) {
                if (POSITIVE_INF.equals(stringValue) || "Infinity".equals(stringValue)) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if (NEGATIVE_INF.equals(stringValue) || "-Infinity".equals(stringValue)) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if (NOT_A_NUMBER.equals(stringValue)) {
                    return Float.valueOf(Float.NaN);
                }
            }
            return Float.valueOf(stringValue);
        }
        if (Double.class == setMethodComponentParameterClass || Double.TYPE == setMethodComponentParameterClass) {
            if (JsonHelper.readSpecialNumberValues()) {
                if (POSITIVE_INF.equals(stringValue) || "Infinity".equals(stringValue)) {
                    return Double.POSITIVE_INFINITY;
                }
                if (NEGATIVE_INF.equals(stringValue) || "-Infinity".equals(stringValue)) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (NOT_A_NUMBER.equals(stringValue)) {
                    return Double.NaN;
                }
            }
            return Double.valueOf(stringValue);
        }
        if (Date.class == setMethodComponentParameterClass) {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(stringValue).toGregorianCalendar().getTime();
        }
        return null;
    }

    private static boolean readSpecialNumberValues() {
        return "true".equals(System.getProperty(OSLC4J_READ_SPECIAL_NUMS, "true"));
    }

    private static boolean writeSpecialNumberValues() {
        return "true".equals(System.getProperty(OSLC4J_WRITE_SPECIAL_NUMS, "true"));
    }

    private static Map<String, Method> createPropertyDefinitionToSetMethods(Class<?> beanClass) throws OslcCoreApplicationException {
        Method[] methods;
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method method : methods = beanClass.getMethods()) {
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String getMethodName;
            if (method.getParameterTypes().length != 0 || (!(getMethodName = method.getName()).startsWith(METHOD_NAME_START_GET) || getMethodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!getMethodName.startsWith(METHOD_NAME_START_IS) || getMethodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = (OslcPropertyDefinition)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcPropertyDefinition.class)) == null) continue;
            String setMethodName = getMethodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_GET_LENGTH) : METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_IS_LENGTH);
            Class<?> getMethodReturnType = method.getReturnType();
            try {
                Method setMethod = beanClass.getMethod(setMethodName, getMethodReturnType);
                result.put(oslcPropertyDefinitionAnnotation.value(), setMethod);
            }
            catch (NoSuchMethodException exception) {
                throw new OslcCoreMissingSetMethodException(beanClass, method, (Exception)exception);
            }
        }
        return result;
    }
}

