/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals.query;

import org.apache.jena.http.HttpLib;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTPBuilder;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.eclipse.lyo.store.internals.query.JenaQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQueryExecutorBasicAuthImpl
implements JenaQueryExecutor {
    private final Logger log = LoggerFactory.getLogger(SparqlQueryExecutorBasicAuthImpl.class);
    private final String queryEndpoint;
    private final String updateEndpoint;
    private final String login;
    private final String password;

    public SparqlQueryExecutorBasicAuthImpl(String sparqlEndpoint, String updateEndpoint, String login, String password) {
        this.queryEndpoint = sparqlEndpoint;
        this.updateEndpoint = updateEndpoint;
        this.login = login;
        this.password = password;
    }

    @Override
    public QueryExecution prepareSparqlQuery(String query) {
        return (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTPBuilder.create().endpoint(this.queryEndpoint)).httpHeader("Authorization", HttpLib.basicAuth((String)this.login, (String)this.password))).query(query)).build();
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(UpdateRequest updateRequest) {
        return (UpdateProcessor)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)UpdateExecutionHTTPBuilder.create().endpoint(this.updateEndpoint)).httpHeader("Authorization", HttpLib.basicAuth((String)this.login, (String)this.password))).update(updateRequest)).build();
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(Update update) {
        return this.prepareSparqlUpdate(new UpdateRequest(update));
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(String query) {
        return this.prepareSparqlUpdate(UpdateFactory.create((String)query));
    }

    @Override
    public void release() {
        this.log.trace("No resources to release");
    }

    @Override
    public void beginWrite() {
    }

    @Override
    public void beginRead() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void end() {
    }
}

