/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser.ast.regex;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;

public class RegExAlts
extends RegEx {
    public final List<RegEx> alts;

    public RegExAlts(List<RegEx> alts) {
        super(null);
        this.alts = alts;
        Assert.check((alts.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public boolean acceptsEmptyString() {
        for (RegEx alt : this.alts) {
            if (!alt.acceptsEmptyString()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Integer> getCodePoints() {
        Set rslt = null;
        for (RegEx alt : this.alts) {
            Set altRslt = alt.getCodePoints();
            Set set = rslt = rslt == null ? altRslt : Sets.union(rslt, altRslt);
        }
        return rslt;
    }

    @Override
    public Set<RegExChar> getChars() {
        Set rslt = null;
        for (RegEx alt : this.alts) {
            Set altRslt = alt.getChars();
            Set set = rslt = rslt == null ? altRslt : Sets.union(rslt, altRslt);
        }
        return rslt;
    }

    @Override
    public boolean isDescriptionText() {
        return false;
    }

    @Override
    public String getDescriptionText() {
        return null;
    }

    @Override
    public int getBindingStrength() {
        return 0;
    }

    @Override
    public String toString() {
        int myStrength = this.getBindingStrength();
        StringBuilder rslt = new StringBuilder();
        boolean first = true;
        for (RegEx part : this.alts) {
            if (!first) {
                rslt.append("|");
            }
            String partTxt = part.toString();
            int partStrength = part.getBindingStrength();
            if (myStrength > partStrength || myStrength == partStrength && !first) {
                rslt.append("(" + partTxt + ")");
            } else {
                rslt.append(partTxt);
            }
            first = false;
        }
        return rslt.toString();
    }
}

