/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SourcesFileHyperlink
implements IHyperlink {
    private String fileName;
    private IFile original;
    private IRegion region;

    public SourcesFileHyperlink(IFile original, String fileName, IRegion region) {
        this.fileName = fileName;
        this.original = original;
        this.region = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)Messages.SourcesFileHyperlink_0, (Object)this.fileName);
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IContainer container = this.original.getParent();
        IResource resourceToOpen = container.findMember(this.fileName);
        if (resourceToOpen == null) {
            IResource sourcesFolder = container.getParent().findMember("SOURCES");
            resourceToOpen = ((IFolder)sourcesFolder).getFile(this.fileName);
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (resourceToOpen.getType() == 1) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resourceToOpen));
            }
        }
        catch (PartInitException e) {
            SpecfileLog.logError(e);
        }
    }
}

