/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo2;
import org.eclipse.linuxtools.docker.core.IDockerContainerMount;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerMount;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerState;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerNetworkSettings;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.ContainerMount;

public class DockerContainerInfo
implements IDockerContainerInfo,
IDockerContainerInfo2 {
    private String id;
    private Date created;
    private String path;
    private List<String> args;
    private IDockerContainerConfig config;
    private IDockerHostConfig hostConfig;
    private IDockerContainerState state;
    private String image;
    private IDockerNetworkSettings networkSettings;
    private String resolvConfPath;
    private String hostnamePath;
    private String hostsPath;
    private String name;
    private String driver;
    private String execDriver;
    private String processLabel;
    private String mountLabel;
    private List<IDockerContainerMount> mounts;

    public DockerContainerInfo(ContainerInfo info) {
        this.id = info != null ? info.id() : null;
        this.created = info != null ? info.created() : null;
        this.path = info != null ? info.path() : null;
        this.args = info != null ? info.args() : null;
        this.config = info != null && info.config() != null ? new DockerContainerConfig(info.config()) : null;
        this.hostConfig = info != null && info.hostConfig() != null ? new DockerHostConfig(info.hostConfig()) : null;
        this.state = info != null && info.state() != null ? new DockerContainerState(info.state()) : null;
        this.image = info != null ? info.image() : null;
        this.networkSettings = info != null && info.networkSettings() != null ? new DockerNetworkSettings(info.networkSettings()) : null;
        this.resolvConfPath = info != null ? info.resolvConfPath() : null;
        this.hostnamePath = info != null ? info.hostnamePath() : null;
        this.hostsPath = info != null ? info.hostsPath() : null;
        this.name = info != null ? info.name() : null;
        this.driver = info != null ? info.driver() : null;
        this.execDriver = info != null ? info.execDriver() : null;
        this.processLabel = info != null ? info.processLabel() : null;
        String string = this.mountLabel = info != null ? info.mountLabel() : null;
        if (info.mounts() != null) {
            this.mounts = new ArrayList<IDockerContainerMount>();
            for (ContainerMount mount : info.mounts()) {
                this.mounts.add(new DockerContainerMount(mount));
            }
        } else {
            this.mounts = null;
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Date created() {
        return this.created == null ? null : new Date(this.created.getTime());
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public List<String> args() {
        return this.args;
    }

    @Override
    public IDockerContainerConfig config() {
        return this.config;
    }

    @Override
    public IDockerHostConfig hostConfig() {
        return this.hostConfig;
    }

    @Override
    public IDockerContainerState state() {
        return this.state;
    }

    @Override
    public String image() {
        return this.image;
    }

    @Override
    public IDockerNetworkSettings networkSettings() {
        return this.networkSettings;
    }

    @Override
    public String resolvConfPath() {
        return this.resolvConfPath;
    }

    @Override
    public String hostnamePath() {
        return this.hostnamePath;
    }

    @Override
    public String hostsPath() {
        return this.hostsPath;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String driver() {
        return this.driver;
    }

    @Override
    public String execDriver() {
        return this.execDriver;
    }

    @Override
    public String processLabel() {
        return this.processLabel;
    }

    @Override
    public String mountLabel() {
        return this.mountLabel;
    }

    @Override
    public List<IDockerContainerMount> mounts() {
        return this.mounts;
    }

    @Override
    @Deprecated
    public Map<String, String> volumes() {
        return null;
    }

    @Override
    @Deprecated
    public Map<String, Boolean> volumesRW() {
        return null;
    }
}

