package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link RestartPolicy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRestartPolicy.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableRestartPolicy implements RestartPolicy {
  private final @Nullable String condition;
  private final @Nullable Long delay;
  private final @Nullable Integer maxAttempts;
  private final @Nullable Long window;

  private ImmutableRestartPolicy(
      @Nullable String condition,
      @Nullable Long delay,
      @Nullable Integer maxAttempts,
      @Nullable Long window) {
    this.condition = condition;
    this.delay = delay;
    this.maxAttempts = maxAttempts;
    this.window = window;
  }

  /**
   * @return The value of the {@code condition} attribute
   */
  @JsonProperty("Condition")
  @Override
  public @Nullable String condition() {
    return condition;
  }

  /**
   * @return The value of the {@code delay} attribute
   */
  @JsonProperty("Delay")
  @Override
  public @Nullable Long delay() {
    return delay;
  }

  /**
   * @return The value of the {@code maxAttempts} attribute
   */
  @JsonProperty("MaxAttempts")
  @Override
  public @Nullable Integer maxAttempts() {
    return maxAttempts;
  }

  /**
   * @return The value of the {@code window} attribute
   */
  @JsonProperty("Window")
  @Override
  public @Nullable Long window() {
    return window;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestartPolicy#condition() condition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for condition (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestartPolicy withCondition(@Nullable String value) {
    if (Objects.equals(this.condition, value)) return this;
    return new ImmutableRestartPolicy(value, this.delay, this.maxAttempts, this.window);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestartPolicy#delay() delay} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delay (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestartPolicy withDelay(@Nullable Long value) {
    if (Objects.equals(this.delay, value)) return this;
    return new ImmutableRestartPolicy(this.condition, value, this.maxAttempts, this.window);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestartPolicy#maxAttempts() maxAttempts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxAttempts (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestartPolicy withMaxAttempts(@Nullable Integer value) {
    if (Objects.equals(this.maxAttempts, value)) return this;
    return new ImmutableRestartPolicy(this.condition, this.delay, value, this.window);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestartPolicy#window() window} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for window (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestartPolicy withWindow(@Nullable Long value) {
    if (Objects.equals(this.window, value)) return this;
    return new ImmutableRestartPolicy(this.condition, this.delay, this.maxAttempts, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRestartPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRestartPolicy
        && equalTo(0, (ImmutableRestartPolicy) another);
  }

  private boolean equalTo(int synthetic, ImmutableRestartPolicy another) {
    return Objects.equals(condition, another.condition)
        && Objects.equals(delay, another.delay)
        && Objects.equals(maxAttempts, another.maxAttempts)
        && Objects.equals(window, another.window);
  }

  /**
   * Computes a hash code from attributes: {@code condition}, {@code delay}, {@code maxAttempts}, {@code window}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(condition);
    h += (h << 5) + Objects.hashCode(delay);
    h += (h << 5) + Objects.hashCode(maxAttempts);
    h += (h << 5) + Objects.hashCode(window);
    return h;
  }

  /**
   * Prints the immutable value {@code RestartPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RestartPolicy{"
        + "condition=" + condition
        + ", delay=" + delay
        + ", maxAttempts=" + maxAttempts
        + ", window=" + window
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RestartPolicy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RestartPolicy instance
   */
  public static ImmutableRestartPolicy copyOf(RestartPolicy instance) {
    if (instance instanceof ImmutableRestartPolicy) {
      return (ImmutableRestartPolicy) instance;
    }
    return ImmutableRestartPolicy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRestartPolicy ImmutableRestartPolicy}.
   * <pre>
   * ImmutableRestartPolicy.builder()
   *    .condition(String | null) // nullable {@link RestartPolicy#condition() condition}
   *    .delay(Long | null) // nullable {@link RestartPolicy#delay() delay}
   *    .maxAttempts(Integer | null) // nullable {@link RestartPolicy#maxAttempts() maxAttempts}
   *    .window(Long | null) // nullable {@link RestartPolicy#window() window}
   *    .build();
   * </pre>
   * @return A new ImmutableRestartPolicy builder
   */
  public static ImmutableRestartPolicy.Builder builder() {
    return new ImmutableRestartPolicy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRestartPolicy ImmutableRestartPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements RestartPolicy.Builder {
    private String condition;
    private Long delay;
    private Integer maxAttempts;
    private Long window;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RestartPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RestartPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String conditionValue = instance.condition();
      if (conditionValue != null) {
        condition(conditionValue);
      }
      @Nullable Long delayValue = instance.delay();
      if (delayValue != null) {
        delay(delayValue);
      }
      @Nullable Integer maxAttemptsValue = instance.maxAttempts();
      if (maxAttemptsValue != null) {
        maxAttempts(maxAttemptsValue);
      }
      @Nullable Long windowValue = instance.window();
      if (windowValue != null) {
        window(windowValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RestartPolicy#condition() condition} attribute.
     * @param condition The value for condition (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Condition")
    public final Builder condition(@Nullable String condition) {
      this.condition = condition;
      return this;
    }

    /**
     * Initializes the value for the {@link RestartPolicy#delay() delay} attribute.
     * @param delay The value for delay (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Delay")
    public final Builder delay(@Nullable Long delay) {
      this.delay = delay;
      return this;
    }

    /**
     * Initializes the value for the {@link RestartPolicy#maxAttempts() maxAttempts} attribute.
     * @param maxAttempts The value for maxAttempts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MaxAttempts")
    public final Builder maxAttempts(@Nullable Integer maxAttempts) {
      this.maxAttempts = maxAttempts;
      return this;
    }

    /**
     * Initializes the value for the {@link RestartPolicy#window() window} attribute.
     * @param window The value for window (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Window")
    public final Builder window(@Nullable Long window) {
      this.window = window;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRestartPolicy ImmutableRestartPolicy}.
     * @return An immutable instance of RestartPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRestartPolicy build() {
      return new ImmutableRestartPolicy(condition, delay, maxAttempts, window);
    }
  }
}
