/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.builder;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.glassfish.jersey.apache5.connector.Apache5ConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.mandas.docker.client.DefaultDockerClient;
import org.mandas.docker.client.DockerCertificates;
import org.mandas.docker.client.DockerCertificatesStore;
import org.mandas.docker.client.DockerHost;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.UnixConnectionSocketFactory;
import org.mandas.docker.client.auth.ConfigFileRegistryAuthSupplier;
import org.mandas.docker.client.auth.RegistryAuthSupplier;
import org.mandas.docker.client.builder.ProxyConfiguration;
import org.mandas.docker.client.exceptions.DockerCertificateException;
import org.mandas.docker.client.npipe.NpipeConnectionSocketFactory;

public class DockerClientBuilder {
    private static String UNIX_SCHEME = "unix";
    private static String NPIPE_SCHEME = "npipe";
    private long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private int DEFAULT_CONNECTION_POOL_SIZE = 100;
    private String ERROR_MESSAGE = "LOGIC ERROR: DefaultDockerClient does not support being built with both `registryAuth` and `registryAuthSupplier`. Please build with at most one of these options.";
    private URI uri;
    private String apiVersion;
    private long connectTimeoutMillis = this.DEFAULT_CONNECT_TIMEOUT_MILLIS;
    private long readTimeoutMillis = this.DEFAULT_READ_TIMEOUT_MILLIS;
    private int connectionPoolSize = this.DEFAULT_CONNECTION_POOL_SIZE;
    private DockerCertificatesStore dockerCertificatesStore;
    private boolean useProxy = true;
    private RegistryAuthSupplier registryAuthSupplier;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Client client;
    private EntityProcessing entityProcessing;

    private ClientConfig updateProxy(ClientConfig config) {
        ProxyConfiguration proxyConfiguration = this.proxyFromEnv();
        if (proxyConfiguration == null) {
            return config;
        }
        String proxyHost = proxyConfiguration.host();
        config.property("jersey.config.client.proxy.uri", (Object)((!proxyHost.startsWith("http") ? "http://" : "") + proxyHost + ":" + proxyConfiguration.port()));
        if (proxyConfiguration.username() != null) {
            config.property("jersey.config.client.proxy.username", (Object)proxyConfiguration.username());
        }
        if (proxyConfiguration.password() != null) {
            config.property("jersey.config.client.proxy.password", (Object)proxyConfiguration.password());
        }
        config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        return config;
    }

    private Client createClient() {
        Registry<ConnectionSocketFactory> schemeRegistry = this.getSchemeRegistry(this.uri, this.dockerCertificatesStore);
        HttpClientConnectionManager cm = this.getConnectionManager(this.uri, schemeRegistry, this.connectionPoolSize);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((Duration)Duration.ofMillis(this.connectTimeoutMillis))).setResponseTimeout(Timeout.of((Duration)Duration.ofMillis(this.readTimeoutMillis))).build();
        ClientConfig config = new ClientConfig(new Class[]{JacksonFeature.class});
        if (this.useProxy) {
            config = this.updateProxy(config);
        }
        DefaultHttpRequestRetryStrategy retryStrategy = new DefaultHttpRequestRetryStrategy(0, TimeValue.ZERO_MILLISECONDS);
        config.connectorProvider((ConnectorProvider)new Apache5ConnectorProvider()).property("jersey.config.apache5.client.connectionManager", (Object)cm).property("jersey.config.apache5.client.connectionManagerShared", (Object)"true").property("jersey.config.apache5.client.requestConfig", (Object)requestConfig).property("jersey.config.apache5.client.retryStrategy", (Object)retryStrategy);
        if (this.entityProcessing != null) {
            switch (this.entityProcessing.ordinal()) {
                case 1: {
                    config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
                    break;
                }
                case 0: {
                    config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid entity processing mode " + String.valueOf((Object)this.entityProcessing));
                }
            }
        }
        return ClientBuilder.newBuilder().withConfig((Configuration)config).build();
    }

    public static DockerClientBuilder fromEnv() throws DockerCertificateException {
        String endpoint = DockerHost.endpointFromEnv();
        Path dockerCertPath = Paths.get(Arrays.asList(DockerHost.certPathFromEnv(), DockerHost.configPathFromEnv(), DockerHost.defaultCertPath()).stream().filter(cert -> cert != null).findFirst().orElseThrow(() -> new NoSuchElementException("Cannot find docker certificated path")), new String[0]);
        Optional<DockerCertificatesStore> certs = DockerCertificates.builder().dockerCertPath(dockerCertPath).build();
        URI uri = null;
        if (endpoint.startsWith(UNIX_SCHEME + "://")) {
            uri = URI.create(endpoint);
        } else if (endpoint.startsWith(NPIPE_SCHEME + "://")) {
            uri = URI.create(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            String scheme = certs.isPresent() ? "https" : "http";
            URI initialUri = URI.create(scheme + "://" + stripped);
            if (initialUri.getPort() == -1 && initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DockerHost.defaultAddress() + ":" + DockerHost.defaultPort());
            } else if (initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DockerHost.defaultAddress() + ":" + initialUri.getPort());
            } else if (initialUri.getPort() == -1) {
                initialUri = URI.create(scheme + "://" + initialUri.getHost() + ":" + DockerHost.defaultPort());
            }
            uri = initialUri;
        }
        if (certs.isPresent()) {
            return new DockerClientBuilder(uri, certs.get());
        }
        return new DockerClientBuilder(uri);
    }

    private DockerClientBuilder(URI uri) {
        this(uri, null);
    }

    private DockerClientBuilder(URI uri, DockerCertificatesStore certs) {
        this.uri = uri;
        this.dockerCertificatesStore = certs;
    }

    public DockerClientBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public DockerClientBuilder uri(String uri) {
        return this.uri(URI.create(uri));
    }

    public DockerClientBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public DockerClientBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public DockerClientBuilder readTimeoutMillis(long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public DockerClientBuilder dockerCertificates(DockerCertificatesStore dockerCertificatesStore) {
        this.dockerCertificatesStore = dockerCertificatesStore;
        return this;
    }

    public DockerClientBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public DockerClientBuilder useProxy(boolean useProxy) {
        this.useProxy = useProxy;
        return this;
    }

    public DockerClientBuilder registryAuthSupplier(RegistryAuthSupplier registryAuthSupplier) {
        if (this.registryAuthSupplier != null) {
            throw new IllegalStateException(this.ERROR_MESSAGE);
        }
        this.registryAuthSupplier = registryAuthSupplier;
        return this;
    }

    public DockerClientBuilder header(String name, Object value) {
        this.headers.put(name, value);
        return this;
    }

    public URI uri() {
        return this.uri;
    }

    public DockerClientBuilder entityProcessing(EntityProcessing entityProcessing) {
        this.entityProcessing = entityProcessing;
        return this;
    }

    private String toRegExp(String hostnameWithWildcards) {
        return hostnameWithWildcards.replace(".", "\\.").replace("*", ".*");
    }

    private ProxyConfiguration proxyFromEnv() {
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost == null) {
            return null;
        }
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts != null) {
            String[] nonProxy = nonProxyHosts.replaceAll("^\\s*\"", "").replaceAll("\\s*\"$", "").split("\\|");
            String host = Optional.ofNullable(this.uri.getHost()).orElse("localhost");
            for (String h : nonProxy) {
                if (!host.matches(this.toRegExp(h))) continue;
                return null;
            }
        }
        return ProxyConfiguration.builder().host(proxyHost).port(System.getProperty("http.proxyPort")).username(System.getProperty("http.proxyUser")).password(System.getProperty("http.proxyPassword")).build();
    }

    public DefaultDockerClient build() {
        Objects.requireNonNull(this.uri, "uri");
        Objects.requireNonNull(this.uri.getScheme(), "url has null scheme");
        if (this.dockerCertificatesStore != null && !this.uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("An HTTPS URI for DOCKER_HOST must be provided to use Docker client certificates");
        }
        if (this.uri.getScheme().startsWith(UNIX_SCHEME) || this.uri.getScheme().startsWith(NPIPE_SCHEME)) {
            this.useProxy = false;
        }
        this.client = (Client)this.createClient().register(ObjectMapperProvider.class);
        if (this.uri.getScheme().equals(UNIX_SCHEME)) {
            this.uri = UnixConnectionSocketFactory.sanitizeUri(this.uri);
        } else if (this.uri.getScheme().equals(NPIPE_SCHEME)) {
            this.uri = NpipeConnectionSocketFactory.sanitizeUri(this.uri);
        }
        if (this.registryAuthSupplier == null) {
            this.registryAuthSupplier(new ConfigFileRegistryAuthSupplier());
        }
        return new DefaultDockerClient(this.apiVersion, this.registryAuthSupplier, this.uri, this.client, this.headers);
    }

    private HttpClientConnectionManager getConnectionManager(URI uri, Registry<ConnectionSocketFactory> schemeRegistry, int connectionPoolSize) {
        if (uri.getScheme().equals(NPIPE_SCHEME)) {
            return new BasicHttpClientConnectionManager(schemeRegistry);
        }
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.of((Duration)Duration.ofMillis(this.connectTimeoutMillis))).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(connectionPoolSize);
        cm.setConnectionConfigResolver(route -> connectionConfig);
        cm.setDefaultMaxPerRoute(cm.getMaxTotal());
        return cm;
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(URI uri, DockerCertificatesStore certificateStore) {
        SSLConnectionSocketFactory https = this.dockerCertificatesStore == null ? SSLConnectionSocketFactory.getSocketFactory() : new SSLConnectionSocketFactory(this.dockerCertificatesStore.sslContext(), this.dockerCertificatesStore.hostnameVerifier());
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("https", (Object)https).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (uri.getScheme().equals(UNIX_SCHEME)) {
            registryBuilder.register(UNIX_SCHEME, (Object)new UnixConnectionSocketFactory(uri));
        }
        if (uri.getScheme().equals(NPIPE_SCHEME)) {
            registryBuilder.register(NPIPE_SCHEME, (Object)new NpipeConnectionSocketFactory(uri));
        }
        return registryBuilder.build();
    }

    public static enum EntityProcessing {
        CHUNKED,
        BUFFERED;

    }
}

