/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageEnvironmentTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageLabelsTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageLinksTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageMainTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageNetworkTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImagePortsTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageResourcesTab;
import org.eclipse.linuxtools.internal.docker.ui.launch.RunImageVolumesTab;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunNetworkModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;

public class RunImageLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private ImageRunSelectionModel runSelectionModel;
    private ImageRunResourceVolumesVariablesModel runVolumesModel;
    private ImageRunNetworkModel runNetworkModel;

    public ImageRunSelectionModel getRunSelectionModel() {
        return this.runSelectionModel;
    }

    public ImageRunResourceVolumesVariablesModel getRunVolumesModel() {
        return this.runVolumesModel;
    }

    public ImageRunNetworkModel getRunNetworkModel() {
        return this.runNetworkModel;
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.runSelectionModel = null;
        this.runVolumesModel = null;
        this.runNetworkModel = null;
        if (DockerConnectionManager.getInstance().hasConnections()) {
            this.runSelectionModel = new ImageRunSelectionModel(CommandUtils.getCurrentConnection(null));
            this.runNetworkModel = new ImageRunNetworkModel(CommandUtils.getCurrentConnection(null));
            try {
                this.runVolumesModel = new ImageRunResourceVolumesVariablesModel(CommandUtils.getCurrentConnection(null));
            }
            catch (DockerException dockerException) {
                // empty catch block
            }
        }
        this.setTabs((ILaunchConfigurationTab[])new AbstractLaunchConfigurationTab[]{new RunImageMainTab(this.runSelectionModel, this.runVolumesModel, this.runNetworkModel), new RunImageVolumesTab(this.runVolumesModel), new RunImagePortsTab(this.runSelectionModel), new RunImageLinksTab(this.runSelectionModel), new RunImageNetworkTab(this.runNetworkModel), new RunImageEnvironmentTab(this.runVolumesModel), new RunImageLabelsTab(this.runVolumesModel), new RunImageResourcesTab(this.runVolumesModel), new CommonTab()});
    }
}

